/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.binding.Proxy;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.DefaultWatchEditor;
import ch.cyberduck.core.io.watchservice.FSEventWatchService;
import ch.cyberduck.core.io.watchservice.RegisterWatchService;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.local.FileWatcher;
import ch.cyberduck.core.local.FileWatcherListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;

public class FSEventWatchEditor
extends DefaultWatchEditor {
    private static final Logger log = LogManager.getLogger(FSEventWatchEditor.class);
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();
    private final Map<Application, Set<ApplicationQuitCallback>> registered = new HashMap<Application, Set<ApplicationQuitCallback>>();
    private final Proxy terminate = new Proxy(){

        public void terminated(NSNotification notification) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Received notification %s from workspace", notification.userInfo()));
            }
            if (notification.userInfo().objectForKey("NSApplicationBundleIdentifier") == null) {
                log.warn("Missing NSApplicationBundleIdentifier in notification dictionary");
                return;
            }
            Application application = new Application(notification.userInfo().objectForKey("NSApplicationBundleIdentifier").toString());
            for (ApplicationQuitCallback callback : FSEventWatchEditor.this.registered.getOrDefault(application, Collections.emptySet())) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Run quit callback %s for application %s", callback, application));
                }
                callback.callback();
            }
        }
    };

    public FSEventWatchEditor(Host host, Path file, ProgressListener listener) {
        super(host, file, listener, new FileWatcher((RegisterWatchService)new FSEventWatchService()));
        this.workspace.notificationCenter().addObserver(this.terminate.id(), Foundation.selector((String)"terminated:"), "NSWorkspaceDidTerminateApplicationNotification", null);
    }

    protected void watch(Application application, Local temporary, FileWatcherListener listener, ApplicationQuitCallback quit) throws IOException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Register application %s for terminate callback %s", application, quit));
        }
        Set callbacks = this.registered.getOrDefault(application, new HashSet());
        callbacks.add(quit);
        this.registered.putIfAbsent(application, callbacks);
        super.watch(application, temporary, listener, quit);
    }

    public void close() {
        log.warn(String.format("Remove observer %s", this.terminate));
        this.workspace.notificationCenter().removeObserver(this.terminate.id());
        super.close();
    }
}

