/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="A standard representation of a user, as returned from any user API endpoints by default")
public class User {
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="modified_at")
    private DateTime modifiedAt = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="timezone")
    private String timezone = null;
    @JsonProperty(value="space_amount")
    private Long spaceAmount = null;
    @JsonProperty(value="space_used")
    private Long spaceUsed = null;
    @JsonProperty(value="max_upload_size")
    private Long maxUploadSize = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="job_title")
    private String jobTitle = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="address")
    private String address = null;
    @JsonProperty(value="avatar_url")
    private String avatarUrl = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="login")
    private String login = null;

    public User createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the user object was created")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public User modifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the user object was last modified")
    public DateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public User language(String language) {
        this.language = language;
        return this;
    }

    @Schema(example="en", description="The language of the user, formatted in modified version of the [ISO 639-1](/guides/api-calls/language-codes) format.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public User timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Schema(example="Africa/Bujumbura", description="The user's timezone")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public User spaceAmount(Long spaceAmount) {
        this.spaceAmount = spaceAmount;
        return this;
    }

    @Schema(example="11345156112", description="The user\u2019s total available space amount in bytes")
    public Long getSpaceAmount() {
        return this.spaceAmount;
    }

    public void setSpaceAmount(Long spaceAmount) {
        this.spaceAmount = spaceAmount;
    }

    public User spaceUsed(Long spaceUsed) {
        this.spaceUsed = spaceUsed;
        return this;
    }

    @Schema(example="1237009912", description="The amount of space in use by the user")
    public Long getSpaceUsed() {
        return this.spaceUsed;
    }

    public void setSpaceUsed(Long spaceUsed) {
        this.spaceUsed = spaceUsed;
    }

    public User maxUploadSize(Long maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
        return this;
    }

    @Schema(example="2147483648", description="The maximum individual file size in bytes the user can have")
    public Long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(Long maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public User status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(example="active", description="The user's account status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public User jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @Schema(example="CEO", description="The user\u2019s job title")
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public User phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(example="6509241374", description="The user\u2019s phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public User address(String address) {
        this.address = address;
        return this;
    }

    @Schema(example="900 Jefferson Ave, Redwood City, CA 94063", description="The user\u2019s address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public User avatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @Schema(example="https://www.box.com/api/avatar/large/181216415", description="URL of the user\u2019s avatar image")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public User name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Aaron Levie", description="The display name of this user")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User login(String login) {
        this.login = login;
        return this;
    }

    @Schema(example="ceo@example.com", description="The primary email address of this user")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.createdAt, user.createdAt) && Objects.equals(this.modifiedAt, user.modifiedAt) && Objects.equals(this.language, user.language) && Objects.equals(this.timezone, user.timezone) && Objects.equals(this.spaceAmount, user.spaceAmount) && Objects.equals(this.spaceUsed, user.spaceUsed) && Objects.equals(this.maxUploadSize, user.maxUploadSize) && Objects.equals((Object)this.status, (Object)user.status) && Objects.equals(this.jobTitle, user.jobTitle) && Objects.equals(this.phone, user.phone) && Objects.equals(this.address, user.address) && Objects.equals(this.avatarUrl, user.avatarUrl) && Objects.equals(this.name, user.name) && Objects.equals(this.login, user.login);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.modifiedAt, this.language, this.timezone, this.spaceAmount, this.spaceUsed, this.maxUploadSize, this.status, this.jobTitle, this.phone, this.address, this.avatarUrl, this.name, this.login});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    spaceAmount: ").append(this.toIndentedString(this.spaceAmount)).append("\n");
        sb.append("    spaceUsed: ").append(this.toIndentedString(this.spaceUsed)).append("\n");
        sb.append("    maxUploadSize: ").append(this.toIndentedString(this.maxUploadSize)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive"),
        CANNOT_DELETE_EDIT("cannot_delete_edit"),
        CANNOT_DELETE_EDIT_UPLOAD("cannot_delete_edit_upload");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

