/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.AllOfUploadSessionSessionEndpoints;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="An upload session for chunk uploading a file.")
public class UploadSession {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="session_expires_at")
    private DateTime sessionExpiresAt = null;
    @JsonProperty(value="part_size")
    private Long partSize = null;
    @JsonProperty(value="total_parts")
    private Integer totalParts = null;
    @JsonProperty(value="num_parts_processed")
    private Integer numPartsProcessed = null;
    @JsonProperty(value="session_endpoints")
    private AllOfUploadSessionSessionEndpoints sessionEndpoints = null;

    public UploadSession id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="F971964745A5CD0C001BBE4E58196BFD", description="The unique identifier for this session")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UploadSession type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="upload_session", description="`upload_session`")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UploadSession sessionExpiresAt(DateTime sessionExpiresAt) {
        this.sessionExpiresAt = sessionExpiresAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time when this session expires.")
    public DateTime getSessionExpiresAt() {
        return this.sessionExpiresAt;
    }

    public void setSessionExpiresAt(DateTime sessionExpiresAt) {
        this.sessionExpiresAt = sessionExpiresAt;
    }

    public UploadSession partSize(Long partSize) {
        this.partSize = partSize;
        return this;
    }

    @Schema(example="1024", description="The  size in bytes that must be used for all parts of of the upload.  Only the last part is allowed to be of a smaller size.")
    public Long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(Long partSize) {
        this.partSize = partSize;
    }

    public UploadSession totalParts(Integer totalParts) {
        this.totalParts = totalParts;
        return this;
    }

    @Schema(example="1000", description="The total number of parts expected in this upload session, as determined by the file size and part size.")
    public Integer getTotalParts() {
        return this.totalParts;
    }

    public void setTotalParts(Integer totalParts) {
        this.totalParts = totalParts;
    }

    public UploadSession numPartsProcessed(Integer numPartsProcessed) {
        this.numPartsProcessed = numPartsProcessed;
        return this;
    }

    @Schema(example="455", description="The number of parts that have been uploaded and processed by the server. This starts at `0`.  When committing a file files, inspecting this property can provide insight if all parts have been uploaded correctly.")
    public Integer getNumPartsProcessed() {
        return this.numPartsProcessed;
    }

    public void setNumPartsProcessed(Integer numPartsProcessed) {
        this.numPartsProcessed = numPartsProcessed;
    }

    public UploadSession sessionEndpoints(AllOfUploadSessionSessionEndpoints sessionEndpoints) {
        this.sessionEndpoints = sessionEndpoints;
        return this;
    }

    @Schema(description="")
    public AllOfUploadSessionSessionEndpoints getSessionEndpoints() {
        return this.sessionEndpoints;
    }

    public void setSessionEndpoints(AllOfUploadSessionSessionEndpoints sessionEndpoints) {
        this.sessionEndpoints = sessionEndpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadSession uploadSession = (UploadSession)o;
        return Objects.equals(this.id, uploadSession.id) && Objects.equals((Object)this.type, (Object)uploadSession.type) && Objects.equals(this.sessionExpiresAt, uploadSession.sessionExpiresAt) && Objects.equals(this.partSize, uploadSession.partSize) && Objects.equals(this.totalParts, uploadSession.totalParts) && Objects.equals(this.numPartsProcessed, uploadSession.numPartsProcessed) && Objects.equals(this.sessionEndpoints, uploadSession.sessionEndpoints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.sessionExpiresAt, this.partSize, this.totalParts, this.numPartsProcessed, this.sessionEndpoints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    sessionExpiresAt: ").append(this.toIndentedString(this.sessionExpiresAt)).append("\n");
        sb.append("    partSize: ").append(this.toIndentedString(this.partSize)).append("\n");
        sb.append("    totalParts: ").append(this.toIndentedString(this.totalParts)).append("\n");
        sb.append("    numPartsProcessed: ").append(this.toIndentedString(this.numPartsProcessed)).append("\n");
        sb.append("    sessionEndpoints: ").append(this.toIndentedString(this.sessionEndpoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        UPLOAD_SESSION("upload_session");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

