/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.FoldersParent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class FoldersBody {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="parent")
    private FoldersParent parent = null;
    @JsonProperty(value="folder_upload_email")
    private Object folderUploadEmail = null;
    @JsonProperty(value="sync_state")
    private SyncStateEnum syncState = null;

    public FoldersBody name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="New Folder", required=true, description="The name for the new folder.  There are some restrictions to the file name. Names containing non-printable ASCII characters, forward and backward slashes (`/`, `\\`), as well as names with trailing spaces are prohibited.  Additionally, the names `.` and `..` are not allowed either.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FoldersBody parent(FoldersParent parent) {
        this.parent = parent;
        return this;
    }

    @Schema(required=true, description="")
    public FoldersParent getParent() {
        return this.parent;
    }

    public void setParent(FoldersParent parent) {
        this.parent = parent;
    }

    public FoldersBody folderUploadEmail(Object folderUploadEmail) {
        this.folderUploadEmail = folderUploadEmail;
        return this;
    }

    @Schema(description="")
    public Object getFolderUploadEmail() {
        return this.folderUploadEmail;
    }

    public void setFolderUploadEmail(Object folderUploadEmail) {
        this.folderUploadEmail = folderUploadEmail;
    }

    public FoldersBody syncState(SyncStateEnum syncState) {
        this.syncState = syncState;
        return this;
    }

    @Schema(example="synced", description="Specifies whether a folder should be synced to a user's device or not. This is used by Box Sync (discontinued) and is not used by Box Drive.")
    public SyncStateEnum getSyncState() {
        return this.syncState;
    }

    public void setSyncState(SyncStateEnum syncState) {
        this.syncState = syncState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoldersBody foldersBody = (FoldersBody)o;
        return Objects.equals(this.name, foldersBody.name) && Objects.equals(this.parent, foldersBody.parent) && Objects.equals(this.folderUploadEmail, foldersBody.folderUploadEmail) && Objects.equals((Object)this.syncState, (Object)foldersBody.syncState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.parent, this.folderUploadEmail, this.syncState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FoldersBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    folderUploadEmail: ").append(this.toIndentedString(this.folderUploadEmail)).append("\n");
        sb.append("    syncState: ").append(this.toIndentedString((Object)this.syncState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SyncStateEnum {
        SYNCED("synced"),
        NOT_SYNCED("not_synced"),
        PARTIALLY_SYNCED("partially_synced");

        private String value;

        private SyncStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SyncStateEnum fromValue(String text) {
            for (SyncStateEnum b : SyncStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

