/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Defines if this link allows a user to preview and download an item.")
public class FolderSharedLinkPermissions {
    @JsonProperty(value="can_download")
    private Boolean canDownload = null;
    @JsonProperty(value="can_preview")
    private Boolean canPreview = null;

    public FolderSharedLinkPermissions canDownload(Boolean canDownload) {
        this.canDownload = canDownload;
        return this;
    }

    @Schema(example="true", description="Defines if the shared link allows for the item to be downloaded. For shared links on folders, this also applies to any items in the folder.  This value can be set to `true` when the effective access level is set to `open` or `company`, not `collaborators`.")
    public Boolean isCanDownload() {
        return this.canDownload;
    }

    public void setCanDownload(Boolean canDownload) {
        this.canDownload = canDownload;
    }

    public FolderSharedLinkPermissions canPreview(Boolean canPreview) {
        this.canPreview = canPreview;
        return this;
    }

    @Schema(example="true", description="Defines if the shared link allows for the item to be previewed.  This value is always `true`. For shared links on folders this also applies to any items in the folder.")
    public Boolean isCanPreview() {
        return this.canPreview;
    }

    public void setCanPreview(Boolean canPreview) {
        this.canPreview = canPreview;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FolderSharedLinkPermissions folderSharedLinkPermissions = (FolderSharedLinkPermissions)o;
        return Objects.equals(this.canDownload, folderSharedLinkPermissions.canDownload) && Objects.equals(this.canPreview, folderSharedLinkPermissions.canPreview);
    }

    public int hashCode() {
        return Objects.hash(this.canDownload, this.canPreview);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FolderSharedLinkPermissions {\n");
        sb.append("    canDownload: ").append(this.toIndentedString(this.canDownload)).append("\n");
        sb.append("    canPreview: ").append(this.toIndentedString(this.canPreview)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

