/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.FolderSharedLinkPermissions;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

public class FolderSharedLink {
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="download_url")
    private String downloadUrl = null;
    @JsonProperty(value="vanity_url")
    private String vanityUrl = null;
    @JsonProperty(value="vanity_name")
    private String vanityName = null;
    @JsonProperty(value="access")
    private AccessEnum access = null;
    @JsonProperty(value="effective_access")
    private EffectiveAccessEnum effectiveAccess = null;
    @JsonProperty(value="effective_permission")
    private EffectivePermissionEnum effectivePermission = null;
    @JsonProperty(value="unshared_at")
    private DateTime unsharedAt = null;
    @JsonProperty(value="is_password_enabled")
    private Boolean isPasswordEnabled = null;
    @JsonProperty(value="permissions")
    private FolderSharedLinkPermissions permissions = null;
    @JsonProperty(value="download_count")
    private Integer downloadCount = null;
    @JsonProperty(value="preview_count")
    private Integer previewCount = null;

    public FolderSharedLink url(String url) {
        this.url = url;
        return this;
    }

    @Schema(example="https://www.box.com/s/vspke7y05sb214wjokpk", description="The URL that can be used to access the item on Box.  This URL will display the item in Box's preview UI where the file can be downloaded if allowed.  This URL will continue to work even when a custom `vanity_url` has been set for this shared link.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FolderSharedLink downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @Schema(example="https://www.box.com/shared/static/rh935iit6ewrmw0unyul.jpeg", description="A URL that can be used to download the file. This URL can be used in a browser to download the file. This URL includes the file extension so that the file will be saved with the right file type.  This property will be `null` for folders.")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public FolderSharedLink vanityUrl(String vanityUrl) {
        this.vanityUrl = vanityUrl;
        return this;
    }

    @Schema(example="https://acme.app.box.com/v/my_url/", description="The \"Custom URL\" that can also be used to preview the item on Box.  Custom URLs can only be created or modified in the Box Web application.")
    public String getVanityUrl() {
        return this.vanityUrl;
    }

    public void setVanityUrl(String vanityUrl) {
        this.vanityUrl = vanityUrl;
    }

    public FolderSharedLink vanityName(String vanityName) {
        this.vanityName = vanityName;
        return this;
    }

    @Schema(example="my_url", description="The custom name of a shared link, as used in the `vanity_url` field.")
    public String getVanityName() {
        return this.vanityName;
    }

    public void setVanityName(String vanityName) {
        this.vanityName = vanityName;
    }

    public FolderSharedLink access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @Schema(example="open", description="The access level for this shared link.  * `open` - provides access to this item to anyone with this link * `company` - only provides access to this item to people the same company * `collaborators` - only provides access to this item to people who are    collaborators on this item  If this field is omitted when creating the shared link, the access level will be set to the default access level specified by the enterprise admin.")
    public AccessEnum getAccess() {
        return this.access;
    }

    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public FolderSharedLink effectiveAccess(EffectiveAccessEnum effectiveAccess) {
        this.effectiveAccess = effectiveAccess;
        return this;
    }

    @Schema(example="company", description="The effective access level for the shared link. This can be a more restrictive access level than the value in the `access` field when the enterprise settings restrict the allowed access levels.")
    public EffectiveAccessEnum getEffectiveAccess() {
        return this.effectiveAccess;
    }

    public void setEffectiveAccess(EffectiveAccessEnum effectiveAccess) {
        this.effectiveAccess = effectiveAccess;
    }

    public FolderSharedLink effectivePermission(EffectivePermissionEnum effectivePermission) {
        this.effectivePermission = effectivePermission;
        return this;
    }

    @Schema(example="can_download", description="The effective permissions for this shared link.")
    public EffectivePermissionEnum getEffectivePermission() {
        return this.effectivePermission;
    }

    public void setEffectivePermission(EffectivePermissionEnum effectivePermission) {
        this.effectivePermission = effectivePermission;
    }

    public FolderSharedLink unsharedAt(DateTime unsharedAt) {
        this.unsharedAt = unsharedAt;
        return this;
    }

    @Schema(example="2018-04-13T13:53:23-07:00", description="The date and time when this link will be unshared. This field can only be set by users with paid accounts.")
    public DateTime getUnsharedAt() {
        return this.unsharedAt;
    }

    public void setUnsharedAt(DateTime unsharedAt) {
        this.unsharedAt = unsharedAt;
    }

    public FolderSharedLink isPasswordEnabled(Boolean isPasswordEnabled) {
        this.isPasswordEnabled = isPasswordEnabled;
        return this;
    }

    @Schema(example="true", description="Defines if the shared link requires a password to access the item.")
    public Boolean isIsPasswordEnabled() {
        return this.isPasswordEnabled;
    }

    public void setIsPasswordEnabled(Boolean isPasswordEnabled) {
        this.isPasswordEnabled = isPasswordEnabled;
    }

    public FolderSharedLink permissions(FolderSharedLinkPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @Schema(description="")
    public FolderSharedLinkPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(FolderSharedLinkPermissions permissions) {
        this.permissions = permissions;
    }

    public FolderSharedLink downloadCount(Integer downloadCount) {
        this.downloadCount = downloadCount;
        return this;
    }

    @Schema(example="3", description="The number of times this item has been downloaded.")
    public Integer getDownloadCount() {
        return this.downloadCount;
    }

    public void setDownloadCount(Integer downloadCount) {
        this.downloadCount = downloadCount;
    }

    public FolderSharedLink previewCount(Integer previewCount) {
        this.previewCount = previewCount;
        return this;
    }

    @Schema(example="3", description="The number of times this item has been previewed.")
    public Integer getPreviewCount() {
        return this.previewCount;
    }

    public void setPreviewCount(Integer previewCount) {
        this.previewCount = previewCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FolderSharedLink folderSharedLink = (FolderSharedLink)o;
        return Objects.equals(this.url, folderSharedLink.url) && Objects.equals(this.downloadUrl, folderSharedLink.downloadUrl) && Objects.equals(this.vanityUrl, folderSharedLink.vanityUrl) && Objects.equals(this.vanityName, folderSharedLink.vanityName) && Objects.equals((Object)this.access, (Object)folderSharedLink.access) && Objects.equals((Object)this.effectiveAccess, (Object)folderSharedLink.effectiveAccess) && Objects.equals((Object)this.effectivePermission, (Object)folderSharedLink.effectivePermission) && Objects.equals(this.unsharedAt, folderSharedLink.unsharedAt) && Objects.equals(this.isPasswordEnabled, folderSharedLink.isPasswordEnabled) && Objects.equals(this.permissions, folderSharedLink.permissions) && Objects.equals(this.downloadCount, folderSharedLink.downloadCount) && Objects.equals(this.previewCount, folderSharedLink.previewCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.downloadUrl, this.vanityUrl, this.vanityName, this.access, this.effectiveAccess, this.effectivePermission, this.unsharedAt, this.isPasswordEnabled, this.permissions, this.downloadCount, this.previewCount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FolderSharedLink {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    vanityUrl: ").append(this.toIndentedString(this.vanityUrl)).append("\n");
        sb.append("    vanityName: ").append(this.toIndentedString(this.vanityName)).append("\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    effectiveAccess: ").append(this.toIndentedString((Object)this.effectiveAccess)).append("\n");
        sb.append("    effectivePermission: ").append(this.toIndentedString((Object)this.effectivePermission)).append("\n");
        sb.append("    unsharedAt: ").append(this.toIndentedString(this.unsharedAt)).append("\n");
        sb.append("    isPasswordEnabled: ").append(this.toIndentedString(this.isPasswordEnabled)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    downloadCount: ").append(this.toIndentedString(this.downloadCount)).append("\n");
        sb.append("    previewCount: ").append(this.toIndentedString(this.previewCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessEnum {
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessEnum fromValue(String text) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum EffectiveAccessEnum {
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private String value;

        private EffectiveAccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectiveAccessEnum fromValue(String text) {
            for (EffectiveAccessEnum b : EffectiveAccessEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum EffectivePermissionEnum {
        DOWNLOAD("can_download"),
        PREVIEW("can_preview");

        private String value;

        private EffectivePermissionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectivePermissionEnum fromValue(String text) {
            for (EffectivePermissionEnum b : EffectivePermissionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

