/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.FileSharedLink;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="A standard representation of a folder, as returned from any folder API endpoints by default")
public class Folder {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="etag")
    private String etag = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="folder_id")
    private String folderId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="modified_at")
    private DateTime modifiedAt = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="trashed_at")
    private DateTime trashedAt = null;
    @JsonProperty(value="purged_at")
    private DateTime purgedAt = null;
    @JsonProperty(value="content_created_at")
    private DateTime contentCreatedAt = null;
    @JsonProperty(value="content_modified_at")
    private DateTime contentModifiedAt = null;
    @JsonProperty(value="expires_at")
    private DateTime expiresAt = null;
    @JsonProperty(value="shared_link")
    private FileSharedLink sharedLink = null;
    @JsonProperty(value="parent")
    private Folder parent = null;

    public Folder id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="12345", description="The unique identifier that represent a folder.  The ID for any folder can be determined by visiting a folder in the web application and copying the ID from the URL. For example, for the URL `https://_*.app.box.com/folders/123` the `folder_id` is `123`.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Folder etag(String etag) {
        this.etag = etag;
        return this;
    }

    @Schema(example="1", description="The HTTP `etag` of this folder. This can be used within some API endpoints in the `If-Match` and `If-None-Match` headers to only perform changes on the folder if (no) changes have happened.")
    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public Folder type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="folder", description="`folder`")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Folder folderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    @Schema(example="3", description="A numeric identifier that represents the most recent user event that has been applied to this item.  This can be used in combination with the `GET /events`-endpoint to filter out user events that would have occurred before this identifier was read.  An example would be where a Box Drive-like application would fetch an item via the API, and then listen to incoming user events for changes to the item. The application would ignore any user events where the `sequence_id` in the event is smaller than or equal to the `sequence_id` in the originally fetched resource.")
    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public Folder name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Contracts", description="The name of the folder.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Folder createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time when the folder was created. This value may be `null` for some folders such as the root folder or the trash folder.")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Folder modifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time when the folder was last updated. This value may be `null` for some folders such as the root folder or the trash folder.")
    public DateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Folder size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(example="629644", description="The folder size in bytes.  Be careful parsing this integer as its value can get very large.")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Folder trashedAt(DateTime trashedAt) {
        this.trashedAt = trashedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The time at which this folder was put in the trash.")
    public DateTime getTrashedAt() {
        return this.trashedAt;
    }

    public void setTrashedAt(DateTime trashedAt) {
        this.trashedAt = trashedAt;
    }

    public Folder purgedAt(DateTime purgedAt) {
        this.purgedAt = purgedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The time at which this folder is expected to be purged from the trash.")
    public DateTime getPurgedAt() {
        return this.purgedAt;
    }

    public void setPurgedAt(DateTime purgedAt) {
        this.purgedAt = purgedAt;
    }

    public Folder contentCreatedAt(DateTime contentCreatedAt) {
        this.contentCreatedAt = contentCreatedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time at which this folder was originally created.")
    public DateTime getContentCreatedAt() {
        return this.contentCreatedAt;
    }

    public void setContentCreatedAt(DateTime contentCreatedAt) {
        this.contentCreatedAt = contentCreatedAt;
    }

    public Folder contentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time at which this folder was last updated.")
    public DateTime getContentModifiedAt() {
        return this.contentModifiedAt;
    }

    public void setContentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
    }

    public Folder expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The time and which the folder will be automatically be deleted.")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Folder sharedLink(FileSharedLink sharedLink) {
        this.sharedLink = sharedLink;
        return this;
    }

    @Schema(description="")
    public FileSharedLink getSharedLink() {
        return this.sharedLink;
    }

    public void setSharedLink(FileSharedLink sharedLink) {
        this.sharedLink = sharedLink;
    }

    public Folder parent(Folder parent) {
        this.parent = parent;
        return this;
    }

    @Schema(description="")
    public Folder getParent() {
        return this.parent;
    }

    public void setParent(Folder parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Folder folder = (Folder)o;
        return Objects.equals(this.id, folder.id) && Objects.equals(this.etag, folder.etag) && Objects.equals((Object)this.type, (Object)folder.type) && Objects.equals(this.folderId, folder.folderId) && Objects.equals(this.name, folder.name) && Objects.equals(this.createdAt, folder.createdAt) && Objects.equals(this.modifiedAt, folder.modifiedAt) && Objects.equals(this.size, folder.size) && Objects.equals(this.trashedAt, folder.trashedAt) && Objects.equals(this.purgedAt, folder.purgedAt) && Objects.equals(this.contentCreatedAt, folder.contentCreatedAt) && Objects.equals(this.contentModifiedAt, folder.contentModifiedAt) && Objects.equals(this.expiresAt, folder.expiresAt) && Objects.equals(this.sharedLink, folder.sharedLink) && Objects.equals(this.parent, folder.parent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.etag, this.type, this.folderId, this.name, this.createdAt, this.modifiedAt, this.size, this.trashedAt, this.purgedAt, this.contentCreatedAt, this.contentModifiedAt, this.expiresAt, this.sharedLink, this.parent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Folder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    etag: ").append(this.toIndentedString(this.etag)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    folderId: ").append(this.toIndentedString(this.folderId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    trashedAt: ").append(this.toIndentedString(this.trashedAt)).append("\n");
        sb.append("    purgedAt: ").append(this.toIndentedString(this.purgedAt)).append("\n");
        sb.append("    contentCreatedAt: ").append(this.toIndentedString(this.contentCreatedAt)).append("\n");
        sb.append("    contentModifiedAt: ").append(this.toIndentedString(this.contentModifiedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    sharedLink: ").append(this.toIndentedString(this.sharedLink)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FOLDER("folder");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

