/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="The additional attributes of the file being uploaded. Mainly the name and the parent folder. These attributes are part of the multi part request body and are in JSON format.  <Message warning>    The `attributes` part of the body must come **before** the   `file` part. Requests that do not follow this format when   uploading the file will receive a HTTP `400` error with a   `metadata_after_file_contents` error code.  </Message>")
public class FilesfileIdcontentAttributes {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="content_modified_at")
    private DateTime contentModifiedAt = null;

    public FilesfileIdcontentAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Photo 2.0.png", required=true, description="An optional new name for the file. If specified, the file will be renamed when the new version is uploaded.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FilesfileIdcontentAttributes contentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="Defines the time the file was last modified at.  If not set, the upload time will be used.")
    public DateTime getContentModifiedAt() {
        return this.contentModifiedAt;
    }

    public void setContentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilesfileIdcontentAttributes filesfileIdcontentAttributes = (FilesfileIdcontentAttributes)o;
        return Objects.equals(this.name, filesfileIdcontentAttributes.name) && Objects.equals(this.contentModifiedAt, filesfileIdcontentAttributes.contentModifiedAt);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.contentModifiedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilesfileIdcontentAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    contentModifiedAt: ").append(this.toIndentedString(this.contentModifiedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

