/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Defines a lock on an item. This prevents the item from being moved, renamed, or otherwise changed by anyone other than the user who created the lock.  Set this to `null` to remove the lock.")
public class FilesfileIdLock {
    @JsonProperty(value="access")
    private AccessEnum access = null;
    @JsonProperty(value="expires_at")
    private DateTime expiresAt = null;
    @JsonProperty(value="is_download_prevented")
    private Boolean isDownloadPrevented = null;

    public FilesfileIdLock access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @Schema(example="lock", description="The type of this object.")
    public AccessEnum getAccess() {
        return this.access;
    }

    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public FilesfileIdLock expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="Defines the time at which the lock expires.")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public FilesfileIdLock isDownloadPrevented(Boolean isDownloadPrevented) {
        this.isDownloadPrevented = isDownloadPrevented;
        return this;
    }

    @Schema(example="true", description="Defines if the file can be downloaded while it is locked.")
    public Boolean isIsDownloadPrevented() {
        return this.isDownloadPrevented;
    }

    public void setIsDownloadPrevented(Boolean isDownloadPrevented) {
        this.isDownloadPrevented = isDownloadPrevented;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilesfileIdLock filesfileIdLock = (FilesfileIdLock)o;
        return Objects.equals((Object)this.access, (Object)filesfileIdLock.access) && Objects.equals(this.expiresAt, filesfileIdLock.expiresAt) && Objects.equals(this.isDownloadPrevented, filesfileIdLock.isDownloadPrevented);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.expiresAt, this.isDownloadPrevented});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilesfileIdLock {\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    isDownloadPrevented: ").append(this.toIndentedString(this.isDownloadPrevented)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessEnum {
        LOCK("lock");

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessEnum fromValue(String text) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

