/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.FilescontentAttributesParent;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="The additional attributes of the file being uploaded. Mainly the name and the parent folder. These attributes are part of the multi part request body and are in JSON format.  <Message warning>    The `attributes` part of the body must come **before** the   `file` part. Requests that do not follow this format when   uploading the file will receive a HTTP `400` error with a   `metadata_after_file_contents` error code.  </Message>")
public class FilescontentAttributes {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="parent")
    private FilescontentAttributesParent parent = null;
    @JsonProperty(value="content_created_at")
    private DateTime contentCreatedAt = null;
    @JsonProperty(value="content_modified_at")
    private DateTime contentModifiedAt = null;

    public FilescontentAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Photo.png", required=true, description="The name of the file")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FilescontentAttributes parent(FilescontentAttributesParent parent) {
        this.parent = parent;
        return this;
    }

    @Schema(required=true, description="")
    public FilescontentAttributesParent getParent() {
        return this.parent;
    }

    public void setParent(FilescontentAttributesParent parent) {
        this.parent = parent;
    }

    public FilescontentAttributes contentCreatedAt(DateTime contentCreatedAt) {
        this.contentCreatedAt = contentCreatedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="Defines the time the file was originally created at.  If not set, the upload time will be used.")
    public DateTime getContentCreatedAt() {
        return this.contentCreatedAt;
    }

    public void setContentCreatedAt(DateTime contentCreatedAt) {
        this.contentCreatedAt = contentCreatedAt;
    }

    public FilescontentAttributes contentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="Defines the time the file was last modified at.  If not set, the upload time will be used.")
    public DateTime getContentModifiedAt() {
        return this.contentModifiedAt;
    }

    public void setContentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilescontentAttributes filescontentAttributes = (FilescontentAttributes)o;
        return Objects.equals(this.name, filescontentAttributes.name) && Objects.equals(this.parent, filescontentAttributes.parent) && Objects.equals(this.contentCreatedAt, filescontentAttributes.contentCreatedAt) && Objects.equals(this.contentModifiedAt, filescontentAttributes.contentModifiedAt);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent, this.contentCreatedAt, this.contentModifiedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilescontentAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    contentCreatedAt: ").append(this.toIndentedString(this.contentCreatedAt)).append("\n");
        sb.append("    contentModifiedAt: ").append(this.toIndentedString(this.contentModifiedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

