/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="A standard representation of a file version")
public class FileVersion {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="modified_at")
    private DateTime modifiedAt = null;
    @JsonProperty(value="trashed_at")
    private DateTime trashedAt = null;
    @JsonProperty(value="restored_at")
    private DateTime restoredAt = null;
    @JsonProperty(value="purged_at")
    private DateTime purgedAt = null;
    @JsonProperty(value="uploader_display_name")
    private String uploaderDisplayName = null;
    @JsonProperty(value="sha1")
    private String sha1 = null;

    public FileVersion id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="12345", description="The unique identifier that represent a file version.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FileVersion type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="file_version", description="`file_version`")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FileVersion name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="tigers.jpeg", description="The name of the file version")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileVersion size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(example="629644", description="Size of the file version in bytes")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public FileVersion createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the file version object was created")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public FileVersion modifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the file version object was last updated")
    public DateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public FileVersion trashedAt(DateTime trashedAt) {
        this.trashedAt = trashedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the file version object was trashed.")
    public DateTime getTrashedAt() {
        return this.trashedAt;
    }

    public void setTrashedAt(DateTime trashedAt) {
        this.trashedAt = trashedAt;
    }

    public FileVersion restoredAt(DateTime restoredAt) {
        this.restoredAt = restoredAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the file version was restored from the trash.")
    public DateTime getRestoredAt() {
        return this.restoredAt;
    }

    public void setRestoredAt(DateTime restoredAt) {
        this.restoredAt = restoredAt;
    }

    public FileVersion purgedAt(DateTime purgedAt) {
        this.purgedAt = purgedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the file version object will be permanently deleted.")
    public DateTime getPurgedAt() {
        return this.purgedAt;
    }

    public void setPurgedAt(DateTime purgedAt) {
        this.purgedAt = purgedAt;
    }

    public FileVersion uploaderDisplayName(String uploaderDisplayName) {
        this.uploaderDisplayName = uploaderDisplayName;
        return this;
    }

    @Schema(example="Ellis Wiggins", description="The display name of the user that uploaded the file. In most cases this is the name of the user logged in at the time of the upload.  If the file was uploaded using a File Request form that requires the user to provide an email address, this field is populated with that email address. If an email address was not required in the File Request form, this field is set to return a value of `File Request`.  In all other anonymous cases where no email was provided this field will default to a value of `Someone`.")
    public String getUploaderDisplayName() {
        return this.uploaderDisplayName;
    }

    public void setUploaderDisplayName(String uploaderDisplayName) {
        this.uploaderDisplayName = uploaderDisplayName;
    }

    public FileVersion sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    @Schema(example="134b65991ed521fcfe4724b7d814ab8ded5185dc", description="The SHA1 hash of this version of the file.")
    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileVersion fileVersion = (FileVersion)o;
        return Objects.equals(this.id, fileVersion.id) && Objects.equals((Object)this.type, (Object)fileVersion.type) && Objects.equals(this.name, fileVersion.name) && Objects.equals(this.size, fileVersion.size) && Objects.equals(this.createdAt, fileVersion.createdAt) && Objects.equals(this.modifiedAt, fileVersion.modifiedAt) && Objects.equals(this.trashedAt, fileVersion.trashedAt) && Objects.equals(this.restoredAt, fileVersion.restoredAt) && Objects.equals(this.purgedAt, fileVersion.purgedAt) && Objects.equals(this.uploaderDisplayName, fileVersion.uploaderDisplayName) && Objects.equals(this.sha1, fileVersion.sha1);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.name, this.size, this.createdAt, this.modifiedAt, this.trashedAt, this.restoredAt, this.purgedAt, this.uploaderDisplayName, this.sha1});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    trashedAt: ").append(this.toIndentedString(this.trashedAt)).append("\n");
        sb.append("    restoredAt: ").append(this.toIndentedString(this.restoredAt)).append("\n");
        sb.append("    purgedAt: ").append(this.toIndentedString(this.purgedAt)).append("\n");
        sb.append("    uploaderDisplayName: ").append(this.toIndentedString(this.uploaderDisplayName)).append("\n");
        sb.append("    sha1: ").append(this.toIndentedString(this.sha1)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FILE_VERSION("file_version");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

