/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.FileSharedLinkPermissions;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

public class FileSharedLink {
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="download_url")
    private String downloadUrl = null;
    @JsonProperty(value="vanity_url")
    private String vanityUrl = null;
    @JsonProperty(value="vanity_name")
    private String vanityName = null;
    @JsonProperty(value="access")
    private AccessEnum access = null;
    @JsonProperty(value="effective_access")
    private EffectiveAccessEnum effectiveAccess = null;
    @JsonProperty(value="effective_permission")
    private EffectivePermissionEnum effectivePermission = null;
    @JsonProperty(value="unshared_at")
    private DateTime unsharedAt = null;
    @JsonProperty(value="is_password_enabled")
    private Boolean isPasswordEnabled = null;
    @JsonProperty(value="permissions")
    private FileSharedLinkPermissions permissions = null;
    @JsonProperty(value="download_count")
    private Integer downloadCount = null;
    @JsonProperty(value="preview_count")
    private Integer previewCount = null;

    public FileSharedLink url(String url) {
        this.url = url;
        return this;
    }

    @Schema(example="https://www.box.com/s/vspke7y05sb214wjokpk", description="The URL that can be used to access the item on Box.  This URL will display the item in Box's preview UI where the file can be downloaded if allowed.  This URL will continue to work even when a custom `vanity_url` has been set for this shared link.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FileSharedLink downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @Schema(example="https://www.box.com/shared/static/rh935iit6ewrmw0unyul.jpeg", description="A URL that can be used to download the file. This URL can be used in a browser to download the file. This URL includes the file extension so that the file will be saved with the right file type.  This property will be `null` for folders.")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public FileSharedLink vanityUrl(String vanityUrl) {
        this.vanityUrl = vanityUrl;
        return this;
    }

    @Schema(example="https://acme.app.box.com/v/my_url/", description="The \"Custom URL\" that can also be used to preview the item on Box.  Custom URLs can only be created or modified in the Box Web application.")
    public String getVanityUrl() {
        return this.vanityUrl;
    }

    public void setVanityUrl(String vanityUrl) {
        this.vanityUrl = vanityUrl;
    }

    public FileSharedLink vanityName(String vanityName) {
        this.vanityName = vanityName;
        return this;
    }

    @Schema(example="my_url", description="The custom name of a shared link, as used in the `vanity_url` field.")
    public String getVanityName() {
        return this.vanityName;
    }

    public void setVanityName(String vanityName) {
        this.vanityName = vanityName;
    }

    public FileSharedLink access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @Schema(example="open", description="The access level for this shared link.  * `open` - provides access to this item to anyone with this link * `company` - only provides access to this item to people the same company * `collaborators` - only provides access to this item to people who are    collaborators on this item  If this field is omitted when creating the shared link, the access level will be set to the default access level specified by the enterprise admin.")
    public AccessEnum getAccess() {
        return this.access;
    }

    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public FileSharedLink effectiveAccess(EffectiveAccessEnum effectiveAccess) {
        this.effectiveAccess = effectiveAccess;
        return this;
    }

    @Schema(example="company", description="The effective access level for the shared link. This can be a more restrictive access level than the value in the `access` field when the enterprise settings restrict the allowed access levels.")
    public EffectiveAccessEnum getEffectiveAccess() {
        return this.effectiveAccess;
    }

    public void setEffectiveAccess(EffectiveAccessEnum effectiveAccess) {
        this.effectiveAccess = effectiveAccess;
    }

    public FileSharedLink effectivePermission(EffectivePermissionEnum effectivePermission) {
        this.effectivePermission = effectivePermission;
        return this;
    }

    @Schema(example="can_download", description="The effective permissions for this shared link.")
    public EffectivePermissionEnum getEffectivePermission() {
        return this.effectivePermission;
    }

    public void setEffectivePermission(EffectivePermissionEnum effectivePermission) {
        this.effectivePermission = effectivePermission;
    }

    public FileSharedLink unsharedAt(DateTime unsharedAt) {
        this.unsharedAt = unsharedAt;
        return this;
    }

    @Schema(example="2018-04-13T13:53:23-07:00", description="The date and time when this link will be unshared. This field can only be set by users with paid accounts.")
    public DateTime getUnsharedAt() {
        return this.unsharedAt;
    }

    public void setUnsharedAt(DateTime unsharedAt) {
        this.unsharedAt = unsharedAt;
    }

    public FileSharedLink isPasswordEnabled(Boolean isPasswordEnabled) {
        this.isPasswordEnabled = isPasswordEnabled;
        return this;
    }

    @Schema(example="true", description="Defines if the shared link requires a password to access the item.")
    public Boolean isIsPasswordEnabled() {
        return this.isPasswordEnabled;
    }

    public void setIsPasswordEnabled(Boolean isPasswordEnabled) {
        this.isPasswordEnabled = isPasswordEnabled;
    }

    public FileSharedLink permissions(FileSharedLinkPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @Schema(description="")
    public FileSharedLinkPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(FileSharedLinkPermissions permissions) {
        this.permissions = permissions;
    }

    public FileSharedLink downloadCount(Integer downloadCount) {
        this.downloadCount = downloadCount;
        return this;
    }

    @Schema(example="3", description="The number of times this item has been downloaded.")
    public Integer getDownloadCount() {
        return this.downloadCount;
    }

    public void setDownloadCount(Integer downloadCount) {
        this.downloadCount = downloadCount;
    }

    public FileSharedLink previewCount(Integer previewCount) {
        this.previewCount = previewCount;
        return this;
    }

    @Schema(example="3", description="The number of times this item has been previewed.")
    public Integer getPreviewCount() {
        return this.previewCount;
    }

    public void setPreviewCount(Integer previewCount) {
        this.previewCount = previewCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSharedLink fileSharedLink = (FileSharedLink)o;
        return Objects.equals(this.url, fileSharedLink.url) && Objects.equals(this.downloadUrl, fileSharedLink.downloadUrl) && Objects.equals(this.vanityUrl, fileSharedLink.vanityUrl) && Objects.equals(this.vanityName, fileSharedLink.vanityName) && Objects.equals((Object)this.access, (Object)fileSharedLink.access) && Objects.equals((Object)this.effectiveAccess, (Object)fileSharedLink.effectiveAccess) && Objects.equals((Object)this.effectivePermission, (Object)fileSharedLink.effectivePermission) && Objects.equals(this.unsharedAt, fileSharedLink.unsharedAt) && Objects.equals(this.isPasswordEnabled, fileSharedLink.isPasswordEnabled) && Objects.equals(this.permissions, fileSharedLink.permissions) && Objects.equals(this.downloadCount, fileSharedLink.downloadCount) && Objects.equals(this.previewCount, fileSharedLink.previewCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.downloadUrl, this.vanityUrl, this.vanityName, this.access, this.effectiveAccess, this.effectivePermission, this.unsharedAt, this.isPasswordEnabled, this.permissions, this.downloadCount, this.previewCount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileSharedLink {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    vanityUrl: ").append(this.toIndentedString(this.vanityUrl)).append("\n");
        sb.append("    vanityName: ").append(this.toIndentedString(this.vanityName)).append("\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    effectiveAccess: ").append(this.toIndentedString((Object)this.effectiveAccess)).append("\n");
        sb.append("    effectivePermission: ").append(this.toIndentedString((Object)this.effectivePermission)).append("\n");
        sb.append("    unsharedAt: ").append(this.toIndentedString(this.unsharedAt)).append("\n");
        sb.append("    isPasswordEnabled: ").append(this.toIndentedString(this.isPasswordEnabled)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    downloadCount: ").append(this.toIndentedString(this.downloadCount)).append("\n");
        sb.append("    previewCount: ").append(this.toIndentedString(this.previewCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessEnum {
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessEnum fromValue(String text) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum EffectiveAccessEnum {
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private String value;

        private EffectiveAccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectiveAccessEnum fromValue(String text) {
            for (EffectiveAccessEnum b : EffectiveAccessEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum EffectivePermissionEnum {
        DOWNLOAD("can_download"),
        PREVIEW("can_preview");

        private String value;

        private EffectivePermissionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectivePermissionEnum fromValue(String text) {
            for (EffectivePermissionEnum b : EffectivePermissionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

