/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.FileSharedLink;
import ch.cyberduck.core.box.io.swagger.client.model.FileVersion;
import ch.cyberduck.core.box.io.swagger.client.model.Folder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="A standard representation of a file, as returned from any file API endpoints by default")
public class File {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="etag")
    private String etag = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="modified_at")
    private DateTime modifiedAt = null;
    @JsonProperty(value="trashed_at")
    private DateTime trashedAt = null;
    @JsonProperty(value="purged_at")
    private DateTime purgedAt = null;
    @JsonProperty(value="content_created_at")
    private DateTime contentCreatedAt = null;
    @JsonProperty(value="content_modified_at")
    private DateTime contentModifiedAt = null;
    @JsonProperty(value="shared_link")
    private FileSharedLink sharedLink = null;
    @JsonProperty(value="parent")
    private Folder parent = null;
    @JsonProperty(value="item_status")
    private ItemStatusEnum itemStatus = null;
    @JsonProperty(value="sequence_id")
    private String sequenceId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="sha1")
    private String sha1 = null;
    @JsonProperty(value="file_version")
    private FileVersion fileVersion = null;
    @JsonProperty(value="version_number")
    private String versionNumber = null;
    @JsonProperty(value="comment_count")
    private Integer commentCount = null;
    @JsonProperty(value="extension")
    private String extension = null;
    @JsonProperty(value="is_package")
    private Boolean isPackage = null;
    @JsonProperty(value="expires_at")
    private DateTime expiresAt = null;

    public File id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="12345", description="The unique identifier that represent a file.  The ID for any file can be determined by visiting a file in the web application and copying the ID from the URL. For example, for the URL `https://_*.app.box.com/files/123` the `file_id` is `123`.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public File etag(String etag) {
        this.etag = etag;
        return this;
    }

    @Schema(example="1", description="The HTTP `etag` of this file. This can be used within some API endpoints in the `If-Match` and `If-None-Match` headers to only perform changes on the file if (no) changes have happened.")
    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public File type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="file", description="`file`")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public File description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="Contract for Q1 renewal", description="The optional description of this file")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public File size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(example="629644", description="The file size in bytes. Be careful parsing this integer as it can get very large and cause an integer overflow.")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public File createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time when the file was created on Box.")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public File modifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time when the file was last updated on Box.")
    public DateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(DateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public File trashedAt(DateTime trashedAt) {
        this.trashedAt = trashedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The time at which this file was put in the trash.")
    public DateTime getTrashedAt() {
        return this.trashedAt;
    }

    public void setTrashedAt(DateTime trashedAt) {
        this.trashedAt = trashedAt;
    }

    public File purgedAt(DateTime purgedAt) {
        this.purgedAt = purgedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The time at which this file is expected to be purged from the trash.")
    public DateTime getPurgedAt() {
        return this.purgedAt;
    }

    public void setPurgedAt(DateTime purgedAt) {
        this.purgedAt = purgedAt;
    }

    public File contentCreatedAt(DateTime contentCreatedAt) {
        this.contentCreatedAt = contentCreatedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time at which this file was originally created, which might be before it was uploaded to Box.")
    public DateTime getContentCreatedAt() {
        return this.contentCreatedAt;
    }

    public void setContentCreatedAt(DateTime contentCreatedAt) {
        this.contentCreatedAt = contentCreatedAt;
    }

    public File contentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="The date and time at which this file was last updated, which might be before it was uploaded to Box.")
    public DateTime getContentModifiedAt() {
        return this.contentModifiedAt;
    }

    public void setContentModifiedAt(DateTime contentModifiedAt) {
        this.contentModifiedAt = contentModifiedAt;
    }

    public File sharedLink(FileSharedLink sharedLink) {
        this.sharedLink = sharedLink;
        return this;
    }

    @Schema(description="")
    public FileSharedLink getSharedLink() {
        return this.sharedLink;
    }

    public void setSharedLink(FileSharedLink sharedLink) {
        this.sharedLink = sharedLink;
    }

    public File parent(Folder parent) {
        this.parent = parent;
        return this;
    }

    @Schema(description="")
    public Folder getParent() {
        return this.parent;
    }

    public void setParent(Folder parent) {
        this.parent = parent;
    }

    public File itemStatus(ItemStatusEnum itemStatus) {
        this.itemStatus = itemStatus;
        return this;
    }

    @Schema(example="active", description="Defines if this item has been deleted or not.  * `active` when the item has is not in the trash * `trashed` when the item has been moved to the trash but not deleted * `deleted` when the item has been permanently deleted.")
    public ItemStatusEnum getItemStatus() {
        return this.itemStatus;
    }

    public void setItemStatus(ItemStatusEnum itemStatus) {
        this.itemStatus = itemStatus;
    }

    public File sequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
        return this;
    }

    @Schema(example="3", description="A numeric identifier that represents the most recent user event that has been applied to this item.  This can be used in combination with the `GET /events`-endpoint to filter out user events that would have occurred before this identifier was read.  An example would be where a Box Drive-like application would fetch an item via the API, and then listen to incoming user events for changes to the item. The application would ignore any user events where the `sequence_id` in the event is smaller than or equal to the `sequence_id` in the originally fetched resource.")
    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
    }

    public File name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Contract.pdf", description="The name of the file")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    @Schema(example="85136C79CBF9FE36BB9D05D0639C70C265C18D37", description="The SHA1 hash of the file. This can be used to compare the contents of a file on Box with a local file.")
    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public File fileVersion(FileVersion fileVersion) {
        this.fileVersion = fileVersion;
        return this;
    }

    @Schema(description="")
    public FileVersion getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(FileVersion fileVersion) {
        this.fileVersion = fileVersion;
    }

    public File versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Schema(example="1", description="The version number of this file")
    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public File commentCount(Integer commentCount) {
        this.commentCount = commentCount;
        return this;
    }

    @Schema(example="10", description="The number of comments on this file")
    public Integer getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    public File extension(String extension) {
        this.extension = extension;
        return this;
    }

    @Schema(example="pdf", description="Indicates the (optional) file extension for this file. By default, this is set to an empty string.")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public File isPackage(Boolean isPackage) {
        this.isPackage = isPackage;
        return this;
    }

    @Schema(example="true", description="Indicates if the file is a package. Packages are commonly used by Mac Applications and can include iWork files.")
    public Boolean isIsPackage() {
        return this.isPackage;
    }

    public void setIsPackage(Boolean isPackage) {
        this.isPackage = isPackage;
    }

    public File expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(example="2012-12-12T10:53:43-08:00", description="When the file will automatically be deleted")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File file = (File)o;
        return Objects.equals(this.id, file.id) && Objects.equals(this.etag, file.etag) && Objects.equals((Object)this.type, (Object)file.type) && Objects.equals(this.description, file.description) && Objects.equals(this.size, file.size) && Objects.equals(this.createdAt, file.createdAt) && Objects.equals(this.modifiedAt, file.modifiedAt) && Objects.equals(this.trashedAt, file.trashedAt) && Objects.equals(this.purgedAt, file.purgedAt) && Objects.equals(this.contentCreatedAt, file.contentCreatedAt) && Objects.equals(this.contentModifiedAt, file.contentModifiedAt) && Objects.equals(this.sharedLink, file.sharedLink) && Objects.equals(this.parent, file.parent) && Objects.equals((Object)this.itemStatus, (Object)file.itemStatus) && Objects.equals(this.sequenceId, file.sequenceId) && Objects.equals(this.name, file.name) && Objects.equals(this.sha1, file.sha1) && Objects.equals(this.fileVersion, file.fileVersion) && Objects.equals(this.versionNumber, file.versionNumber) && Objects.equals(this.commentCount, file.commentCount) && Objects.equals(this.extension, file.extension) && Objects.equals(this.isPackage, file.isPackage) && Objects.equals(this.expiresAt, file.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.etag, this.type, this.description, this.size, this.createdAt, this.modifiedAt, this.trashedAt, this.purgedAt, this.contentCreatedAt, this.contentModifiedAt, this.sharedLink, this.parent, this.itemStatus, this.sequenceId, this.name, this.sha1, this.fileVersion, this.versionNumber, this.commentCount, this.extension, this.isPackage, this.expiresAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class File {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    etag: ").append(this.toIndentedString(this.etag)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    trashedAt: ").append(this.toIndentedString(this.trashedAt)).append("\n");
        sb.append("    purgedAt: ").append(this.toIndentedString(this.purgedAt)).append("\n");
        sb.append("    contentCreatedAt: ").append(this.toIndentedString(this.contentCreatedAt)).append("\n");
        sb.append("    contentModifiedAt: ").append(this.toIndentedString(this.contentModifiedAt)).append("\n");
        sb.append("    sharedLink: ").append(this.toIndentedString(this.sharedLink)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    itemStatus: ").append(this.toIndentedString((Object)this.itemStatus)).append("\n");
        sb.append("    sequenceId: ").append(this.toIndentedString(this.sequenceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sha1: ").append(this.toIndentedString(this.sha1)).append("\n");
        sb.append("    fileVersion: ").append(this.toIndentedString(this.fileVersion)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    commentCount: ").append(this.toIndentedString(this.commentCount)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    isPackage: ").append(this.toIndentedString(this.isPackage)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FILE("file");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ItemStatusEnum {
        ACTIVE("active"),
        TRASHED("trashed"),
        DELETED("deleted");

        private String value;

        private ItemStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ItemStatusEnum fromValue(String text) {
            for (ItemStatusEnum b : ItemStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

