/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client.model;

import ch.cyberduck.core.box.io.swagger.client.model.ClientErrorContextInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A generic error")
public class ClientError {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="status")
    private Integer status = null;
    @JsonProperty(value="code")
    private CodeEnum code = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="context_info")
    private ClientErrorContextInfo contextInfo = null;
    @JsonProperty(value="help_url")
    private String helpUrl = null;
    @JsonProperty(value="request_id")
    private String requestId = null;

    public ClientError type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="error", description="`error`")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ClientError status(Integer status) {
        this.status = status;
        return this;
    }

    @Schema(example="400", description="The HTTP status of the response.")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public ClientError code(CodeEnum code) {
        this.code = code;
        return this;
    }

    @Schema(example="item_name_invalid", description="A Box-specific error code")
    public CodeEnum getCode() {
        return this.code;
    }

    public void setCode(CodeEnum code) {
        this.code = code;
    }

    public ClientError message(String message) {
        this.message = message;
        return this;
    }

    @Schema(example="Method Not Allowed", description="A short message describing the error.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ClientError contextInfo(ClientErrorContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    @Schema(description="")
    public ClientErrorContextInfo getContextInfo() {
        return this.contextInfo;
    }

    public void setContextInfo(ClientErrorContextInfo contextInfo) {
        this.contextInfo = contextInfo;
    }

    public ClientError helpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
        return this;
    }

    @Schema(example="http://developers.box.com/docs/#errors", description="A URL that links to more information about why this error occurred.")
    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public ClientError requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Schema(example="abcdef123456", description="A unique identifier for this response, which can be used when contacting Box support.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientError clientError = (ClientError)o;
        return Objects.equals((Object)this.type, (Object)clientError.type) && Objects.equals(this.status, clientError.status) && Objects.equals((Object)this.code, (Object)clientError.code) && Objects.equals(this.message, clientError.message) && Objects.equals(this.contextInfo, clientError.contextInfo) && Objects.equals(this.helpUrl, clientError.helpUrl) && Objects.equals(this.requestId, clientError.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.status, this.code, this.message, this.contextInfo, this.helpUrl, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientError {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    contextInfo: ").append(this.toIndentedString(this.contextInfo)).append("\n");
        sb.append("    helpUrl: ").append(this.toIndentedString(this.helpUrl)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ERROR("error");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum CodeEnum {
        CREATED("created"),
        ACCEPTED("accepted"),
        NO_CONTENT("no_content"),
        REDIRECT("redirect"),
        NOT_MODIFIED("not_modified"),
        BAD_REQUEST("bad_request"),
        UNAUTHORIZED("unauthorized"),
        FORBIDDEN("forbidden"),
        NOT_FOUND("not_found"),
        METHOD_NOT_ALLOWED("method_not_allowed"),
        CONFLICT("conflict"),
        PRECONDITION_FAILED("precondition_failed"),
        TOO_MANY_REQUESTS("too_many_requests"),
        INTERNAL_SERVER_ERROR("internal_server_error"),
        UNAVAILABLE("unavailable"),
        ITEM_NAME_INVALID("item_name_invalid"),
        INSUFFICIENT_SCOPE("insufficient_scope");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CodeEnum fromValue(String text) {
            for (CodeEnum b : CodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

