/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box.io.swagger.client;

import ch.cyberduck.core.box.io.swagger.client.RFC3339DateFormat;
import ch.cyberduck.core.jersey.CustomJacksonObjectMapper;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.text.DateFormat;
import javax.ws.rs.ext.ContextResolver;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class JSON
implements ContextResolver<ObjectMapper> {
    private ObjectMapper mapper = new CustomJacksonObjectMapper();

    public JSON() {
        this.mapper.setDateFormat((DateFormat)((Object)new RFC3339DateFormat()));
        this.mapper.registerModule((Module)new JodaModule());
        SimpleModule module = new SimpleModule();
        module.addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer());
        this.mapper.registerModule((Module)module);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.mapper.setDateFormat(dateFormat);
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }

    private static final class DateTimeSerializer
    extends StdSerializer<DateTime> {
        private static final String YYYY_MM_DD_T_HH_MM_SS_ZZ = "yyyy-MM-dd'T'HH:mm:ssZZ";

        public DateTimeSerializer() {
            this(null);
        }

        public DateTimeSerializer(Class<DateTime> t) {
            super(t);
        }

        public void serialize(DateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(DateTimeFormat.forPattern((String)YYYY_MM_DD_T_HH_MM_SS_ZZ).print((ReadableInstant)dateTime));
        }
    }
}

