/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxClientErrorResponseHandler;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.JSON;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.Files;
import ch.cyberduck.core.box.io.swagger.client.model.FilescontentAttributes;
import ch.cyberduck.core.box.io.swagger.client.model.FilescontentAttributesParent;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.SHA1ChecksumCompute;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class BoxWriteFeature
extends AbstractHttpWriteFeature<File> {
    private static final Logger log = LogManager.getLogger(BoxWriteFeature.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;
    private final BoxApiClient client;

    public BoxWriteFeature(BoxSession session, BoxFileidProvider fileid) {
        super((AttributesAdapter)new BoxAttributesFinderFeature(session, fileid));
        this.session = session;
        this.fileid = fileid;
        this.client = new BoxApiClient((CloseableHttpClient)session.getClient());
        this.client.setBasePath("https://upload.box.com/api/2.0");
    }

    public HttpResponseOutputStream<File> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<File> command = new DelayedHttpEntityCallable<File>(){

            public File call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HttpPost request = status.isExists() ? new HttpPost(String.format("%s/files/%s/content?fields=%s", BoxWriteFeature.this.client.getBasePath(), BoxWriteFeature.this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()), String.join((CharSequence)",", BoxAttributesFinderFeature.DEFAULT_FIELDS))) : new HttpPost(String.format("%s/files/content?fields=%s", BoxWriteFeature.this.client.getBasePath(), String.join((CharSequence)",", BoxAttributesFinderFeature.DEFAULT_FIELDS)));
                    Checksum checksum = status.getChecksum();
                    if (Checksum.NONE != checksum) {
                        switch (checksum.algorithm) {
                            case sha1: {
                                request.addHeader("Content-MD5", checksum.hash);
                            }
                        }
                    }
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    new JSON().getContext(null).writeValue((OutputStream)content, (Object)new FilescontentAttributes().name(file.getName()).parent(new FilescontentAttributesParent().id(BoxWriteFeature.this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).contentModifiedAt(status.getTimestamp() != null ? new DateTime((Object)status.getTimestamp()) : null));
                    MultipartEntityBuilder multipart = MultipartEntityBuilder.create();
                    multipart.addBinaryBody("attributes", content.toByteArray());
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)out);
                    multipart.addBinaryBody("file", out.toByteArray(), null == status.getMime() ? ContentType.APPLICATION_OCTET_STREAM : ContentType.create((String)status.getMime()), file.getName());
                    request.setEntity(multipart.build());
                    if (status.isExists()) {
                        if (StringUtils.isNotBlank((CharSequence)status.getRemote().getETag())) {
                            request.addHeader((Header)new BasicHeader("If-Match", status.getRemote().getETag()));
                        } else {
                            log.warn(String.format("Missing remote attributes in transfer status to read current ETag for %s", file));
                        }
                    }
                    Files files = (Files)((CloseableHttpClient)BoxWriteFeature.this.session.getClient()).execute((HttpUriRequest)request, (ResponseHandler)new BoxClientErrorResponseHandler<Files>(){

                        public Files handleEntity(HttpEntity entity) throws IOException {
                            return (Files)new JSON().getContext(null).readValue(entity.getContent(), Files.class);
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Received response %s for upload of %s", files, file));
                    }
                    if (files.getEntries().stream().findFirst().isPresent()) {
                        return (File)files.getEntries().stream().findFirst().get();
                    }
                    throw new NotfoundException(file.getAbsolute());
                }
                catch (HttpResponseException e) {
                    throw new DefaultHttpResponseExceptionMappingService().map(e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return -1L;
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new SHA1ChecksumCompute();
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }
}

