/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxClientErrorResponseHandler;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.JSON;
import ch.cyberduck.core.box.io.swagger.client.model.FileIdUploadSessionsBody;
import ch.cyberduck.core.box.io.swagger.client.model.Files;
import ch.cyberduck.core.box.io.swagger.client.model.FilesUploadSessionsBody;
import ch.cyberduck.core.box.io.swagger.client.model.UploadPart;
import ch.cyberduck.core.box.io.swagger.client.model.UploadSession;
import ch.cyberduck.core.box.io.swagger.client.model.UploadSessionIdCommitBody;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxUploadHelper {
    private static final Logger log = LogManager.getLogger(BoxUploadHelper.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;
    private final BoxApiClient client;

    public BoxUploadHelper(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
        this.client = new BoxApiClient((CloseableHttpClient)session.getClient());
        this.client.setBasePath("https://upload.box.com/api/2.0");
    }

    public UploadSession createUploadSession(TransferStatus status, Path file) throws BackgroundException {
        try {
            ByteArrayOutputStream content;
            HttpPost request;
            if (status.isExists()) {
                request = new HttpPost(String.format("%s/files/%s/upload_sessions", this.client.getBasePath(), this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener())));
                content = new ByteArrayOutputStream();
                FileIdUploadSessionsBody idUploadSessionsBody = new FileIdUploadSessionsBody().fileName(file.getName());
                if (status.getLength() != -1L) {
                    idUploadSessionsBody.fileSize(status.getLength());
                }
                new JSON().getContext(null).writeValue((OutputStream)content, (Object)idUploadSessionsBody);
                request.setEntity((HttpEntity)new ByteArrayEntity(content.toByteArray()));
            } else {
                request = new HttpPost(String.format("%s/files/upload_sessions", this.client.getBasePath()));
                content = new ByteArrayOutputStream();
                FilesUploadSessionsBody uploadSessionsBody = new FilesUploadSessionsBody().folderId(this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener())).fileName(file.getName());
                if (status.getLength() != -1L) {
                    uploadSessionsBody.fileSize(status.getLength());
                }
                new JSON().getContext(null).writeValue((OutputStream)content, (Object)uploadSessionsBody);
                request.setEntity((HttpEntity)new ByteArrayEntity(content.toByteArray()));
            }
            BoxClientErrorResponseHandler<UploadSession> responseHandler = new BoxClientErrorResponseHandler<UploadSession>(){

                public UploadSession handleEntity(HttpEntity entity) throws IOException {
                    return (UploadSession)new JSON().getContext(null).readValue(entity.getContent(), UploadSession.class);
                }
            };
            return (UploadSession)((CloseableHttpClient)this.session.getClient()).execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public Files commitUploadSession(final Path file, final String uploadSessionId, TransferStatus overall, List<UploadPart> uploadParts) throws BackgroundException {
        try {
            final HttpPost request = new HttpPost(String.format("%s/files/upload_sessions/%s/commit", this.client.getBasePath(), uploadSessionId));
            if (!Checksum.NONE.equals((Object)overall.getChecksum())) {
                request.addHeader((Header)new BasicHeader("Digest", String.format("sha=%s", overall.getChecksum().hash)));
            }
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            UploadSessionIdCommitBody body = new UploadSessionIdCommitBody().parts(uploadParts);
            new JSON().getContext(null).writeValue((OutputStream)content, (Object)body);
            request.setEntity((HttpEntity)new ByteArrayEntity(content.toByteArray()));
            if (overall.isExists()) {
                if (StringUtils.isNotBlank((CharSequence)overall.getRemote().getETag())) {
                    request.addHeader((Header)new BasicHeader("If-Match", overall.getRemote().getETag()));
                } else {
                    log.warn(String.format("Missing remote attributes in transfer status to read current ETag for %s", file));
                }
            }
            return (Files)((CloseableHttpClient)this.session.getClient()).execute((HttpUriRequest)request, (ResponseHandler)new BoxClientErrorResponseHandler<Files>(){

                @Override
                public Files handleResponse(HttpResponse response) throws IOException {
                    if (response.getStatusLine().getStatusCode() == 202) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Wait for server to process chunks with response %s", response));
                        }
                        this.flush(file, response, uploadSessionId);
                        return (Files)((CloseableHttpClient)BoxUploadHelper.this.session.getClient()).execute((HttpUriRequest)request, (ResponseHandler)this);
                    }
                    return (Files)super.handleResponse(response);
                }

                public Files handleEntity(HttpEntity entity) throws IOException {
                    return (Files)new JSON().getContext(null).readValue(entity.getContent(), Files.class);
                }

                private void flush(Path file2, HttpResponse response, String uploadSessionId2) throws IOException {
                    UploadSession uploadSession;
                    do {
                        HttpGet request2 = new HttpGet(String.format("%s/files/upload_sessions/%s", BoxUploadHelper.this.client.getBasePath(), uploadSessionId2));
                        uploadSession = (UploadSession)new JSON().getContext(null).readValue(((CloseableHttpClient)BoxUploadHelper.this.session.getClient()).execute((HttpUriRequest)request2).getEntity().getContent(), UploadSession.class);
                        if (!log.isDebugEnabled()) continue;
                        log.debug(String.format("Server processed %d of %d parts", uploadSession.getNumPartsProcessed(), uploadSession.getTotalParts()));
                    } while (!Objects.equals(uploadSession.getNumPartsProcessed(), uploadSession.getTotalParts()));
                }
            });
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }
}

