/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxChunkedWriteFeature;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.BoxWriteFeature;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;

public class BoxThresholdWriteFeature
implements Write<File> {
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxThresholdWriteFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public StatusOutputStream<File> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (status.isSegment()) {
            return new BoxChunkedWriteFeature(this.session, this.fileid).write(file, status, callback);
        }
        return new BoxWriteFeature(this.session, this.fileid).write(file, status, callback);
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        if (status.isSegment()) {
            return new BoxChunkedWriteFeature(this.session, this.fileid).checksum(file, status);
        }
        return new BoxWriteFeature(this.session, this.fileid).checksum(file, status);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }
}

