/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxLargeUploadService;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.BoxSmallUploadService;
import ch.cyberduck.core.box.BoxThresholdWriteFeature;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;

public class BoxThresholdUploadService
implements Upload<File> {
    private final BoxSession session;
    private final BoxFileidProvider fileid;
    private final VaultRegistry registry;
    private Write<File> writer;

    public BoxThresholdUploadService(BoxSession session, BoxFileidProvider fileid, VaultRegistry registry) {
        this.session = session;
        this.fileid = fileid;
        this.registry = registry;
        this.writer = new BoxThresholdWriteFeature(session, fileid);
    }

    public File upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.threshold(status.getLength()) && Vault.DISABLED == this.registry.find((Session)this.session, file)) {
            return new BoxLargeUploadService(this.session, this.fileid, this.writer).upload(file, local, throttle, listener, status, callback);
        }
        return (File)new BoxSmallUploadService(this.session, this.fileid, this.writer).upload(file, local, throttle, listener, status, callback);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public Upload<File> withWriter(Write<File> writer) {
        this.writer = writer;
        return this;
    }

    protected boolean threshold(Long length) {
        return length >= new HostPreferences(this.session.getHost()).getLong("box.upload.multipart.threshold");
    }
}

