/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.SharedLinksFilesApi;
import ch.cyberduck.core.box.io.swagger.client.api.SharedLinksFoldersApi;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.FilesFileIdaddSharedLinkBody;
import ch.cyberduck.core.box.io.swagger.client.model.FilesfileIdSharedLinkPermissions;
import ch.cyberduck.core.box.io.swagger.client.model.FilesfileIdaddSharedLinkSharedLink;
import ch.cyberduck.core.box.io.swagger.client.model.Folder;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersFolderIdaddSharedLinkBody;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersfolderIdaddSharedLinkSharedLink;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersfolderIdaddSharedLinkSharedLinkPermissions;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.PromptUrlProvider;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.http.impl.client.CloseableHttpClient;

public class BoxShareFeature
implements PromptUrlProvider {
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxShareFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return true;
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        if (file.isDirectory()) {
            return this.createFolderSharedLink(file, callback);
        }
        return this.createFileSharedLink(file, callback);
    }

    public DescriptiveUrl toUploadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        throw new UnsupportedException();
    }

    private DescriptiveUrl createFileSharedLink(Path file, PasswordCallback callback) throws BackgroundException {
        try {
            String password = this.prompt(file, callback);
            File link = new SharedLinksFilesApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).putFilesIdAddSharedLink("shared_link", this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()), new FilesFileIdaddSharedLinkBody().sharedLink(new FilesfileIdaddSharedLinkSharedLink().permissions(new FilesfileIdSharedLinkPermissions().canDownload(true)).password(password)));
            return new DescriptiveUrl(URI.create(link.getSharedLink().getDownloadUrl()), DescriptiveUrl.Type.signed);
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map(e);
        }
    }

    private DescriptiveUrl createFolderSharedLink(Path file, PasswordCallback callback) throws BackgroundException {
        try {
            String password = this.prompt(file, callback);
            Folder link = new SharedLinksFoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).putFoldersIdAddSharedLink("shared_link", this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()), new FoldersFolderIdaddSharedLinkBody().sharedLink(new FoldersfolderIdaddSharedLinkSharedLink().permissions(new FoldersfolderIdaddSharedLinkSharedLinkPermissions().canDownload(false)).password(password)));
            return new DescriptiveUrl(URI.create(link.getSharedLink().getUrl()), DescriptiveUrl.Type.signed);
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map(e);
        }
    }

    private String prompt(Path file, PasswordCallback callback) {
        String password = null;
        try {
            password = callback.prompt(this.session.getHost(), LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(this.session.getHost().getProtocol().disk())).getPassword();
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
        return password;
    }
}

