/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxCopyFeature;
import ch.cyberduck.core.box.BoxDeleteFeature;
import ch.cyberduck.core.box.BoxDirectoryFeature;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxListService;
import ch.cyberduck.core.box.BoxMoveFeature;
import ch.cyberduck.core.box.BoxReadFeature;
import ch.cyberduck.core.box.BoxShareFeature;
import ch.cyberduck.core.box.BoxThresholdUploadService;
import ch.cyberduck.core.box.BoxThresholdWriteFeature;
import ch.cyberduck.core.box.BoxTouchFeature;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.UsersApi;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.shared.BufferWriteFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.Collections;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxSession
extends HttpSession<CloseableHttpClient> {
    private static final Logger log = LogManager.getLogger(BoxSession.class);
    private final BoxFileidProvider fileid = new BoxFileidProvider(this);
    protected OAuth2RequestInterceptor authorizationService;

    public BoxSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public CloseableHttpClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        return configuration.build();
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel, OAuth2AuthorizationService.FlowType.AuthorizationCode));
        try {
            Credentials credentials = this.host.getCredentials();
            credentials.setUsername(new UsersApi(new BoxApiClient((CloseableHttpClient)this.client)).getUsersMe(Collections.emptyList()).getLogin());
            credentials.setSaved(true);
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((CloseableHttpClient)this.client).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.fileid.clear();
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Upload.class) {
            return (T)new BoxThresholdUploadService(this, this.fileid, this.registry);
        }
        if (type == Write.class) {
            return (T)new BoxThresholdWriteFeature(this, this.fileid);
        }
        if (type == Touch.class) {
            return (T)((Object)new BoxTouchFeature(this, this.fileid));
        }
        if (type == MultipartWrite.class) {
            return (T)new BufferWriteFeature((Session)this);
        }
        if (type == ListService.class) {
            return (T)new BoxListService(this, this.fileid);
        }
        if (type == Read.class) {
            return (T)new BoxReadFeature(this, this.fileid);
        }
        if (type == Move.class) {
            return (T)new BoxMoveFeature(this, this.fileid);
        }
        if (type == Copy.class) {
            return (T)new BoxCopyFeature(this, this.fileid);
        }
        if (type == Directory.class) {
            return (T)new BoxDirectoryFeature(this, this.fileid);
        }
        if (type == Delete.class) {
            return (T)new BoxDeleteFeature(this, this.fileid);
        }
        if (type == AttributesFinder.class) {
            return (T)new BoxAttributesFinderFeature(this, this.fileid);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new BoxShareFeature(this, this.fileid);
        }
        return (T)super._getFeature(type);
    }
}

