/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(BoxReadFeature.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxReadFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            BoxApiClient client = new BoxApiClient((CloseableHttpClient)this.session.getClient());
            HttpGet request = new HttpGet(String.format("%s/files/%s/content", client.getBasePath(), this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener())));
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add range header %s for file %s", header, file));
                }
                request.addHeader((Header)new BasicHeader("Range", header));
            }
            CloseableHttpResponse response = ((CloseableHttpClient)this.session.getClient()).execute((HttpUriRequest)request);
            return new HttpMethodReleaseInputStream((HttpResponse)response, status);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }
}

