/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxBase64SHA1ChecksumCompute;
import ch.cyberduck.core.box.BoxClientErrorResponseHandler;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.BoxUploadHelper;
import ch.cyberduck.core.box.io.swagger.client.JSON;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.Files;
import ch.cyberduck.core.box.io.swagger.client.model.UploadSession;
import ch.cyberduck.core.box.io.swagger.client.model.UploadedPart;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxMultipartWriteFeature
implements Write<File> {
    private static final Logger log = LogManager.getLogger(BoxMultipartWriteFeature.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxMultipartWriteFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public HttpResponseOutputStream<File> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        UploadSession uploadSession = new BoxUploadHelper(this.session, this.fileid).createUploadSession(status, file);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Obtained session %s for file %s", uploadSession, file));
        }
        final BoxOutputStream proxy = new BoxOutputStream(file, uploadSession, status);
        return new HttpResponseOutputStream<File>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(uploadSession.getPartSize().intValue())), (AttributesAdapter)new BoxAttributesFinderFeature(this.session, this.fileid), status){

            public File getStatus() {
                return proxy.getResult();
            }
        };
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new BoxBase64SHA1ChecksumCompute();
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    private final class BoxOutputStream
    extends OutputStream {
        private final Path file;
        private final UploadSession uploadSession;
        private final TransferStatus overall;
        private final List<UploadedPart> checksums = new ArrayList<UploadedPart>();
        private final AtomicBoolean close = new AtomicBoolean();
        private final BytecountStreamListener byteCounter = new BytecountStreamListener();
        private final AtomicReference<File> result = new AtomicReference();

        public BoxOutputStream(Path file, UploadSession uploadSession, TransferStatus status) {
            this.file = file;
            this.uploadSession = uploadSession;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] content = Arrays.copyOfRange(b, off, len);
            try {
                HttpRange range = HttpRange.withStatus((TransferStatus)new TransferStatus().withLength((long)content.length).withOffset(this.byteCounter.getSent()));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Send range %s for file %s", range, this.file));
                }
                HttpPut request = new HttpPut(String.format("https://upload.box.com/api/2.0/files/upload_sessions/%s", this.uploadSession.getId()));
                request.addHeader((Header)new BasicHeader("Content-Range", String.format("bytes %d-%d/%d", range.getStart(), range.getEnd(), this.overall.getOffset() + this.overall.getLength())));
                request.addHeader((Header)new BasicHeader("Digest", String.format("sha=%s", new BoxBase64SHA1ChecksumCompute().compute((InputStream)new ByteArrayInputStream((byte[])content), (TransferStatus)this.overall).hash)));
                request.setEntity((HttpEntity)new ByteArrayEntity(content));
                this.checksums.add((UploadedPart)((CloseableHttpClient)BoxMultipartWriteFeature.this.session.getClient()).execute((HttpUriRequest)request, (ResponseHandler)new BoxClientErrorResponseHandler<UploadedPart>(){

                    public UploadedPart handleEntity(HttpEntity entity) throws IOException {
                        return (UploadedPart)new JSON().getContext(null).readValue(entity.getContent(), UploadedPart.class);
                    }
                }));
                this.byteCounter.sent((long)len);
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.close.get()) {
                log.warn(String.format("Skip double close of stream %s", this));
                return;
            }
            try {
                super.close();
                Files files = new BoxUploadHelper(BoxMultipartWriteFeature.this.session, BoxMultipartWriteFeature.this.fileid).commitUploadSession(this.file, this.uploadSession.getId(), this.overall, this.checksums.stream().map(UploadedPart::getPart).collect(Collectors.toList()));
                if (files.getEntries().stream().findFirst().isPresent()) {
                    this.result.set((File)files.getEntries().stream().findFirst().get());
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            finally {
                this.close.set(true);
            }
        }

        public File getResult() {
            return this.result.get();
        }
    }
}

