/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxDeleteFeature;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.box.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.FilesFileIdBody;
import ch.cyberduck.core.box.io.swagger.client.model.FilesfileIdParent;
import ch.cyberduck.core.box.io.swagger.client.model.Folder;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersFolderIdBody;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersfolderIdParent;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxMoveFeature
implements Move {
    private static final Logger log = LogManager.getLogger(BoxMoveFeature.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxMoveFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        try {
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Delete file %s to be replaced with %s", renamed, file));
                }
                new BoxDeleteFeature(this.session, this.fileid).delete(Collections.singletonList(renamed), (PasswordCallback)callback, delete);
            }
            String id = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            if (file.isDirectory()) {
                Folder result = new FoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).putFoldersId(id, new FoldersFolderIdBody().name(renamed.getName()).parent(new FoldersfolderIdParent().id(this.fileid.getFileId(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener()))), null, BoxAttributesFinderFeature.DEFAULT_FIELDS);
                this.fileid.cache(file, null);
                this.fileid.cache(renamed, id);
                return renamed.withAttributes(new BoxAttributesFinderFeature(this.session, this.fileid).toAttributes(result));
            }
            File result = new FilesApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).putFilesId(id, new FilesFileIdBody().name(renamed.getName()).parent(new FilesfileIdParent().id(this.fileid.getFileId(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener()))), null, BoxAttributesFinderFeature.DEFAULT_FIELDS);
            this.fileid.cache(file, null);
            this.fileid.cache(renamed, id);
            return renamed.withAttributes(new BoxAttributesFinderFeature(this.session, this.fileid).toAttributes(result));
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

