/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.JSON;
import ch.cyberduck.core.box.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.Folder;
import ch.cyberduck.core.box.io.swagger.client.model.Items;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.HostPreferences;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.EnumSet;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxListService
implements ListService {
    private static final Logger log = LogManager.getLogger(BoxListService.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;
    private final BoxAttributesFinderFeature attributes;

    public BoxListService(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
        this.attributes = new BoxAttributesFinderFeature(session, fileid);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, new HostPreferences(this.session.getHost()).getInteger("box.listing.chunksize"));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, int chunksize) throws BackgroundException {
        try {
            Items items;
            AttributedList list = new AttributedList();
            int offset = 0;
            do {
                items = new FoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).getFoldersIdItems(directory.isRoot() ? "0" : this.fileid.getFileId(directory, listener), BoxAttributesFinderFeature.DEFAULT_FIELDS, false, null, Long.valueOf(offset), Long.valueOf(chunksize), "", "", "");
                for (Object entry : items.getEntries()) {
                    if (!(entry instanceof Map)) {
                        log.error(String.format("Unexpected entry %s", entry));
                        continue;
                    }
                    Object type = ((Map)entry).get("type");
                    if (!(type instanceof String)) {
                        log.error(String.format("Missing type %s", type));
                        continue;
                    }
                    switch (type.toString()) {
                        case "file": {
                            File file = (File)new JSON().getContext(null).readValue(new JSON().getContext(null).writeValueAsString(entry), File.class);
                            list.add((Referenceable)new Path(directory, file.getName(), EnumSet.of(AbstractPath.Type.file), this.attributes.toAttributes(file)));
                            break;
                        }
                        case "folder": {
                            Folder folder = (Folder)new JSON().getContext(null).readValue(new JSON().getContext(null).writeValueAsString(entry), Folder.class);
                            list.add((Referenceable)new Path(directory, folder.getName(), EnumSet.of(AbstractPath.Type.directory), this.attributes.toAttributes(folder)));
                        }
                    }
                    listener.chunk(directory, list);
                }
                offset += chunksize;
            } while (items.getEntries().size() == chunksize);
            return list;
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map("Listing directory {0} failed", e, directory);
        }
        catch (JsonProcessingException e) {
            throw new DefaultIOExceptionMappingService().map("Listing directory {0} failed", (Throwable)e, directory);
        }
    }
}

