/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.BoxUploadHelper;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.Files;
import ch.cyberduck.core.box.io.swagger.client.model.UploadPart;
import ch.cyberduck.core.box.io.swagger.client.model.UploadSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.SegmentRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxLargeUploadService
extends HttpUploadFeature<File, MessageDigest> {
    private static final Logger log = LogManager.getLogger(BoxLargeUploadService.class);
    public static final String UPLOAD_SESSION_ID = "uploadSessionId";
    public static final String OVERALL_LENGTH = "overall-length";
    private final BoxSession session;
    private final Integer concurrency;
    private final BoxFileidProvider fileid;
    private Write<File> writer;

    public BoxLargeUploadService(BoxSession session, BoxFileidProvider fileid, Write<File> writer) {
        this(session, fileid, writer, new HostPreferences(session.getHost()).getInteger("box.upload.multipart.concurrency"));
    }

    public BoxLargeUploadService(BoxSession session, BoxFileidProvider fileid, Write<File> writer, Integer concurrency) {
        super(writer);
        this.session = session;
        this.writer = writer;
        this.concurrency = concurrency;
        this.fileid = fileid;
    }

    public File upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        try {
            ArrayList<Future<File>> parts = new ArrayList<Future<File>>();
            long offset = 0L;
            long remaining = status.getLength();
            BoxUploadHelper helper = new BoxUploadHelper(this.session, this.fileid);
            UploadSession uploadSession = helper.createUploadSession(status, file);
            int partNumber = 1;
            while (remaining > 0L) {
                long length = Math.min(uploadSession.getPartSize(), remaining);
                parts.add(this.submit(pool, file, local, throttle, listener, status, uploadSession.getId(), partNumber, offset, length, callback));
                remaining -= length;
                offset += length;
                ++partNumber;
            }
            ArrayList<File> chunks = new ArrayList<File>();
            for (Future file2 : parts) {
                try {
                    chunks.add((File)Uninterruptibles.getUninterruptibly((Future)file2));
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            Files files = helper.commitUploadSession(file, uploadSession.getId(), status, chunks.stream().map(f -> new UploadPart().sha1(f.getSha1())).collect(Collectors.toList()));
            if (files.getEntries().stream().findFirst().isPresent()) {
                File file2 = (File)files.getEntries().stream().findFirst().get();
                return file2;
            }
            throw new NotfoundException(file.getAbsolute());
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<File> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final String uploadSessionId, final int partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit %s to queue with offset %d and length %d", file, offset, length));
        }
        BytecountStreamListener counter = new BytecountStreamListener(listener);
        return pool.execute((Callable)new SegmentRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<File>(){

            public File call() throws BackgroundException {
                overall.validate();
                TransferStatus status = new TransferStatus().segment(true).withOffset(offset).withLength(length);
                status.setPart(Integer.valueOf(partNumber));
                status.setHeader(overall.getHeader());
                status.setChecksum(BoxLargeUploadService.this.writer.checksum(file, status).compute(local.getInputStream(), status));
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put(BoxLargeUploadService.UPLOAD_SESSION_ID, uploadSessionId);
                parameters.put(BoxLargeUploadService.OVERALL_LENGTH, String.valueOf(overall.getLength()));
                status.withParameters(parameters);
                File response = (File)BoxLargeUploadService.this.upload(file, local, throttle, listener, status, (StreamCancelation)overall, (StreamProgress)status, callback);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Received response %s for part %d", response, partNumber));
                }
                return response;
            }
        }, (StreamCancelation)overall, counter));
    }

    public Upload<File> withWriter(Write<File> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

