/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.CachingFileIdProvider;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.box.BoxListService;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.FileIdProvider;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxFileidProvider
extends CachingFileIdProvider
implements FileIdProvider {
    private static final Logger log = LogManager.getLogger(BoxFileidProvider.class);
    public static final String ROOT = "0";
    private final BoxSession session;

    public BoxFileidProvider(BoxSession session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return file.attributes().getFileId();
        }
        String cached = super.getFileId(file, listener);
        if (cached != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return cached fileid %s for file %s", cached, file));
            }
            return cached;
        }
        if (file.isRoot()) {
            return ROOT;
        }
        Path f = (Path)new BoxListService(this.session, this).list(file.getParent(), listener).find((Predicate)new SimplePathPredicate(file));
        if (null == f) {
            throw new NotfoundException(file.getAbsolute());
        }
        return f.attributes().getFileId();
    }
}

