/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.HttpResponseException;

public class BoxExceptionMappingService
extends AbstractExceptionMappingService<ApiException> {
    private final BoxFileidProvider fileid;

    public BoxExceptionMappingService(BoxFileidProvider fileid) {
        this.fileid = fileid;
    }

    public BackgroundException map(String message, ApiException failure, Path file) {
        switch (failure.getCode()) {
            case 404: {
                this.fileid.cache(file, null);
            }
        }
        return super.map(message, (Throwable)failure, file);
    }

    public BackgroundException map(ApiException failure) {
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (cause instanceof SocketException) {
                return new DefaultSocketExceptionMappingService().map((SocketException)cause);
            }
            if (cause instanceof HttpResponseException) {
                return new DefaultHttpResponseExceptionMappingService().map((HttpResponseException)cause);
            }
            if (cause instanceof IOException) {
                return new DefaultIOExceptionMappingService().map((IOException)cause);
            }
            if (!(cause instanceof IllegalStateException)) continue;
            return new ConnectionCanceledException(cause);
        }
        return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(failure.getCode(), failure.getMessage()));
    }
}

