/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.BoxTouchFeature;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersBody;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersParent;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.http.impl.client.CloseableHttpClient;

public class BoxDirectoryFeature
implements Directory {
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxDirectoryFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            return folder.withAttributes(new BoxAttributesFinderFeature(this.session, this.fileid).toAttributes(new FoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).postFolders(new FoldersBody().parent(new FoldersParent().id(this.fileid.getFileId(folder.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(folder.getName()), Collections.emptyList())));
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map("Cannot create folder {0}", e, folder);
        }
    }

    public Directory withWriter(Write writer) {
        return this;
    }

    public boolean isSupported(Path workdir, String name) {
        return new BoxTouchFeature(this.session, this.fileid).isSupported(workdir, name);
    }
}

