/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.box.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;

public class BoxDeleteFeature
implements Delete {
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxDeleteFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path f : files.keySet()) {
            try {
                if (f.isDirectory()) {
                    new FoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).deleteFoldersId(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener()), null, true);
                    continue;
                }
                new FilesApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).deleteFilesId(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener()), null);
            }
            catch (ApiException e) {
                throw new BoxExceptionMappingService(this.fileid).map("Cannot delete {0}", e, f);
            }
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

