/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxDeleteFeature;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.box.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.box.io.swagger.client.model.FileIdCopyBody;
import ch.cyberduck.core.box.io.swagger.client.model.FilesfileIdcopyParent;
import ch.cyberduck.core.box.io.swagger.client.model.FolderIdCopyBody;
import ch.cyberduck.core.box.io.swagger.client.model.FoldersfolderIdcopyParent;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(BoxCopyFeature.class);
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxCopyFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path file, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Delete file %s to be replaced with %s", target, file));
                }
                new BoxDeleteFeature(this.session, this.fileid).delete(Collections.singletonList(target), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
            }
            if (file.isDirectory()) {
                return target.withAttributes(new BoxAttributesFinderFeature(this.session, this.fileid).toAttributes(new FoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).postFoldersIdCopy(this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()), new FolderIdCopyBody().name(target.getName()).parent(new FoldersfolderIdcopyParent().id(this.fileid.getFileId(target.getParent(), (ListProgressListener)new DisabledListProgressListener()))), BoxAttributesFinderFeature.DEFAULT_FIELDS)));
            }
            return target.withAttributes(new BoxAttributesFinderFeature(this.session, this.fileid).toAttributes(new FilesApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).postFilesIdCopy(this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()), new FileIdCopyBody().name(target.getName()).parent(new FilesfileIdcopyParent().id(this.fileid.getFileId(target.getParent(), (ListProgressListener)new DisabledListProgressListener()))), null, BoxAttributesFinderFeature.DEFAULT_FIELDS)));
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map("Cannot copy {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

