/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxAttributesFinderFeature;
import ch.cyberduck.core.box.BoxBase64SHA1ChecksumCompute;
import ch.cyberduck.core.box.BoxClientErrorResponseHandler;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.JSON;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.UploadedPart;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoxChunkedWriteFeature
extends AbstractHttpWriteFeature<File> {
    private static final Logger log = LogManager.getLogger(BoxChunkedWriteFeature.class);
    private final BoxSession session;
    private final BoxApiClient client;

    public BoxChunkedWriteFeature(BoxSession session, BoxFileidProvider fileid) {
        super((AttributesAdapter)new BoxAttributesFinderFeature(session, fileid));
        this.session = session;
        this.client = new BoxApiClient((CloseableHttpClient)session.getClient());
        this.client.setBasePath("https://upload.box.com/api/2.0");
    }

    public HttpResponseOutputStream<File> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<File> command = new DelayedHttpEntityCallable<File>(){

            public File call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HttpRange range = HttpRange.withStatus((TransferStatus)new TransferStatus().withLength(status.getLength()).withOffset(status.getOffset()));
                    String uploadSessionId = (String)status.getParameters().get("uploadSessionId");
                    String overall_length = (String)status.getParameters().get("overall-length");
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Send range %s for file %s", range, file));
                    }
                    HttpPut request = new HttpPut(String.format("%s/files/upload_sessions/%s", BoxChunkedWriteFeature.this.client.getBasePath(), uploadSessionId));
                    request.addHeader((Header)new BasicHeader("Content-Range", String.format("bytes %d-%d/%d", range.getStart(), range.getEnd(), Long.valueOf(overall_length))));
                    request.addHeader((Header)new BasicHeader("Digest", String.format("sha=%s", status.getChecksum())));
                    request.setEntity((HttpEntity)entity);
                    UploadedPart uploadedPart = (UploadedPart)((CloseableHttpClient)BoxChunkedWriteFeature.this.session.getClient()).execute((HttpUriRequest)request, (ResponseHandler)new BoxClientErrorResponseHandler<UploadedPart>(){

                        public UploadedPart handleEntity(HttpEntity entity1) throws IOException {
                            return (UploadedPart)new JSON().getContext(null).readValue(entity1.getContent(), UploadedPart.class);
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Received response %s for upload of %s", uploadedPart, file));
                    }
                    return new File().size(status.getLength()).sha1(uploadedPart.getPart().getSha1());
                }
                catch (HttpResponseException e) {
                    throw new DefaultHttpResponseExceptionMappingService().map(e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return -1L;
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new BoxBase64SHA1ChecksumCompute();
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }
}

