/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.box;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.box.BoxApiClient;
import ch.cyberduck.core.box.BoxExceptionMappingService;
import ch.cyberduck.core.box.BoxFileidProvider;
import ch.cyberduck.core.box.BoxSession;
import ch.cyberduck.core.box.io.swagger.client.ApiException;
import ch.cyberduck.core.box.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.box.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.box.io.swagger.client.model.File;
import ch.cyberduck.core.box.io.swagger.client.model.Folder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import java.util.Arrays;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;

public class BoxAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<File> {
    public static final List<String> DEFAULT_FIELDS = Arrays.asList("id", "etag", "name", "size", "content_modified_at", "content_created_at", "file_version", "file_id", "sha1");
    private final BoxSession session;
    private final BoxFileidProvider fileid;

    public BoxAttributesFinderFeature(BoxSession session, BoxFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            if (file.isDirectory()) {
                return this.toAttributes(new FoldersApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).getFoldersId(this.fileid.getFileId(file, listener), DEFAULT_FIELDS, null, null));
            }
            return this.toAttributes(new FilesApi(new BoxApiClient((CloseableHttpClient)this.session.getClient())).getFilesId(this.fileid.getFileId(file, listener), "", DEFAULT_FIELDS, null, null));
        }
        catch (ApiException e) {
            throw new BoxExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(File f) {
        PathAttributes attrs = new PathAttributes();
        if (null != f.getContentModifiedAt()) {
            attrs.setModificationDate(f.getContentModifiedAt().getMillis());
        }
        if (null != f.getContentCreatedAt()) {
            attrs.setCreationDate(f.getContentCreatedAt().getMillis());
        }
        if (f.getSize() != null) {
            attrs.setSize(f.getSize().longValue());
        }
        attrs.setFileId(f.getId());
        attrs.setChecksum(new Checksum(HashAlgorithm.sha1, f.getSha1()));
        attrs.setETag(f.getEtag());
        return attrs;
    }

    protected PathAttributes toAttributes(Folder f) {
        PathAttributes attrs = new PathAttributes();
        if (null != f.getContentModifiedAt()) {
            attrs.setModificationDate(f.getContentModifiedAt().getMillis());
        }
        if (null != f.getContentCreatedAt()) {
            attrs.setCreationDate(f.getContentCreatedAt().getMillis());
        }
        if (f.getTrashedAt() != null) {
            attrs.setHidden(true);
        }
        attrs.setSize(f.getSize().longValue());
        attrs.setFileId(f.getId());
        return attrs;
    }
}

