/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

public class UserIdApiKeysBody {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="expires_at")
    private DateTime expiresAt = null;
    @JsonProperty(value="permission_set")
    private PermissionSetEnum permissionSet = PermissionSetEnum.FULL;
    @JsonProperty(value="path")
    private String path = null;

    public UserIdApiKeysBody name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="My Main API Key", description="Internal name for the API Key.  For your use.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserIdApiKeysBody expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="API Key expiration date")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public UserIdApiKeysBody permissionSet(PermissionSetEnum permissionSet) {
        this.permissionSet = permissionSet;
        return this;
    }

    @Schema(example="full", description="Permissions for this API Key.  Keys with the `desktop_app` permission set only have the ability to do the functions provided in our Desktop App (File and Share Link operations).  Additional permission sets may become available in the future, such as for a Site Admin to give a key with no administrator privileges.  If you have ideas for permission sets, please let us know.")
    public PermissionSetEnum getPermissionSet() {
        return this.permissionSet;
    }

    public void setPermissionSet(PermissionSetEnum permissionSet) {
        this.permissionSet = permissionSet;
    }

    public UserIdApiKeysBody path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="shared/docs", description="Folder path restriction for this api key.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdApiKeysBody userIdApiKeysBody = (UserIdApiKeysBody)o;
        return Objects.equals(this.name, userIdApiKeysBody.name) && Objects.equals(this.expiresAt, userIdApiKeysBody.expiresAt) && Objects.equals((Object)this.permissionSet, (Object)userIdApiKeysBody.permissionSet) && Objects.equals(this.path, userIdApiKeysBody.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.expiresAt, this.permissionSet, this.path});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserIdApiKeysBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    permissionSet: ").append(this.toIndentedString((Object)this.permissionSet)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionSetEnum {
        NONE("none"),
        FULL("full"),
        DESKTOP_APP("desktop_app"),
        SYNC_APP("sync_app"),
        OFFICE_INTEGRATION("office_integration");

        private String value;

        private PermissionSetEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionSetEnum fromValue(String text) {
            for (PermissionSetEnum b : PermissionSetEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

