/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Create User")
public class UserEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="admin_group_ids")
    private List<Integer> adminGroupIds = null;
    @JsonProperty(value="allowed_ips")
    private String allowedIps = null;
    @JsonProperty(value="attachments_permission")
    private Boolean attachmentsPermission = null;
    @JsonProperty(value="api_keys_count")
    private Integer apiKeysCount = null;
    @JsonProperty(value="authenticate_until")
    private DateTime authenticateUntil = null;
    @JsonProperty(value="authentication_method")
    private AuthenticationMethodEnum authenticationMethod = null;
    @JsonProperty(value="avatar_url")
    private String avatarUrl = null;
    @JsonProperty(value="billing_permission")
    private Boolean billingPermission = null;
    @JsonProperty(value="bypass_site_allowed_ips")
    private Boolean bypassSiteAllowedIps = null;
    @JsonProperty(value="bypass_inactive_disable")
    private Boolean bypassInactiveDisable = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="dav_permission")
    private Boolean davPermission = null;
    @JsonProperty(value="disabled")
    private Boolean disabled = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="ftp_permission")
    private Boolean ftpPermission = null;
    @JsonProperty(value="group_ids")
    private String groupIds = null;
    @JsonProperty(value="header_text")
    private String headerText = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="last_login_at")
    private DateTime lastLoginAt = null;
    @JsonProperty(value="last_protocol_cipher")
    private String lastProtocolCipher = null;
    @JsonProperty(value="lockout_expires")
    private DateTime lockoutExpires = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="company")
    private String company = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="notification_daily_send_time")
    private Integer notificationDailySendTime = null;
    @JsonProperty(value="office_integration_enabled")
    private Boolean officeIntegrationEnabled = null;
    @JsonProperty(value="password_set_at")
    private DateTime passwordSetAt = null;
    @JsonProperty(value="password_validity_days")
    private Integer passwordValidityDays = null;
    @JsonProperty(value="public_keys_count")
    private Integer publicKeysCount = null;
    @JsonProperty(value="receive_admin_alerts")
    private Boolean receiveAdminAlerts = null;
    @JsonProperty(value="require_2fa")
    private Require2faEnum require2fa = null;
    @JsonProperty(value="active_2fa")
    private Boolean active2fa = null;
    @JsonProperty(value="require_password_change")
    private Boolean requirePasswordChange = null;
    @JsonProperty(value="restapi_permission")
    private Boolean restapiPermission = null;
    @JsonProperty(value="self_managed")
    private Boolean selfManaged = null;
    @JsonProperty(value="sftp_permission")
    private Boolean sftpPermission = null;
    @JsonProperty(value="site_admin")
    private Boolean siteAdmin = null;
    @JsonProperty(value="skip_welcome_screen")
    private Boolean skipWelcomeScreen = null;
    @JsonProperty(value="ssl_required")
    private SslRequiredEnum sslRequired = null;
    @JsonProperty(value="sso_strategy_id")
    private Integer ssoStrategyId = null;
    @JsonProperty(value="subscribe_to_newsletter")
    private Boolean subscribeToNewsletter = null;
    @JsonProperty(value="externally_managed")
    private Boolean externallyManaged = null;
    @JsonProperty(value="time_zone")
    private String timeZone = null;
    @JsonProperty(value="type_of_2fa")
    private String typeOf2fa = "yubi";
    @JsonProperty(value="user_root")
    private String userRoot = null;

    public UserEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="User ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public UserEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="user", description="User's username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserEntity adminGroupIds(List<Integer> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
        return this;
    }

    public UserEntity addAdminGroupIdsItem(Integer adminGroupIdsItem) {
        if (this.adminGroupIds == null) {
            this.adminGroupIds = new ArrayList<Integer>();
        }
        this.adminGroupIds.add(adminGroupIdsItem);
        return this;
    }

    @Schema(example="[1]", description="List of group IDs of which this user is an administrator")
    public List<Integer> getAdminGroupIds() {
        return this.adminGroupIds;
    }

    public void setAdminGroupIds(List<Integer> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    public UserEntity allowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
        return this;
    }

    @Schema(example="127.0.0.1", description="A list of allowed IPs if applicable.  Newline delimited")
    public String getAllowedIps() {
        return this.allowedIps;
    }

    public void setAllowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
    }

    public UserEntity attachmentsPermission(Boolean attachmentsPermission) {
        this.attachmentsPermission = attachmentsPermission;
        return this;
    }

    @Schema(example="true", description="DEPRECATED: Can the user create Bundles (aka Share Links)? Use the bundle permission instead.")
    public Boolean isAttachmentsPermission() {
        return this.attachmentsPermission;
    }

    public void setAttachmentsPermission(Boolean attachmentsPermission) {
        this.attachmentsPermission = attachmentsPermission;
    }

    public UserEntity apiKeysCount(Integer apiKeysCount) {
        this.apiKeysCount = apiKeysCount;
        return this;
    }

    @Schema(example="1", description="Number of api keys associated with this user")
    public Integer getApiKeysCount() {
        return this.apiKeysCount;
    }

    public void setApiKeysCount(Integer apiKeysCount) {
        this.apiKeysCount = apiKeysCount;
    }

    public UserEntity authenticateUntil(DateTime authenticateUntil) {
        this.authenticateUntil = authenticateUntil;
        return this;
    }

    @Schema(description="Scheduled Date/Time at which user will be deactivated")
    public DateTime getAuthenticateUntil() {
        return this.authenticateUntil;
    }

    public void setAuthenticateUntil(DateTime authenticateUntil) {
        this.authenticateUntil = authenticateUntil;
    }

    public UserEntity authenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @Schema(example="password", description="How is this user authenticated?")
    public AuthenticationMethodEnum getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public UserEntity avatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @Schema(description="URL holding the user's avatar")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public UserEntity billingPermission(Boolean billingPermission) {
        this.billingPermission = billingPermission;
        return this;
    }

    @Schema(description="Allow this user to perform operations on the account, payments, and invoices?")
    public Boolean isBillingPermission() {
        return this.billingPermission;
    }

    public void setBillingPermission(Boolean billingPermission) {
        this.billingPermission = billingPermission;
    }

    public UserEntity bypassSiteAllowedIps(Boolean bypassSiteAllowedIps) {
        this.bypassSiteAllowedIps = bypassSiteAllowedIps;
        return this;
    }

    @Schema(description="Allow this user to skip site-wide IP blacklists?")
    public Boolean isBypassSiteAllowedIps() {
        return this.bypassSiteAllowedIps;
    }

    public void setBypassSiteAllowedIps(Boolean bypassSiteAllowedIps) {
        this.bypassSiteAllowedIps = bypassSiteAllowedIps;
    }

    public UserEntity bypassInactiveDisable(Boolean bypassInactiveDisable) {
        this.bypassInactiveDisable = bypassInactiveDisable;
        return this;
    }

    @Schema(description="Exempt this user from being disabled based on inactivity?")
    public Boolean isBypassInactiveDisable() {
        return this.bypassInactiveDisable;
    }

    public void setBypassInactiveDisable(Boolean bypassInactiveDisable) {
        this.bypassInactiveDisable = bypassInactiveDisable;
    }

    public UserEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="When this user was created")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UserEntity davPermission(Boolean davPermission) {
        this.davPermission = davPermission;
        return this;
    }

    @Schema(example="true", description="Can the user connect with WebDAV?")
    public Boolean isDavPermission() {
        return this.davPermission;
    }

    public void setDavPermission(Boolean davPermission) {
        this.davPermission = davPermission;
    }

    public UserEntity disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Schema(example="true", description="Is user disabled? Disabled users cannot log in, and do not count for billing purposes.  Users can be automatically disabled after an inactivity period via a Site setting.")
    public Boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public UserEntity email(String email) {
        this.email = email;
        return this;
    }

    @Schema(example="john.doe@files.com", description="User email address")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserEntity ftpPermission(Boolean ftpPermission) {
        this.ftpPermission = ftpPermission;
        return this;
    }

    @Schema(example="true", description="Can the user access with FTP/FTPS?")
    public Boolean isFtpPermission() {
        return this.ftpPermission;
    }

    public void setFtpPermission(Boolean ftpPermission) {
        this.ftpPermission = ftpPermission;
    }

    public UserEntity groupIds(String groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    @Schema(description="Comma-separated list of group IDs of which this user is a member")
    public String getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }

    public UserEntity headerText(String headerText) {
        this.headerText = headerText;
        return this;
    }

    @Schema(example="User-specific message.", description="Text to display to the user in the header of the UI")
    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public UserEntity language(String language) {
        this.language = language;
        return this;
    }

    @Schema(example="en", description="Preferred language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public UserEntity lastLoginAt(DateTime lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
        return this;
    }

    @Schema(description="User's last login time")
    public DateTime getLastLoginAt() {
        return this.lastLoginAt;
    }

    public void setLastLoginAt(DateTime lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    public UserEntity lastProtocolCipher(String lastProtocolCipher) {
        this.lastProtocolCipher = lastProtocolCipher;
        return this;
    }

    @Schema(description="The last protocol and cipher used")
    public String getLastProtocolCipher() {
        return this.lastProtocolCipher;
    }

    public void setLastProtocolCipher(String lastProtocolCipher) {
        this.lastProtocolCipher = lastProtocolCipher;
    }

    public UserEntity lockoutExpires(DateTime lockoutExpires) {
        this.lockoutExpires = lockoutExpires;
        return this;
    }

    @Schema(description="Time in the future that the user will no longer be locked out if applicable")
    public DateTime getLockoutExpires() {
        return this.lockoutExpires;
    }

    public void setLockoutExpires(DateTime lockoutExpires) {
        this.lockoutExpires = lockoutExpires;
    }

    public UserEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="John Doe", description="User's full name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserEntity company(String company) {
        this.company = company;
        return this;
    }

    @Schema(example="ACME Corp.", description="User's company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public UserEntity notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(example="Internal notes on this user.", description="Any internal notes on the user")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public UserEntity notificationDailySendTime(Integer notificationDailySendTime) {
        this.notificationDailySendTime = notificationDailySendTime;
        return this;
    }

    @Schema(example="18", description="Hour of the day at which daily notifications should be sent. Can be in range 0 to 23")
    public Integer getNotificationDailySendTime() {
        return this.notificationDailySendTime;
    }

    public void setNotificationDailySendTime(Integer notificationDailySendTime) {
        this.notificationDailySendTime = notificationDailySendTime;
    }

    public UserEntity officeIntegrationEnabled(Boolean officeIntegrationEnabled) {
        this.officeIntegrationEnabled = officeIntegrationEnabled;
        return this;
    }

    @Schema(example="true", description="Enable integration with Office for the web?")
    public Boolean isOfficeIntegrationEnabled() {
        return this.officeIntegrationEnabled;
    }

    public void setOfficeIntegrationEnabled(Boolean officeIntegrationEnabled) {
        this.officeIntegrationEnabled = officeIntegrationEnabled;
    }

    public UserEntity passwordSetAt(DateTime passwordSetAt) {
        this.passwordSetAt = passwordSetAt;
        return this;
    }

    @Schema(description="Last time the user's password was set")
    public DateTime getPasswordSetAt() {
        return this.passwordSetAt;
    }

    public void setPasswordSetAt(DateTime passwordSetAt) {
        this.passwordSetAt = passwordSetAt;
    }

    public UserEntity passwordValidityDays(Integer passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
        return this;
    }

    @Schema(example="1", description="Number of days to allow user to use the same password")
    public Integer getPasswordValidityDays() {
        return this.passwordValidityDays;
    }

    public void setPasswordValidityDays(Integer passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
    }

    public UserEntity publicKeysCount(Integer publicKeysCount) {
        this.publicKeysCount = publicKeysCount;
        return this;
    }

    @Schema(example="1", description="Number of public keys associated with this user")
    public Integer getPublicKeysCount() {
        return this.publicKeysCount;
    }

    public void setPublicKeysCount(Integer publicKeysCount) {
        this.publicKeysCount = publicKeysCount;
    }

    public UserEntity receiveAdminAlerts(Boolean receiveAdminAlerts) {
        this.receiveAdminAlerts = receiveAdminAlerts;
        return this;
    }

    @Schema(example="true", description="Should the user receive admin alerts such a certificate expiration notifications and overages?")
    public Boolean isReceiveAdminAlerts() {
        return this.receiveAdminAlerts;
    }

    public void setReceiveAdminAlerts(Boolean receiveAdminAlerts) {
        this.receiveAdminAlerts = receiveAdminAlerts;
    }

    public UserEntity require2fa(Require2faEnum require2fa) {
        this.require2fa = require2fa;
        return this;
    }

    @Schema(example="always_require", description="2FA required setting")
    public Require2faEnum getRequire2fa() {
        return this.require2fa;
    }

    public void setRequire2fa(Require2faEnum require2fa) {
        this.require2fa = require2fa;
    }

    public UserEntity active2fa(Boolean active2fa) {
        this.active2fa = active2fa;
        return this;
    }

    @Schema(example="true", description="Is 2fa active for the user?")
    public Boolean isActive2fa() {
        return this.active2fa;
    }

    public void setActive2fa(Boolean active2fa) {
        this.active2fa = active2fa;
    }

    public UserEntity requirePasswordChange(Boolean requirePasswordChange) {
        this.requirePasswordChange = requirePasswordChange;
        return this;
    }

    @Schema(example="true", description="Is a password change required upon next user login?")
    public Boolean isRequirePasswordChange() {
        return this.requirePasswordChange;
    }

    public void setRequirePasswordChange(Boolean requirePasswordChange) {
        this.requirePasswordChange = requirePasswordChange;
    }

    public UserEntity restapiPermission(Boolean restapiPermission) {
        this.restapiPermission = restapiPermission;
        return this;
    }

    @Schema(example="true", description="Can this user access the REST API?")
    public Boolean isRestapiPermission() {
        return this.restapiPermission;
    }

    public void setRestapiPermission(Boolean restapiPermission) {
        this.restapiPermission = restapiPermission;
    }

    public UserEntity selfManaged(Boolean selfManaged) {
        this.selfManaged = selfManaged;
        return this;
    }

    @Schema(example="true", description="Does this user manage it's own credentials or is it a shared/bot user?")
    public Boolean isSelfManaged() {
        return this.selfManaged;
    }

    public void setSelfManaged(Boolean selfManaged) {
        this.selfManaged = selfManaged;
    }

    public UserEntity sftpPermission(Boolean sftpPermission) {
        this.sftpPermission = sftpPermission;
        return this;
    }

    @Schema(example="true", description="Can the user access with SFTP?")
    public Boolean isSftpPermission() {
        return this.sftpPermission;
    }

    public void setSftpPermission(Boolean sftpPermission) {
        this.sftpPermission = sftpPermission;
    }

    public UserEntity siteAdmin(Boolean siteAdmin) {
        this.siteAdmin = siteAdmin;
        return this;
    }

    @Schema(example="true", description="Is the user an administrator for this site?")
    public Boolean isSiteAdmin() {
        return this.siteAdmin;
    }

    public void setSiteAdmin(Boolean siteAdmin) {
        this.siteAdmin = siteAdmin;
    }

    public UserEntity skipWelcomeScreen(Boolean skipWelcomeScreen) {
        this.skipWelcomeScreen = skipWelcomeScreen;
        return this;
    }

    @Schema(example="true", description="Skip Welcome page in the UI?")
    public Boolean isSkipWelcomeScreen() {
        return this.skipWelcomeScreen;
    }

    public void setSkipWelcomeScreen(Boolean skipWelcomeScreen) {
        this.skipWelcomeScreen = skipWelcomeScreen;
    }

    public UserEntity sslRequired(SslRequiredEnum sslRequired) {
        this.sslRequired = sslRequired;
        return this;
    }

    @Schema(example="always_require", description="SSL required setting")
    public SslRequiredEnum getSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(SslRequiredEnum sslRequired) {
        this.sslRequired = sslRequired;
    }

    public UserEntity ssoStrategyId(Integer ssoStrategyId) {
        this.ssoStrategyId = ssoStrategyId;
        return this;
    }

    @Schema(example="1", description="SSO (Single Sign On) strategy ID for the user, if applicable.")
    public Integer getSsoStrategyId() {
        return this.ssoStrategyId;
    }

    public void setSsoStrategyId(Integer ssoStrategyId) {
        this.ssoStrategyId = ssoStrategyId;
    }

    public UserEntity subscribeToNewsletter(Boolean subscribeToNewsletter) {
        this.subscribeToNewsletter = subscribeToNewsletter;
        return this;
    }

    @Schema(example="true", description="Is the user subscribed to the newsletter?")
    public Boolean isSubscribeToNewsletter() {
        return this.subscribeToNewsletter;
    }

    public void setSubscribeToNewsletter(Boolean subscribeToNewsletter) {
        this.subscribeToNewsletter = subscribeToNewsletter;
    }

    public UserEntity externallyManaged(Boolean externallyManaged) {
        this.externallyManaged = externallyManaged;
        return this;
    }

    @Schema(example="true", description="Is this user managed by a SsoStrategy?")
    public Boolean isExternallyManaged() {
        return this.externallyManaged;
    }

    public void setExternallyManaged(Boolean externallyManaged) {
        this.externallyManaged = externallyManaged;
    }

    public UserEntity timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Schema(example="Pacific Time (US & Canada)", description="User time zone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public UserEntity typeOf2fa(String typeOf2fa) {
        this.typeOf2fa = typeOf2fa;
        return this;
    }

    @Schema(description="Type(s) of 2FA methods in use.  Will be either `sms`, `totp`, `u2f`, `yubi`, or multiple values sorted alphabetically and joined by an underscore.")
    public String getTypeOf2fa() {
        return this.typeOf2fa;
    }

    public void setTypeOf2fa(String typeOf2fa) {
        this.typeOf2fa = typeOf2fa;
    }

    public UserEntity userRoot(String userRoot) {
        this.userRoot = userRoot;
        return this;
    }

    @Schema(description="Root folder for FTP (and optionally SFTP if the appropriate site-wide setting is set.)  Note that this is not used for API, Desktop, or Web interface.")
    public String getUserRoot() {
        return this.userRoot;
    }

    public void setUserRoot(String userRoot) {
        this.userRoot = userRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntity userEntity = (UserEntity)o;
        return Objects.equals(this.id, userEntity.id) && Objects.equals(this.username, userEntity.username) && Objects.equals(this.adminGroupIds, userEntity.adminGroupIds) && Objects.equals(this.allowedIps, userEntity.allowedIps) && Objects.equals(this.attachmentsPermission, userEntity.attachmentsPermission) && Objects.equals(this.apiKeysCount, userEntity.apiKeysCount) && Objects.equals(this.authenticateUntil, userEntity.authenticateUntil) && Objects.equals((Object)this.authenticationMethod, (Object)userEntity.authenticationMethod) && Objects.equals(this.avatarUrl, userEntity.avatarUrl) && Objects.equals(this.billingPermission, userEntity.billingPermission) && Objects.equals(this.bypassSiteAllowedIps, userEntity.bypassSiteAllowedIps) && Objects.equals(this.bypassInactiveDisable, userEntity.bypassInactiveDisable) && Objects.equals(this.createdAt, userEntity.createdAt) && Objects.equals(this.davPermission, userEntity.davPermission) && Objects.equals(this.disabled, userEntity.disabled) && Objects.equals(this.email, userEntity.email) && Objects.equals(this.ftpPermission, userEntity.ftpPermission) && Objects.equals(this.groupIds, userEntity.groupIds) && Objects.equals(this.headerText, userEntity.headerText) && Objects.equals(this.language, userEntity.language) && Objects.equals(this.lastLoginAt, userEntity.lastLoginAt) && Objects.equals(this.lastProtocolCipher, userEntity.lastProtocolCipher) && Objects.equals(this.lockoutExpires, userEntity.lockoutExpires) && Objects.equals(this.name, userEntity.name) && Objects.equals(this.company, userEntity.company) && Objects.equals(this.notes, userEntity.notes) && Objects.equals(this.notificationDailySendTime, userEntity.notificationDailySendTime) && Objects.equals(this.officeIntegrationEnabled, userEntity.officeIntegrationEnabled) && Objects.equals(this.passwordSetAt, userEntity.passwordSetAt) && Objects.equals(this.passwordValidityDays, userEntity.passwordValidityDays) && Objects.equals(this.publicKeysCount, userEntity.publicKeysCount) && Objects.equals(this.receiveAdminAlerts, userEntity.receiveAdminAlerts) && Objects.equals((Object)this.require2fa, (Object)userEntity.require2fa) && Objects.equals(this.active2fa, userEntity.active2fa) && Objects.equals(this.requirePasswordChange, userEntity.requirePasswordChange) && Objects.equals(this.restapiPermission, userEntity.restapiPermission) && Objects.equals(this.selfManaged, userEntity.selfManaged) && Objects.equals(this.sftpPermission, userEntity.sftpPermission) && Objects.equals(this.siteAdmin, userEntity.siteAdmin) && Objects.equals(this.skipWelcomeScreen, userEntity.skipWelcomeScreen) && Objects.equals((Object)this.sslRequired, (Object)userEntity.sslRequired) && Objects.equals(this.ssoStrategyId, userEntity.ssoStrategyId) && Objects.equals(this.subscribeToNewsletter, userEntity.subscribeToNewsletter) && Objects.equals(this.externallyManaged, userEntity.externallyManaged) && Objects.equals(this.timeZone, userEntity.timeZone) && Objects.equals(this.typeOf2fa, userEntity.typeOf2fa) && Objects.equals(this.userRoot, userEntity.userRoot);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.username, this.adminGroupIds, this.allowedIps, this.attachmentsPermission, this.apiKeysCount, this.authenticateUntil, this.authenticationMethod, this.avatarUrl, this.billingPermission, this.bypassSiteAllowedIps, this.bypassInactiveDisable, this.createdAt, this.davPermission, this.disabled, this.email, this.ftpPermission, this.groupIds, this.headerText, this.language, this.lastLoginAt, this.lastProtocolCipher, this.lockoutExpires, this.name, this.company, this.notes, this.notificationDailySendTime, this.officeIntegrationEnabled, this.passwordSetAt, this.passwordValidityDays, this.publicKeysCount, this.receiveAdminAlerts, this.require2fa, this.active2fa, this.requirePasswordChange, this.restapiPermission, this.selfManaged, this.sftpPermission, this.siteAdmin, this.skipWelcomeScreen, this.sslRequired, this.ssoStrategyId, this.subscribeToNewsletter, this.externallyManaged, this.timeZone, this.typeOf2fa, this.userRoot});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    adminGroupIds: ").append(this.toIndentedString(this.adminGroupIds)).append("\n");
        sb.append("    allowedIps: ").append(this.toIndentedString(this.allowedIps)).append("\n");
        sb.append("    attachmentsPermission: ").append(this.toIndentedString(this.attachmentsPermission)).append("\n");
        sb.append("    apiKeysCount: ").append(this.toIndentedString(this.apiKeysCount)).append("\n");
        sb.append("    authenticateUntil: ").append(this.toIndentedString(this.authenticateUntil)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString((Object)this.authenticationMethod)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    billingPermission: ").append(this.toIndentedString(this.billingPermission)).append("\n");
        sb.append("    bypassSiteAllowedIps: ").append(this.toIndentedString(this.bypassSiteAllowedIps)).append("\n");
        sb.append("    bypassInactiveDisable: ").append(this.toIndentedString(this.bypassInactiveDisable)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    davPermission: ").append(this.toIndentedString(this.davPermission)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    ftpPermission: ").append(this.toIndentedString(this.ftpPermission)).append("\n");
        sb.append("    groupIds: ").append(this.toIndentedString(this.groupIds)).append("\n");
        sb.append("    headerText: ").append(this.toIndentedString(this.headerText)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lastLoginAt: ").append(this.toIndentedString(this.lastLoginAt)).append("\n");
        sb.append("    lastProtocolCipher: ").append(this.toIndentedString(this.lastProtocolCipher)).append("\n");
        sb.append("    lockoutExpires: ").append(this.toIndentedString(this.lockoutExpires)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    notificationDailySendTime: ").append(this.toIndentedString(this.notificationDailySendTime)).append("\n");
        sb.append("    officeIntegrationEnabled: ").append(this.toIndentedString(this.officeIntegrationEnabled)).append("\n");
        sb.append("    passwordSetAt: ").append(this.toIndentedString(this.passwordSetAt)).append("\n");
        sb.append("    passwordValidityDays: ").append(this.toIndentedString(this.passwordValidityDays)).append("\n");
        sb.append("    publicKeysCount: ").append(this.toIndentedString(this.publicKeysCount)).append("\n");
        sb.append("    receiveAdminAlerts: ").append(this.toIndentedString(this.receiveAdminAlerts)).append("\n");
        sb.append("    require2fa: ").append(this.toIndentedString((Object)this.require2fa)).append("\n");
        sb.append("    active2fa: ").append(this.toIndentedString(this.active2fa)).append("\n");
        sb.append("    requirePasswordChange: ").append(this.toIndentedString(this.requirePasswordChange)).append("\n");
        sb.append("    restapiPermission: ").append(this.toIndentedString(this.restapiPermission)).append("\n");
        sb.append("    selfManaged: ").append(this.toIndentedString(this.selfManaged)).append("\n");
        sb.append("    sftpPermission: ").append(this.toIndentedString(this.sftpPermission)).append("\n");
        sb.append("    siteAdmin: ").append(this.toIndentedString(this.siteAdmin)).append("\n");
        sb.append("    skipWelcomeScreen: ").append(this.toIndentedString(this.skipWelcomeScreen)).append("\n");
        sb.append("    sslRequired: ").append(this.toIndentedString((Object)this.sslRequired)).append("\n");
        sb.append("    ssoStrategyId: ").append(this.toIndentedString(this.ssoStrategyId)).append("\n");
        sb.append("    subscribeToNewsletter: ").append(this.toIndentedString(this.subscribeToNewsletter)).append("\n");
        sb.append("    externallyManaged: ").append(this.toIndentedString(this.externallyManaged)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    typeOf2fa: ").append(this.toIndentedString(this.typeOf2fa)).append("\n");
        sb.append("    userRoot: ").append(this.toIndentedString(this.userRoot)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthenticationMethodEnum {
        PASSWORD("password"),
        UNUSED_FORMER_LDAP("unused_former_ldap"),
        SSO("sso"),
        NONE("none"),
        EMAIL_SIGNUP("email_signup");

        private String value;

        private AuthenticationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthenticationMethodEnum fromValue(String text) {
            for (AuthenticationMethodEnum b : AuthenticationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Require2faEnum {
        USE_SYSTEM_SETTING("use_system_setting"),
        ALWAYS_REQUIRE("always_require"),
        NEVER_REQUIRE("never_require");

        private String value;

        private Require2faEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static Require2faEnum fromValue(String text) {
            for (Require2faEnum b : Require2faEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum SslRequiredEnum {
        USE_SYSTEM_SETTING("use_system_setting"),
        ALWAYS_REQUIRE("always_require"),
        NEVER_REQUIRE("never_require");

        private String value;

        private SslRequiredEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SslRequiredEnum fromValue(String text) {
            for (SslRequiredEnum b : SslRequiredEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

