/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List User Cipher Uses")
public class UserCipherUseEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="protocol_cipher")
    private String protocolCipher = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="interface")
    private InterfaceEnum _interface = null;
    @JsonProperty(value="updated_at")
    private DateTime updatedAt = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;

    public UserCipherUseEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="UserCipherUse ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public UserCipherUseEntity protocolCipher(String protocolCipher) {
        this.protocolCipher = protocolCipher;
        return this;
    }

    @Schema(example="TLSv1.2; ECDHE-RSA-AES256-GCM-SHA384", description="The protocol and cipher employed")
    public String getProtocolCipher() {
        return this.protocolCipher;
    }

    public void setProtocolCipher(String protocolCipher) {
        this.protocolCipher = protocolCipher;
    }

    public UserCipherUseEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="The earliest recorded use of this combination of interface and protocol and cipher (for this user)")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UserCipherUseEntity _interface(InterfaceEnum _interface) {
        this._interface = _interface;
        return this;
    }

    @Schema(example="restapi", description="The interface accessed")
    public InterfaceEnum getInterface() {
        return this._interface;
    }

    public void setInterface(InterfaceEnum _interface) {
        this._interface = _interface;
    }

    public UserCipherUseEntity updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="The most recent use of this combination of interface and protocol and cipher (for this user)")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public UserCipherUseEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="ID of the user who performed this access")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCipherUseEntity userCipherUseEntity = (UserCipherUseEntity)o;
        return Objects.equals(this.id, userCipherUseEntity.id) && Objects.equals(this.protocolCipher, userCipherUseEntity.protocolCipher) && Objects.equals(this.createdAt, userCipherUseEntity.createdAt) && Objects.equals((Object)this._interface, (Object)userCipherUseEntity._interface) && Objects.equals(this.updatedAt, userCipherUseEntity.updatedAt) && Objects.equals(this.userId, userCipherUseEntity.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.protocolCipher, this.createdAt, this._interface, this.updatedAt, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCipherUseEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    protocolCipher: ").append(this.toIndentedString(this.protocolCipher)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    _interface: ").append(this.toIndentedString((Object)this._interface)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InterfaceEnum {
        WEB("web"),
        FTP("ftp"),
        SFTP("sftp"),
        DAV("dav"),
        DESKTOP("desktop"),
        RESTAPI("restapi"),
        ROBOT("robot"),
        JSAPI("jsapi");

        private String value;

        private InterfaceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InterfaceEnum fromValue(String text) {
            for (InterfaceEnum b : InterfaceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

