/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Usage Snapshots")
public class UsageSnapshotEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="start_at")
    private DateTime startAt = null;
    @JsonProperty(value="end_at")
    private DateTime endAt = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="high_water_user_count")
    private Double highWaterUserCount = null;
    @JsonProperty(value="current_storage")
    private Double currentStorage = null;
    @JsonProperty(value="high_water_storage")
    private Double highWaterStorage = null;
    @JsonProperty(value="total_downloads")
    private Integer totalDownloads = null;
    @JsonProperty(value="total_uploads")
    private Integer totalUploads = null;
    @JsonProperty(value="updated_at")
    private DateTime updatedAt = null;
    @JsonProperty(value="usage_by_top_level_dir")
    private Object usageByTopLevelDir = null;
    @JsonProperty(value="root_storage")
    private Double rootStorage = null;
    @JsonProperty(value="deleted_files_counted_in_minimum")
    private Double deletedFilesCountedInMinimum = null;
    @JsonProperty(value="deleted_files_storage")
    private Double deletedFilesStorage = null;

    public UsageSnapshotEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Site usage ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public UsageSnapshotEntity startAt(DateTime startAt) {
        this.startAt = startAt;
        return this;
    }

    @Schema(description="Site usage report start date/time")
    public DateTime getStartAt() {
        return this.startAt;
    }

    public void setStartAt(DateTime startAt) {
        this.startAt = startAt;
    }

    public UsageSnapshotEntity endAt(DateTime endAt) {
        this.endAt = endAt;
        return this;
    }

    @Schema(description="Site usage report end date/time")
    public DateTime getEndAt() {
        return this.endAt;
    }

    public void setEndAt(DateTime endAt) {
        this.endAt = endAt;
    }

    public UsageSnapshotEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Site usage report created at date/time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UsageSnapshotEntity highWaterUserCount(Double highWaterUserCount) {
        this.highWaterUserCount = highWaterUserCount;
        return this;
    }

    @Schema(example="1", description="Site usage report highest usage in time period")
    public Double getHighWaterUserCount() {
        return this.highWaterUserCount;
    }

    public void setHighWaterUserCount(Double highWaterUserCount) {
        this.highWaterUserCount = highWaterUserCount;
    }

    public UsageSnapshotEntity currentStorage(Double currentStorage) {
        this.currentStorage = currentStorage;
        return this;
    }

    @Schema(example="1", description="Current site usage as of report")
    public Double getCurrentStorage() {
        return this.currentStorage;
    }

    public void setCurrentStorage(Double currentStorage) {
        this.currentStorage = currentStorage;
    }

    public UsageSnapshotEntity highWaterStorage(Double highWaterStorage) {
        this.highWaterStorage = highWaterStorage;
        return this;
    }

    @Schema(example="1", description="Site usage report highest usage in time period")
    public Double getHighWaterStorage() {
        return this.highWaterStorage;
    }

    public void setHighWaterStorage(Double highWaterStorage) {
        this.highWaterStorage = highWaterStorage;
    }

    public UsageSnapshotEntity totalDownloads(Integer totalDownloads) {
        this.totalDownloads = totalDownloads;
        return this;
    }

    @Schema(example="1", description="Number of downloads in report time period")
    public Integer getTotalDownloads() {
        return this.totalDownloads;
    }

    public void setTotalDownloads(Integer totalDownloads) {
        this.totalDownloads = totalDownloads;
    }

    public UsageSnapshotEntity totalUploads(Integer totalUploads) {
        this.totalUploads = totalUploads;
        return this;
    }

    @Schema(example="1", description="Number of uploads in time period")
    public Integer getTotalUploads() {
        return this.totalUploads;
    }

    public void setTotalUploads(Integer totalUploads) {
        this.totalUploads = totalUploads;
    }

    public UsageSnapshotEntity updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="The last time this site usage report was updated")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public UsageSnapshotEntity usageByTopLevelDir(Object usageByTopLevelDir) {
        this.usageByTopLevelDir = usageByTopLevelDir;
        return this;
    }

    @Schema(example="{}", description="A map of root folders to their total usage")
    public Object getUsageByTopLevelDir() {
        return this.usageByTopLevelDir;
    }

    public void setUsageByTopLevelDir(Object usageByTopLevelDir) {
        this.usageByTopLevelDir = usageByTopLevelDir;
    }

    public UsageSnapshotEntity rootStorage(Double rootStorage) {
        this.rootStorage = rootStorage;
        return this;
    }

    @Schema(example="1", description="Usage for root folder")
    public Double getRootStorage() {
        return this.rootStorage;
    }

    public void setRootStorage(Double rootStorage) {
        this.rootStorage = rootStorage;
    }

    public UsageSnapshotEntity deletedFilesCountedInMinimum(Double deletedFilesCountedInMinimum) {
        this.deletedFilesCountedInMinimum = deletedFilesCountedInMinimum;
        return this;
    }

    @Schema(example="1", description="Usage for files that are deleted but uploaded within last 30 days")
    public Double getDeletedFilesCountedInMinimum() {
        return this.deletedFilesCountedInMinimum;
    }

    public void setDeletedFilesCountedInMinimum(Double deletedFilesCountedInMinimum) {
        this.deletedFilesCountedInMinimum = deletedFilesCountedInMinimum;
    }

    public UsageSnapshotEntity deletedFilesStorage(Double deletedFilesStorage) {
        this.deletedFilesStorage = deletedFilesStorage;
        return this;
    }

    @Schema(example="1", description="Usage for files that are deleted but retained as backups")
    public Double getDeletedFilesStorage() {
        return this.deletedFilesStorage;
    }

    public void setDeletedFilesStorage(Double deletedFilesStorage) {
        this.deletedFilesStorage = deletedFilesStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSnapshotEntity usageSnapshotEntity = (UsageSnapshotEntity)o;
        return Objects.equals(this.id, usageSnapshotEntity.id) && Objects.equals(this.startAt, usageSnapshotEntity.startAt) && Objects.equals(this.endAt, usageSnapshotEntity.endAt) && Objects.equals(this.createdAt, usageSnapshotEntity.createdAt) && Objects.equals(this.highWaterUserCount, usageSnapshotEntity.highWaterUserCount) && Objects.equals(this.currentStorage, usageSnapshotEntity.currentStorage) && Objects.equals(this.highWaterStorage, usageSnapshotEntity.highWaterStorage) && Objects.equals(this.totalDownloads, usageSnapshotEntity.totalDownloads) && Objects.equals(this.totalUploads, usageSnapshotEntity.totalUploads) && Objects.equals(this.updatedAt, usageSnapshotEntity.updatedAt) && Objects.equals(this.usageByTopLevelDir, usageSnapshotEntity.usageByTopLevelDir) && Objects.equals(this.rootStorage, usageSnapshotEntity.rootStorage) && Objects.equals(this.deletedFilesCountedInMinimum, usageSnapshotEntity.deletedFilesCountedInMinimum) && Objects.equals(this.deletedFilesStorage, usageSnapshotEntity.deletedFilesStorage);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startAt, this.endAt, this.createdAt, this.highWaterUserCount, this.currentStorage, this.highWaterStorage, this.totalDownloads, this.totalUploads, this.updatedAt, this.usageByTopLevelDir, this.rootStorage, this.deletedFilesCountedInMinimum, this.deletedFilesStorage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSnapshotEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    highWaterUserCount: ").append(this.toIndentedString(this.highWaterUserCount)).append("\n");
        sb.append("    currentStorage: ").append(this.toIndentedString(this.currentStorage)).append("\n");
        sb.append("    highWaterStorage: ").append(this.toIndentedString(this.highWaterStorage)).append("\n");
        sb.append("    totalDownloads: ").append(this.toIndentedString(this.totalDownloads)).append("\n");
        sb.append("    totalUploads: ").append(this.toIndentedString(this.totalUploads)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    usageByTopLevelDir: ").append(this.toIndentedString(this.usageByTopLevelDir)).append("\n");
        sb.append("    rootStorage: ").append(this.toIndentedString(this.rootStorage)).append("\n");
        sb.append("    deletedFilesCountedInMinimum: ").append(this.toIndentedString(this.deletedFilesCountedInMinimum)).append("\n");
        sb.append("    deletedFilesStorage: ").append(this.toIndentedString(this.deletedFilesStorage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

