/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import ch.cyberduck.core.brick.io.swagger.client.model.UsageSnapshotEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.LocalDate;

@Schema(description="List Usage Daily Snapshots")
public class UsageDailySnapshotEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="date")
    private LocalDate date = null;
    @JsonProperty(value="current_storage")
    private Integer currentStorage = null;
    @JsonProperty(value="usage_by_top_level_dir")
    private List<UsageSnapshotEntity> usageByTopLevelDir = null;

    public UsageDailySnapshotEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="ID of the usage record")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public UsageDailySnapshotEntity date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Schema(description="The date of this usage record")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public UsageDailySnapshotEntity currentStorage(Integer currentStorage) {
        this.currentStorage = currentStorage;
        return this;
    }

    @Schema(example="65536", description="The quantity of storage held for this site")
    public Integer getCurrentStorage() {
        return this.currentStorage;
    }

    public void setCurrentStorage(Integer currentStorage) {
        this.currentStorage = currentStorage;
    }

    public UsageDailySnapshotEntity usageByTopLevelDir(List<UsageSnapshotEntity> usageByTopLevelDir) {
        this.usageByTopLevelDir = usageByTopLevelDir;
        return this;
    }

    public UsageDailySnapshotEntity addUsageByTopLevelDirItem(UsageSnapshotEntity usageByTopLevelDirItem) {
        if (this.usageByTopLevelDir == null) {
            this.usageByTopLevelDir = new ArrayList<UsageSnapshotEntity>();
        }
        this.usageByTopLevelDir.add(usageByTopLevelDirItem);
        return this;
    }

    @Schema(description="Usage broken down by each top-level folder")
    public List<UsageSnapshotEntity> getUsageByTopLevelDir() {
        return this.usageByTopLevelDir;
    }

    public void setUsageByTopLevelDir(List<UsageSnapshotEntity> usageByTopLevelDir) {
        this.usageByTopLevelDir = usageByTopLevelDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageDailySnapshotEntity usageDailySnapshotEntity = (UsageDailySnapshotEntity)o;
        return Objects.equals(this.id, usageDailySnapshotEntity.id) && Objects.equals(this.date, usageDailySnapshotEntity.date) && Objects.equals(this.currentStorage, usageDailySnapshotEntity.currentStorage) && Objects.equals(this.usageByTopLevelDir, usageDailySnapshotEntity.usageByTopLevelDir);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.date, this.currentStorage, this.usageByTopLevelDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageDailySnapshotEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    currentStorage: ").append(this.toIndentedString(this.currentStorage)).append("\n");
        sb.append("    usageByTopLevelDir: ").append(this.toIndentedString(this.usageByTopLevelDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

