/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Sso Strategies")
public class SsoStrategyEntity {
    @JsonProperty(value="protocol")
    private ProtocolEnum protocol = null;
    @JsonProperty(value="provider")
    private ProviderEnum provider = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="logo_url")
    private String logoUrl = null;
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="saml_provider_cert_fingerprint")
    private String samlProviderCertFingerprint = null;
    @JsonProperty(value="saml_provider_issuer_url")
    private String samlProviderIssuerUrl = null;
    @JsonProperty(value="saml_provider_metadata_content")
    private String samlProviderMetadataContent = null;
    @JsonProperty(value="saml_provider_metadata_url")
    private String samlProviderMetadataUrl = null;
    @JsonProperty(value="saml_provider_slo_target_url")
    private String samlProviderSloTargetUrl = null;
    @JsonProperty(value="saml_provider_sso_target_url")
    private String samlProviderSsoTargetUrl = null;
    @JsonProperty(value="scim_authentication_method")
    private ScimAuthenticationMethodEnum scimAuthenticationMethod = null;
    @JsonProperty(value="scim_username")
    private String scimUsername = null;
    @JsonProperty(value="scim_oauth_access_token")
    private String scimOauthAccessToken = null;
    @JsonProperty(value="scim_oauth_access_token_expires_at")
    private String scimOauthAccessTokenExpiresAt = null;
    @JsonProperty(value="subdomain")
    private String subdomain = null;
    @JsonProperty(value="provision_users")
    private Boolean provisionUsers = null;
    @JsonProperty(value="provision_groups")
    private Boolean provisionGroups = null;
    @JsonProperty(value="deprovision_users")
    private Boolean deprovisionUsers = null;
    @JsonProperty(value="deprovision_groups")
    private Boolean deprovisionGroups = null;
    @JsonProperty(value="deprovision_behavior")
    private DeprovisionBehaviorEnum deprovisionBehavior = null;
    @JsonProperty(value="provision_group_default")
    private String provisionGroupDefault = null;
    @JsonProperty(value="provision_group_exclusion")
    private String provisionGroupExclusion = null;
    @JsonProperty(value="provision_group_inclusion")
    private String provisionGroupInclusion = null;
    @JsonProperty(value="provision_group_required")
    private String provisionGroupRequired = null;
    @JsonProperty(value="provision_email_signup_groups")
    private String provisionEmailSignupGroups = null;
    @JsonProperty(value="provision_site_admin_groups")
    private String provisionSiteAdminGroups = null;
    @JsonProperty(value="provision_attachments_permission")
    private Boolean provisionAttachmentsPermission = null;
    @JsonProperty(value="provision_dav_permission")
    private Boolean provisionDavPermission = null;
    @JsonProperty(value="provision_ftp_permission")
    private Boolean provisionFtpPermission = null;
    @JsonProperty(value="provision_sftp_permission")
    private Boolean provisionSftpPermission = null;
    @JsonProperty(value="provision_time_zone")
    private String provisionTimeZone = null;
    @JsonProperty(value="provision_company")
    private String provisionCompany = null;
    @JsonProperty(value="ldap_base_dn")
    private String ldapBaseDn = null;
    @JsonProperty(value="ldap_domain")
    private String ldapDomain = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="ldap_host")
    private String ldapHost = null;
    @JsonProperty(value="ldap_host_2")
    private String ldapHost2 = null;
    @JsonProperty(value="ldap_host_3")
    private String ldapHost3 = null;
    @JsonProperty(value="ldap_port")
    private Integer ldapPort = null;
    @JsonProperty(value="ldap_secure")
    private Boolean ldapSecure = null;
    @JsonProperty(value="ldap_username")
    private String ldapUsername = null;
    @JsonProperty(value="ldap_username_field")
    private LdapUsernameFieldEnum ldapUsernameField = null;

    public SsoStrategyEntity protocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Schema(example="oauth2", description="SSO Protocol")
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public SsoStrategyEntity provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Schema(example="okta", description="Provider name")
    public ProviderEnum getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public SsoStrategyEntity label(String label) {
        this.label = label;
        return this;
    }

    @Schema(example="My Corporate SSO Provider", description="Custom label for the SSO provider on the login page.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public SsoStrategyEntity logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Schema(example="https://mysite.files.com/.../logo.png", description="URL holding a custom logo for the SSO provider on the login page.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public SsoStrategyEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public SsoStrategyEntity samlProviderCertFingerprint(String samlProviderCertFingerprint) {
        this.samlProviderCertFingerprint = samlProviderCertFingerprint;
        return this;
    }

    @Schema(description="Identity provider sha256 cert fingerprint if saml_provider_metadata_url is not available.")
    public String getSamlProviderCertFingerprint() {
        return this.samlProviderCertFingerprint;
    }

    public void setSamlProviderCertFingerprint(String samlProviderCertFingerprint) {
        this.samlProviderCertFingerprint = samlProviderCertFingerprint;
    }

    public SsoStrategyEntity samlProviderIssuerUrl(String samlProviderIssuerUrl) {
        this.samlProviderIssuerUrl = samlProviderIssuerUrl;
        return this;
    }

    @Schema(description="Identity provider issuer url")
    public String getSamlProviderIssuerUrl() {
        return this.samlProviderIssuerUrl;
    }

    public void setSamlProviderIssuerUrl(String samlProviderIssuerUrl) {
        this.samlProviderIssuerUrl = samlProviderIssuerUrl;
    }

    public SsoStrategyEntity samlProviderMetadataContent(String samlProviderMetadataContent) {
        this.samlProviderMetadataContent = samlProviderMetadataContent;
        return this;
    }

    @Schema(description="Custom identity provider metadata")
    public String getSamlProviderMetadataContent() {
        return this.samlProviderMetadataContent;
    }

    public void setSamlProviderMetadataContent(String samlProviderMetadataContent) {
        this.samlProviderMetadataContent = samlProviderMetadataContent;
    }

    public SsoStrategyEntity samlProviderMetadataUrl(String samlProviderMetadataUrl) {
        this.samlProviderMetadataUrl = samlProviderMetadataUrl;
        return this;
    }

    @Schema(description="Metadata URL for the SAML identity provider")
    public String getSamlProviderMetadataUrl() {
        return this.samlProviderMetadataUrl;
    }

    public void setSamlProviderMetadataUrl(String samlProviderMetadataUrl) {
        this.samlProviderMetadataUrl = samlProviderMetadataUrl;
    }

    public SsoStrategyEntity samlProviderSloTargetUrl(String samlProviderSloTargetUrl) {
        this.samlProviderSloTargetUrl = samlProviderSloTargetUrl;
        return this;
    }

    @Schema(description="Identity provider SLO endpoint")
    public String getSamlProviderSloTargetUrl() {
        return this.samlProviderSloTargetUrl;
    }

    public void setSamlProviderSloTargetUrl(String samlProviderSloTargetUrl) {
        this.samlProviderSloTargetUrl = samlProviderSloTargetUrl;
    }

    public SsoStrategyEntity samlProviderSsoTargetUrl(String samlProviderSsoTargetUrl) {
        this.samlProviderSsoTargetUrl = samlProviderSsoTargetUrl;
        return this;
    }

    @Schema(description="Identity provider SSO endpoint if saml_provider_metadata_url is not available.")
    public String getSamlProviderSsoTargetUrl() {
        return this.samlProviderSsoTargetUrl;
    }

    public void setSamlProviderSsoTargetUrl(String samlProviderSsoTargetUrl) {
        this.samlProviderSsoTargetUrl = samlProviderSsoTargetUrl;
    }

    public SsoStrategyEntity scimAuthenticationMethod(ScimAuthenticationMethodEnum scimAuthenticationMethod) {
        this.scimAuthenticationMethod = scimAuthenticationMethod;
        return this;
    }

    @Schema(description="SCIM authentication type.")
    public ScimAuthenticationMethodEnum getScimAuthenticationMethod() {
        return this.scimAuthenticationMethod;
    }

    public void setScimAuthenticationMethod(ScimAuthenticationMethodEnum scimAuthenticationMethod) {
        this.scimAuthenticationMethod = scimAuthenticationMethod;
    }

    public SsoStrategyEntity scimUsername(String scimUsername) {
        this.scimUsername = scimUsername;
        return this;
    }

    @Schema(description="SCIM username.")
    public String getScimUsername() {
        return this.scimUsername;
    }

    public void setScimUsername(String scimUsername) {
        this.scimUsername = scimUsername;
    }

    public SsoStrategyEntity scimOauthAccessToken(String scimOauthAccessToken) {
        this.scimOauthAccessToken = scimOauthAccessToken;
        return this;
    }

    @Schema(description="SCIM OAuth Access Token.")
    public String getScimOauthAccessToken() {
        return this.scimOauthAccessToken;
    }

    public void setScimOauthAccessToken(String scimOauthAccessToken) {
        this.scimOauthAccessToken = scimOauthAccessToken;
    }

    public SsoStrategyEntity scimOauthAccessTokenExpiresAt(String scimOauthAccessTokenExpiresAt) {
        this.scimOauthAccessTokenExpiresAt = scimOauthAccessTokenExpiresAt;
        return this;
    }

    @Schema(description="SCIM OAuth Access Token Expiration Time.")
    public String getScimOauthAccessTokenExpiresAt() {
        return this.scimOauthAccessTokenExpiresAt;
    }

    public void setScimOauthAccessTokenExpiresAt(String scimOauthAccessTokenExpiresAt) {
        this.scimOauthAccessTokenExpiresAt = scimOauthAccessTokenExpiresAt;
    }

    public SsoStrategyEntity subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Schema(example="my-site", description="Subdomain")
    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public SsoStrategyEntity provisionUsers(Boolean provisionUsers) {
        this.provisionUsers = provisionUsers;
        return this;
    }

    @Schema(description="Auto-provision users?")
    public Boolean isProvisionUsers() {
        return this.provisionUsers;
    }

    public void setProvisionUsers(Boolean provisionUsers) {
        this.provisionUsers = provisionUsers;
    }

    public SsoStrategyEntity provisionGroups(Boolean provisionGroups) {
        this.provisionGroups = provisionGroups;
        return this;
    }

    @Schema(description="Auto-provision group membership based on group memberships on the SSO side?")
    public Boolean isProvisionGroups() {
        return this.provisionGroups;
    }

    public void setProvisionGroups(Boolean provisionGroups) {
        this.provisionGroups = provisionGroups;
    }

    public SsoStrategyEntity deprovisionUsers(Boolean deprovisionUsers) {
        this.deprovisionUsers = deprovisionUsers;
        return this;
    }

    @Schema(description="Auto-deprovision users?")
    public Boolean isDeprovisionUsers() {
        return this.deprovisionUsers;
    }

    public void setDeprovisionUsers(Boolean deprovisionUsers) {
        this.deprovisionUsers = deprovisionUsers;
    }

    public SsoStrategyEntity deprovisionGroups(Boolean deprovisionGroups) {
        this.deprovisionGroups = deprovisionGroups;
        return this;
    }

    @Schema(description="Auto-deprovision group membership based on group memberships on the SSO side?")
    public Boolean isDeprovisionGroups() {
        return this.deprovisionGroups;
    }

    public void setDeprovisionGroups(Boolean deprovisionGroups) {
        this.deprovisionGroups = deprovisionGroups;
    }

    public SsoStrategyEntity deprovisionBehavior(DeprovisionBehaviorEnum deprovisionBehavior) {
        this.deprovisionBehavior = deprovisionBehavior;
        return this;
    }

    @Schema(example="disable", description="Method used for deprovisioning users.")
    public DeprovisionBehaviorEnum getDeprovisionBehavior() {
        return this.deprovisionBehavior;
    }

    public void setDeprovisionBehavior(DeprovisionBehaviorEnum deprovisionBehavior) {
        this.deprovisionBehavior = deprovisionBehavior;
    }

    public SsoStrategyEntity provisionGroupDefault(String provisionGroupDefault) {
        this.provisionGroupDefault = provisionGroupDefault;
        return this;
    }

    @Schema(example="Employees", description="Comma-separated list of group names for groups to automatically add all auto-provisioned users to.")
    public String getProvisionGroupDefault() {
        return this.provisionGroupDefault;
    }

    public void setProvisionGroupDefault(String provisionGroupDefault) {
        this.provisionGroupDefault = provisionGroupDefault;
    }

    public SsoStrategyEntity provisionGroupExclusion(String provisionGroupExclusion) {
        this.provisionGroupExclusion = provisionGroupExclusion;
        return this;
    }

    @Schema(example="Employees", description="Comma-separated list of group names for groups (with optional wildcards) that will be excluded from auto-provisioning.")
    public String getProvisionGroupExclusion() {
        return this.provisionGroupExclusion;
    }

    public void setProvisionGroupExclusion(String provisionGroupExclusion) {
        this.provisionGroupExclusion = provisionGroupExclusion;
    }

    public SsoStrategyEntity provisionGroupInclusion(String provisionGroupInclusion) {
        this.provisionGroupInclusion = provisionGroupInclusion;
        return this;
    }

    @Schema(example="Employees", description="Comma-separated list of group names for groups (with optional wildcards) that will be auto-provisioned.")
    public String getProvisionGroupInclusion() {
        return this.provisionGroupInclusion;
    }

    public void setProvisionGroupInclusion(String provisionGroupInclusion) {
        this.provisionGroupInclusion = provisionGroupInclusion;
    }

    public SsoStrategyEntity provisionGroupRequired(String provisionGroupRequired) {
        this.provisionGroupRequired = provisionGroupRequired;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) to require membership for user provisioning.")
    public String getProvisionGroupRequired() {
        return this.provisionGroupRequired;
    }

    public void setProvisionGroupRequired(String provisionGroupRequired) {
        this.provisionGroupRequired = provisionGroupRequired;
    }

    public SsoStrategyEntity provisionEmailSignupGroups(String provisionEmailSignupGroups) {
        this.provisionEmailSignupGroups = provisionEmailSignupGroups;
        return this;
    }

    @Schema(example="Employees", description="Comma-separated list of group names whose members will be created with email_signup authentication.")
    public String getProvisionEmailSignupGroups() {
        return this.provisionEmailSignupGroups;
    }

    public void setProvisionEmailSignupGroups(String provisionEmailSignupGroups) {
        this.provisionEmailSignupGroups = provisionEmailSignupGroups;
    }

    public SsoStrategyEntity provisionSiteAdminGroups(String provisionSiteAdminGroups) {
        this.provisionSiteAdminGroups = provisionSiteAdminGroups;
        return this;
    }

    @Schema(example="Employees", description="Comma-separated list of group names whose members will be created as Site Admins.")
    public String getProvisionSiteAdminGroups() {
        return this.provisionSiteAdminGroups;
    }

    public void setProvisionSiteAdminGroups(String provisionSiteAdminGroups) {
        this.provisionSiteAdminGroups = provisionSiteAdminGroups;
    }

    public SsoStrategyEntity provisionAttachmentsPermission(Boolean provisionAttachmentsPermission) {
        this.provisionAttachmentsPermission = provisionAttachmentsPermission;
        return this;
    }

    @Schema(example="true", description="DEPRECATED: Auto-provisioned users get Sharing permission. Use a Group with the Bundle permission instead.")
    public Boolean isProvisionAttachmentsPermission() {
        return this.provisionAttachmentsPermission;
    }

    public void setProvisionAttachmentsPermission(Boolean provisionAttachmentsPermission) {
        this.provisionAttachmentsPermission = provisionAttachmentsPermission;
    }

    public SsoStrategyEntity provisionDavPermission(Boolean provisionDavPermission) {
        this.provisionDavPermission = provisionDavPermission;
        return this;
    }

    @Schema(example="true", description="Auto-provisioned users get WebDAV permission?")
    public Boolean isProvisionDavPermission() {
        return this.provisionDavPermission;
    }

    public void setProvisionDavPermission(Boolean provisionDavPermission) {
        this.provisionDavPermission = provisionDavPermission;
    }

    public SsoStrategyEntity provisionFtpPermission(Boolean provisionFtpPermission) {
        this.provisionFtpPermission = provisionFtpPermission;
        return this;
    }

    @Schema(example="true", description="Auto-provisioned users get FTP permission?")
    public Boolean isProvisionFtpPermission() {
        return this.provisionFtpPermission;
    }

    public void setProvisionFtpPermission(Boolean provisionFtpPermission) {
        this.provisionFtpPermission = provisionFtpPermission;
    }

    public SsoStrategyEntity provisionSftpPermission(Boolean provisionSftpPermission) {
        this.provisionSftpPermission = provisionSftpPermission;
        return this;
    }

    @Schema(example="true", description="Auto-provisioned users get SFTP permission?")
    public Boolean isProvisionSftpPermission() {
        return this.provisionSftpPermission;
    }

    public void setProvisionSftpPermission(Boolean provisionSftpPermission) {
        this.provisionSftpPermission = provisionSftpPermission;
    }

    public SsoStrategyEntity provisionTimeZone(String provisionTimeZone) {
        this.provisionTimeZone = provisionTimeZone;
        return this;
    }

    @Schema(example="Eastern Time (US & Canada)", description="Default time zone for auto provisioned users.")
    public String getProvisionTimeZone() {
        return this.provisionTimeZone;
    }

    public void setProvisionTimeZone(String provisionTimeZone) {
        this.provisionTimeZone = provisionTimeZone;
    }

    public SsoStrategyEntity provisionCompany(String provisionCompany) {
        this.provisionCompany = provisionCompany;
        return this;
    }

    @Schema(example="ACME Corp.", description="Default company for auto provisioned users.")
    public String getProvisionCompany() {
        return this.provisionCompany;
    }

    public void setProvisionCompany(String provisionCompany) {
        this.provisionCompany = provisionCompany;
    }

    public SsoStrategyEntity ldapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
        return this;
    }

    @Schema(description="Base DN for looking up users in LDAP server")
    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    public void setLdapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
    }

    public SsoStrategyEntity ldapDomain(String ldapDomain) {
        this.ldapDomain = ldapDomain;
        return this;
    }

    @Schema(example="mysite.com", description="Domain name that will be appended to LDAP usernames")
    public String getLdapDomain() {
        return this.ldapDomain;
    }

    public void setLdapDomain(String ldapDomain) {
        this.ldapDomain = ldapDomain;
    }

    public SsoStrategyEntity enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(example="true", description="Is strategy enabled?")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SsoStrategyEntity ldapHost(String ldapHost) {
        this.ldapHost = ldapHost;
        return this;
    }

    @Schema(example="ldap.site.com", description="LDAP host")
    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public SsoStrategyEntity ldapHost2(String ldapHost2) {
        this.ldapHost2 = ldapHost2;
        return this;
    }

    @Schema(example="ldap2.site.com", description="LDAP backup host")
    public String getLdapHost2() {
        return this.ldapHost2;
    }

    public void setLdapHost2(String ldapHost2) {
        this.ldapHost2 = ldapHost2;
    }

    public SsoStrategyEntity ldapHost3(String ldapHost3) {
        this.ldapHost3 = ldapHost3;
        return this;
    }

    @Schema(example="ldap3.site.com", description="LDAP backup host")
    public String getLdapHost3() {
        return this.ldapHost3;
    }

    public void setLdapHost3(String ldapHost3) {
        this.ldapHost3 = ldapHost3;
    }

    public SsoStrategyEntity ldapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
        return this;
    }

    @Schema(example="1", description="LDAP port")
    public Integer getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
    }

    public SsoStrategyEntity ldapSecure(Boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
        return this;
    }

    @Schema(example="true", description="Use secure LDAP?")
    public Boolean isLdapSecure() {
        return this.ldapSecure;
    }

    public void setLdapSecure(Boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
    }

    public SsoStrategyEntity ldapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
        return this;
    }

    @Schema(example="[ldap username]", description="Username for signing in to LDAP server.")
    public String getLdapUsername() {
        return this.ldapUsername;
    }

    public void setLdapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
    }

    public SsoStrategyEntity ldapUsernameField(LdapUsernameFieldEnum ldapUsernameField) {
        this.ldapUsernameField = ldapUsernameField;
        return this;
    }

    @Schema(example="sAMAccountName", description="LDAP username field")
    public LdapUsernameFieldEnum getLdapUsernameField() {
        return this.ldapUsernameField;
    }

    public void setLdapUsernameField(LdapUsernameFieldEnum ldapUsernameField) {
        this.ldapUsernameField = ldapUsernameField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsoStrategyEntity ssoStrategyEntity = (SsoStrategyEntity)o;
        return Objects.equals((Object)this.protocol, (Object)ssoStrategyEntity.protocol) && Objects.equals((Object)this.provider, (Object)ssoStrategyEntity.provider) && Objects.equals(this.label, ssoStrategyEntity.label) && Objects.equals(this.logoUrl, ssoStrategyEntity.logoUrl) && Objects.equals(this.id, ssoStrategyEntity.id) && Objects.equals(this.samlProviderCertFingerprint, ssoStrategyEntity.samlProviderCertFingerprint) && Objects.equals(this.samlProviderIssuerUrl, ssoStrategyEntity.samlProviderIssuerUrl) && Objects.equals(this.samlProviderMetadataContent, ssoStrategyEntity.samlProviderMetadataContent) && Objects.equals(this.samlProviderMetadataUrl, ssoStrategyEntity.samlProviderMetadataUrl) && Objects.equals(this.samlProviderSloTargetUrl, ssoStrategyEntity.samlProviderSloTargetUrl) && Objects.equals(this.samlProviderSsoTargetUrl, ssoStrategyEntity.samlProviderSsoTargetUrl) && Objects.equals((Object)this.scimAuthenticationMethod, (Object)ssoStrategyEntity.scimAuthenticationMethod) && Objects.equals(this.scimUsername, ssoStrategyEntity.scimUsername) && Objects.equals(this.scimOauthAccessToken, ssoStrategyEntity.scimOauthAccessToken) && Objects.equals(this.scimOauthAccessTokenExpiresAt, ssoStrategyEntity.scimOauthAccessTokenExpiresAt) && Objects.equals(this.subdomain, ssoStrategyEntity.subdomain) && Objects.equals(this.provisionUsers, ssoStrategyEntity.provisionUsers) && Objects.equals(this.provisionGroups, ssoStrategyEntity.provisionGroups) && Objects.equals(this.deprovisionUsers, ssoStrategyEntity.deprovisionUsers) && Objects.equals(this.deprovisionGroups, ssoStrategyEntity.deprovisionGroups) && Objects.equals((Object)this.deprovisionBehavior, (Object)ssoStrategyEntity.deprovisionBehavior) && Objects.equals(this.provisionGroupDefault, ssoStrategyEntity.provisionGroupDefault) && Objects.equals(this.provisionGroupExclusion, ssoStrategyEntity.provisionGroupExclusion) && Objects.equals(this.provisionGroupInclusion, ssoStrategyEntity.provisionGroupInclusion) && Objects.equals(this.provisionGroupRequired, ssoStrategyEntity.provisionGroupRequired) && Objects.equals(this.provisionEmailSignupGroups, ssoStrategyEntity.provisionEmailSignupGroups) && Objects.equals(this.provisionSiteAdminGroups, ssoStrategyEntity.provisionSiteAdminGroups) && Objects.equals(this.provisionAttachmentsPermission, ssoStrategyEntity.provisionAttachmentsPermission) && Objects.equals(this.provisionDavPermission, ssoStrategyEntity.provisionDavPermission) && Objects.equals(this.provisionFtpPermission, ssoStrategyEntity.provisionFtpPermission) && Objects.equals(this.provisionSftpPermission, ssoStrategyEntity.provisionSftpPermission) && Objects.equals(this.provisionTimeZone, ssoStrategyEntity.provisionTimeZone) && Objects.equals(this.provisionCompany, ssoStrategyEntity.provisionCompany) && Objects.equals(this.ldapBaseDn, ssoStrategyEntity.ldapBaseDn) && Objects.equals(this.ldapDomain, ssoStrategyEntity.ldapDomain) && Objects.equals(this.enabled, ssoStrategyEntity.enabled) && Objects.equals(this.ldapHost, ssoStrategyEntity.ldapHost) && Objects.equals(this.ldapHost2, ssoStrategyEntity.ldapHost2) && Objects.equals(this.ldapHost3, ssoStrategyEntity.ldapHost3) && Objects.equals(this.ldapPort, ssoStrategyEntity.ldapPort) && Objects.equals(this.ldapSecure, ssoStrategyEntity.ldapSecure) && Objects.equals(this.ldapUsername, ssoStrategyEntity.ldapUsername) && Objects.equals((Object)this.ldapUsernameField, (Object)ssoStrategyEntity.ldapUsernameField);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.protocol, this.provider, this.label, this.logoUrl, this.id, this.samlProviderCertFingerprint, this.samlProviderIssuerUrl, this.samlProviderMetadataContent, this.samlProviderMetadataUrl, this.samlProviderSloTargetUrl, this.samlProviderSsoTargetUrl, this.scimAuthenticationMethod, this.scimUsername, this.scimOauthAccessToken, this.scimOauthAccessTokenExpiresAt, this.subdomain, this.provisionUsers, this.provisionGroups, this.deprovisionUsers, this.deprovisionGroups, this.deprovisionBehavior, this.provisionGroupDefault, this.provisionGroupExclusion, this.provisionGroupInclusion, this.provisionGroupRequired, this.provisionEmailSignupGroups, this.provisionSiteAdminGroups, this.provisionAttachmentsPermission, this.provisionDavPermission, this.provisionFtpPermission, this.provisionSftpPermission, this.provisionTimeZone, this.provisionCompany, this.ldapBaseDn, this.ldapDomain, this.enabled, this.ldapHost, this.ldapHost2, this.ldapHost3, this.ldapPort, this.ldapSecure, this.ldapUsername, this.ldapUsernameField});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsoStrategyEntity {\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    samlProviderCertFingerprint: ").append(this.toIndentedString(this.samlProviderCertFingerprint)).append("\n");
        sb.append("    samlProviderIssuerUrl: ").append(this.toIndentedString(this.samlProviderIssuerUrl)).append("\n");
        sb.append("    samlProviderMetadataContent: ").append(this.toIndentedString(this.samlProviderMetadataContent)).append("\n");
        sb.append("    samlProviderMetadataUrl: ").append(this.toIndentedString(this.samlProviderMetadataUrl)).append("\n");
        sb.append("    samlProviderSloTargetUrl: ").append(this.toIndentedString(this.samlProviderSloTargetUrl)).append("\n");
        sb.append("    samlProviderSsoTargetUrl: ").append(this.toIndentedString(this.samlProviderSsoTargetUrl)).append("\n");
        sb.append("    scimAuthenticationMethod: ").append(this.toIndentedString((Object)this.scimAuthenticationMethod)).append("\n");
        sb.append("    scimUsername: ").append(this.toIndentedString(this.scimUsername)).append("\n");
        sb.append("    scimOauthAccessToken: ").append(this.toIndentedString(this.scimOauthAccessToken)).append("\n");
        sb.append("    scimOauthAccessTokenExpiresAt: ").append(this.toIndentedString(this.scimOauthAccessTokenExpiresAt)).append("\n");
        sb.append("    subdomain: ").append(this.toIndentedString(this.subdomain)).append("\n");
        sb.append("    provisionUsers: ").append(this.toIndentedString(this.provisionUsers)).append("\n");
        sb.append("    provisionGroups: ").append(this.toIndentedString(this.provisionGroups)).append("\n");
        sb.append("    deprovisionUsers: ").append(this.toIndentedString(this.deprovisionUsers)).append("\n");
        sb.append("    deprovisionGroups: ").append(this.toIndentedString(this.deprovisionGroups)).append("\n");
        sb.append("    deprovisionBehavior: ").append(this.toIndentedString((Object)this.deprovisionBehavior)).append("\n");
        sb.append("    provisionGroupDefault: ").append(this.toIndentedString(this.provisionGroupDefault)).append("\n");
        sb.append("    provisionGroupExclusion: ").append(this.toIndentedString(this.provisionGroupExclusion)).append("\n");
        sb.append("    provisionGroupInclusion: ").append(this.toIndentedString(this.provisionGroupInclusion)).append("\n");
        sb.append("    provisionGroupRequired: ").append(this.toIndentedString(this.provisionGroupRequired)).append("\n");
        sb.append("    provisionEmailSignupGroups: ").append(this.toIndentedString(this.provisionEmailSignupGroups)).append("\n");
        sb.append("    provisionSiteAdminGroups: ").append(this.toIndentedString(this.provisionSiteAdminGroups)).append("\n");
        sb.append("    provisionAttachmentsPermission: ").append(this.toIndentedString(this.provisionAttachmentsPermission)).append("\n");
        sb.append("    provisionDavPermission: ").append(this.toIndentedString(this.provisionDavPermission)).append("\n");
        sb.append("    provisionFtpPermission: ").append(this.toIndentedString(this.provisionFtpPermission)).append("\n");
        sb.append("    provisionSftpPermission: ").append(this.toIndentedString(this.provisionSftpPermission)).append("\n");
        sb.append("    provisionTimeZone: ").append(this.toIndentedString(this.provisionTimeZone)).append("\n");
        sb.append("    provisionCompany: ").append(this.toIndentedString(this.provisionCompany)).append("\n");
        sb.append("    ldapBaseDn: ").append(this.toIndentedString(this.ldapBaseDn)).append("\n");
        sb.append("    ldapDomain: ").append(this.toIndentedString(this.ldapDomain)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    ldapHost: ").append(this.toIndentedString(this.ldapHost)).append("\n");
        sb.append("    ldapHost2: ").append(this.toIndentedString(this.ldapHost2)).append("\n");
        sb.append("    ldapHost3: ").append(this.toIndentedString(this.ldapHost3)).append("\n");
        sb.append("    ldapPort: ").append(this.toIndentedString(this.ldapPort)).append("\n");
        sb.append("    ldapSecure: ").append(this.toIndentedString(this.ldapSecure)).append("\n");
        sb.append("    ldapUsername: ").append(this.toIndentedString(this.ldapUsername)).append("\n");
        sb.append("    ldapUsernameField: ").append(this.toIndentedString((Object)this.ldapUsernameField)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProtocolEnum {
        OAUTH2("oauth2"),
        _UNUSED_OPENID2("_unused_openid2"),
        SAML("saml"),
        ACTIVE_DIRECTORY("active_directory"),
        OPEN_LDAP("open_ldap"),
        SCIM("scim");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String text) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ProviderEnum {
        GOOGLE("google"),
        AUTH0("auth0"),
        OKTA("okta"),
        ATLASSIAN("atlassian"),
        AZURE("azure"),
        BOX("box"),
        DROPBOX("dropbox"),
        SLACK("slack"),
        _UNUSED_UBUNTU("_unused_ubuntu"),
        ONELOGIN("onelogin"),
        SAML("saml"),
        IDAPTIVE("idaptive"),
        LDAP("ldap"),
        SCIM("scim");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String text) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ScimAuthenticationMethodEnum {
        NONE("none"),
        BASIC("basic"),
        TOKEN("token");

        private String value;

        private ScimAuthenticationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScimAuthenticationMethodEnum fromValue(String text) {
            for (ScimAuthenticationMethodEnum b : ScimAuthenticationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum DeprovisionBehaviorEnum {
        DISABLE("disable"),
        DELETE("delete");

        private String value;

        private DeprovisionBehaviorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeprovisionBehaviorEnum fromValue(String text) {
            for (DeprovisionBehaviorEnum b : DeprovisionBehaviorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum LdapUsernameFieldEnum {
        SAMACCOUNTNAME("sAMAccountName"),
        USERPRINCIPALNAME("userPrincipalName");

        private String value;

        private LdapUsernameFieldEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LdapUsernameFieldEnum fromValue(String text) {
            for (LdapUsernameFieldEnum b : LdapUsernameFieldEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

