/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import ch.cyberduck.core.brick.io.swagger.client.model.ImageEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.SessionEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.UserEntity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Show site settings")
public class SiteEntity {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="allowed_2fa_method_sms")
    private Boolean allowed2faMethodSms = null;
    @JsonProperty(value="allowed_2fa_method_totp")
    private Boolean allowed2faMethodTotp = null;
    @JsonProperty(value="allowed_2fa_method_u2f")
    private Boolean allowed2faMethodU2f = null;
    @JsonProperty(value="allowed_2fa_method_yubi")
    private Boolean allowed2faMethodYubi = null;
    @JsonProperty(value="admin_user_id")
    private Integer adminUserId = null;
    @JsonProperty(value="allow_bundle_names")
    private Boolean allowBundleNames = null;
    @JsonProperty(value="allowed_countries")
    private String allowedCountries = null;
    @JsonProperty(value="allowed_ips")
    private String allowedIps = null;
    @JsonProperty(value="ask_about_overwrites")
    private Boolean askAboutOverwrites = null;
    @JsonProperty(value="bundle_expiration")
    private Integer bundleExpiration = null;
    @JsonProperty(value="bundle_password_required")
    private Boolean bundlePasswordRequired = null;
    @JsonProperty(value="bundle_require_share_recipient")
    private Boolean bundleRequireShareRecipient = null;
    @JsonProperty(value="color2_left")
    private String color2Left = null;
    @JsonProperty(value="color2_link")
    private String color2Link = null;
    @JsonProperty(value="color2_text")
    private String color2Text = null;
    @JsonProperty(value="color2_top")
    private String color2Top = null;
    @JsonProperty(value="color2_top_text")
    private String color2TopText = null;
    @JsonProperty(value="contact_name")
    private String contactName = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="custom_namespace")
    private Boolean customNamespace = null;
    @JsonProperty(value="days_to_retain_backups")
    private Integer daysToRetainBackups = null;
    @JsonProperty(value="default_time_zone")
    private String defaultTimeZone = null;
    @JsonProperty(value="desktop_app")
    private Boolean desktopApp = null;
    @JsonProperty(value="desktop_app_session_ip_pinning")
    private Boolean desktopAppSessionIpPinning = null;
    @JsonProperty(value="desktop_app_session_lifetime")
    private Integer desktopAppSessionLifetime = null;
    @JsonProperty(value="disallowed_countries")
    private String disallowedCountries = null;
    @JsonProperty(value="disable_notifications")
    private Boolean disableNotifications = null;
    @JsonProperty(value="disable_password_reset")
    private Boolean disablePasswordReset = null;
    @JsonProperty(value="domain")
    private String domain = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="reply_to_email")
    private String replyToEmail = null;
    @JsonProperty(value="non_sso_groups_allowed")
    private Boolean nonSsoGroupsAllowed = null;
    @JsonProperty(value="non_sso_users_allowed")
    private Boolean nonSsoUsersAllowed = null;
    @JsonProperty(value="folder_permissions_groups_only")
    private Boolean folderPermissionsGroupsOnly = null;
    @JsonProperty(value="hipaa")
    private Boolean hipaa = null;
    @JsonProperty(value="icon128")
    private ImageEntity icon128 = null;
    @JsonProperty(value="icon16")
    private ImageEntity icon16 = null;
    @JsonProperty(value="icon32")
    private ImageEntity icon32 = null;
    @JsonProperty(value="icon48")
    private ImageEntity icon48 = null;
    @JsonProperty(value="immutable_files_set_at")
    private DateTime immutableFilesSetAt = null;
    @JsonProperty(value="include_password_in_welcome_email")
    private Boolean includePasswordInWelcomeEmail = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="ldap_base_dn")
    private String ldapBaseDn = null;
    @JsonProperty(value="ldap_domain")
    private String ldapDomain = null;
    @JsonProperty(value="ldap_enabled")
    private Boolean ldapEnabled = null;
    @JsonProperty(value="ldap_group_action")
    private String ldapGroupAction = null;
    @JsonProperty(value="ldap_group_exclusion")
    private String ldapGroupExclusion = null;
    @JsonProperty(value="ldap_group_inclusion")
    private String ldapGroupInclusion = null;
    @JsonProperty(value="ldap_host")
    private String ldapHost = null;
    @JsonProperty(value="ldap_host_2")
    private String ldapHost2 = null;
    @JsonProperty(value="ldap_host_3")
    private String ldapHost3 = null;
    @JsonProperty(value="ldap_port")
    private Integer ldapPort = null;
    @JsonProperty(value="ldap_secure")
    private Boolean ldapSecure = null;
    @JsonProperty(value="ldap_type")
    private String ldapType = null;
    @JsonProperty(value="ldap_user_action")
    private String ldapUserAction = null;
    @JsonProperty(value="ldap_user_include_groups")
    private String ldapUserIncludeGroups = null;
    @JsonProperty(value="ldap_username")
    private String ldapUsername = null;
    @JsonProperty(value="ldap_username_field")
    private String ldapUsernameField = null;
    @JsonProperty(value="login_help_text")
    private String loginHelpText = null;
    @JsonProperty(value="logo")
    private ImageEntity logo = null;
    @JsonProperty(value="max_prior_passwords")
    private Integer maxPriorPasswords = null;
    @JsonProperty(value="next_billing_amount")
    private Double nextBillingAmount = null;
    @JsonProperty(value="next_billing_date")
    private String nextBillingDate = null;
    @JsonProperty(value="office_integration_available")
    private Boolean officeIntegrationAvailable = null;
    @JsonProperty(value="oncehub_link")
    private String oncehubLink = null;
    @JsonProperty(value="opt_out_global")
    private Boolean optOutGlobal = null;
    @JsonProperty(value="overage_notified_at")
    private DateTime overageNotifiedAt = null;
    @JsonProperty(value="overage_notify")
    private Boolean overageNotify = null;
    @JsonProperty(value="overdue")
    private Boolean overdue = null;
    @JsonProperty(value="password_min_length")
    private Integer passwordMinLength = null;
    @JsonProperty(value="password_require_letter")
    private Boolean passwordRequireLetter = null;
    @JsonProperty(value="password_require_mixed")
    private Boolean passwordRequireMixed = null;
    @JsonProperty(value="password_require_number")
    private Boolean passwordRequireNumber = null;
    @JsonProperty(value="password_require_special")
    private Boolean passwordRequireSpecial = null;
    @JsonProperty(value="password_require_unbreached")
    private Boolean passwordRequireUnbreached = null;
    @JsonProperty(value="password_requirements_apply_to_bundles")
    private Boolean passwordRequirementsApplyToBundles = null;
    @JsonProperty(value="password_validity_days")
    private Integer passwordValidityDays = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="require_2fa")
    private Boolean require2fa = null;
    @JsonProperty(value="require_2fa_stop_time")
    private DateTime require2faStopTime = null;
    @JsonProperty(value="require_2fa_user_type")
    private Require2faUserTypeEnum require2faUserType = null;
    @JsonProperty(value="session")
    private SessionEntity session = null;
    @JsonProperty(value="session_pinned_by_ip")
    private Boolean sessionPinnedByIp = null;
    @JsonProperty(value="sftp_user_root_enabled")
    private Boolean sftpUserRootEnabled = null;
    @JsonProperty(value="sharing_enabled")
    private Boolean sharingEnabled = null;
    @JsonProperty(value="show_request_access_link")
    private Boolean showRequestAccessLink = null;
    @JsonProperty(value="site_footer")
    private String siteFooter = null;
    @JsonProperty(value="site_header")
    private String siteHeader = null;
    @JsonProperty(value="smtp_address")
    private String smtpAddress = null;
    @JsonProperty(value="smtp_authentication")
    private String smtpAuthentication = null;
    @JsonProperty(value="smtp_from")
    private String smtpFrom = null;
    @JsonProperty(value="smtp_port")
    private Integer smtpPort = null;
    @JsonProperty(value="smtp_username")
    private String smtpUsername = null;
    @JsonProperty(value="session_expiry")
    private Double sessionExpiry = null;
    @JsonProperty(value="ssl_required")
    private Boolean sslRequired = null;
    @JsonProperty(value="subdomain")
    private String subdomain = null;
    @JsonProperty(value="switch_to_plan_date")
    private DateTime switchToPlanDate = null;
    @JsonProperty(value="tls_disabled")
    private Boolean tlsDisabled = null;
    @JsonProperty(value="trial_days_left")
    private Integer trialDaysLeft = null;
    @JsonProperty(value="trial_until")
    private DateTime trialUntil = null;
    @JsonProperty(value="updated_at")
    private DateTime updatedAt = null;
    @JsonProperty(value="use_provided_modified_at")
    private Boolean useProvidedModifiedAt = null;
    @JsonProperty(value="user")
    private UserEntity user = null;
    @JsonProperty(value="user_lockout")
    private Boolean userLockout = null;
    @JsonProperty(value="user_lockout_lock_period")
    private Integer userLockoutLockPeriod = null;
    @JsonProperty(value="user_lockout_tries")
    private Integer userLockoutTries = null;
    @JsonProperty(value="user_lockout_within")
    private Integer userLockoutWithin = null;
    @JsonProperty(value="user_requests_enabled")
    private Boolean userRequestsEnabled = null;
    @JsonProperty(value="welcome_custom_text")
    private String welcomeCustomText = null;
    @JsonProperty(value="welcome_email_cc")
    private String welcomeEmailCc = null;
    @JsonProperty(value="welcome_email_enabled")
    private Boolean welcomeEmailEnabled = null;
    @JsonProperty(value="welcome_screen")
    private WelcomeScreenEnum welcomeScreen = null;
    @JsonProperty(value="windows_mode_ftp")
    private Boolean windowsModeFtp = null;
    @JsonProperty(value="disable_users_from_inactivity_period_days")
    private Integer disableUsersFromInactivityPeriodDays = null;

    public SiteEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="My Site", description="Site name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SiteEntity allowed2faMethodSms(Boolean allowed2faMethodSms) {
        this.allowed2faMethodSms = allowed2faMethodSms;
        return this;
    }

    @Schema(example="true", description="Is SMS two factor authentication allowed?")
    public Boolean isAllowed2faMethodSms() {
        return this.allowed2faMethodSms;
    }

    public void setAllowed2faMethodSms(Boolean allowed2faMethodSms) {
        this.allowed2faMethodSms = allowed2faMethodSms;
    }

    public SiteEntity allowed2faMethodTotp(Boolean allowed2faMethodTotp) {
        this.allowed2faMethodTotp = allowed2faMethodTotp;
        return this;
    }

    @Schema(example="true", description="Is TOTP two factor authentication allowed?")
    public Boolean isAllowed2faMethodTotp() {
        return this.allowed2faMethodTotp;
    }

    public void setAllowed2faMethodTotp(Boolean allowed2faMethodTotp) {
        this.allowed2faMethodTotp = allowed2faMethodTotp;
    }

    public SiteEntity allowed2faMethodU2f(Boolean allowed2faMethodU2f) {
        this.allowed2faMethodU2f = allowed2faMethodU2f;
        return this;
    }

    @Schema(example="true", description="Is U2F two factor authentication allowed?")
    public Boolean isAllowed2faMethodU2f() {
        return this.allowed2faMethodU2f;
    }

    public void setAllowed2faMethodU2f(Boolean allowed2faMethodU2f) {
        this.allowed2faMethodU2f = allowed2faMethodU2f;
    }

    public SiteEntity allowed2faMethodYubi(Boolean allowed2faMethodYubi) {
        this.allowed2faMethodYubi = allowed2faMethodYubi;
        return this;
    }

    @Schema(example="true", description="Is yubikey two factor authentication allowed?")
    public Boolean isAllowed2faMethodYubi() {
        return this.allowed2faMethodYubi;
    }

    public void setAllowed2faMethodYubi(Boolean allowed2faMethodYubi) {
        this.allowed2faMethodYubi = allowed2faMethodYubi;
    }

    public SiteEntity adminUserId(Integer adminUserId) {
        this.adminUserId = adminUserId;
        return this;
    }

    @Schema(example="1", description="User ID for the main site administrator")
    public Integer getAdminUserId() {
        return this.adminUserId;
    }

    public void setAdminUserId(Integer adminUserId) {
        this.adminUserId = adminUserId;
    }

    public SiteEntity allowBundleNames(Boolean allowBundleNames) {
        this.allowBundleNames = allowBundleNames;
        return this;
    }

    @Schema(example="true", description="Are manual Bundle names allowed?")
    public Boolean isAllowBundleNames() {
        return this.allowBundleNames;
    }

    public void setAllowBundleNames(Boolean allowBundleNames) {
        this.allowBundleNames = allowBundleNames;
    }

    public SiteEntity allowedCountries(String allowedCountries) {
        this.allowedCountries = allowedCountries;
        return this;
    }

    @Schema(example="US,DE", description="Comma seperated list of allowed Country codes")
    public String getAllowedCountries() {
        return this.allowedCountries;
    }

    public void setAllowedCountries(String allowedCountries) {
        this.allowedCountries = allowedCountries;
    }

    public SiteEntity allowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
        return this;
    }

    @Schema(description="List of allowed IP addresses")
    public String getAllowedIps() {
        return this.allowedIps;
    }

    public void setAllowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
    }

    public SiteEntity askAboutOverwrites(Boolean askAboutOverwrites) {
        this.askAboutOverwrites = askAboutOverwrites;
        return this;
    }

    @Schema(example="true", description="If false, rename conflicting files instead of asking for overwrite confirmation.  Only applies to web interface.")
    public Boolean isAskAboutOverwrites() {
        return this.askAboutOverwrites;
    }

    public void setAskAboutOverwrites(Boolean askAboutOverwrites) {
        this.askAboutOverwrites = askAboutOverwrites;
    }

    public SiteEntity bundleExpiration(Integer bundleExpiration) {
        this.bundleExpiration = bundleExpiration;
        return this;
    }

    @Schema(example="1", description="Site-wide Bundle expiration in days")
    public Integer getBundleExpiration() {
        return this.bundleExpiration;
    }

    public void setBundleExpiration(Integer bundleExpiration) {
        this.bundleExpiration = bundleExpiration;
    }

    public SiteEntity bundlePasswordRequired(Boolean bundlePasswordRequired) {
        this.bundlePasswordRequired = bundlePasswordRequired;
        return this;
    }

    @Schema(example="true", description="Do Bundles require password protection?")
    public Boolean isBundlePasswordRequired() {
        return this.bundlePasswordRequired;
    }

    public void setBundlePasswordRequired(Boolean bundlePasswordRequired) {
        this.bundlePasswordRequired = bundlePasswordRequired;
    }

    public SiteEntity bundleRequireShareRecipient(Boolean bundleRequireShareRecipient) {
        this.bundleRequireShareRecipient = bundleRequireShareRecipient;
        return this;
    }

    @Schema(example="true", description="Do Bundles require recipients for sharing?")
    public Boolean isBundleRequireShareRecipient() {
        return this.bundleRequireShareRecipient;
    }

    public void setBundleRequireShareRecipient(Boolean bundleRequireShareRecipient) {
        this.bundleRequireShareRecipient = bundleRequireShareRecipient;
    }

    public SiteEntity color2Left(String color2Left) {
        this.color2Left = color2Left;
        return this;
    }

    @Schema(example="#0066a7", description="Page link and button color")
    public String getColor2Left() {
        return this.color2Left;
    }

    public void setColor2Left(String color2Left) {
        this.color2Left = color2Left;
    }

    public SiteEntity color2Link(String color2Link) {
        this.color2Link = color2Link;
        return this;
    }

    @Schema(example="#d34f5d", description="Top bar link color")
    public String getColor2Link() {
        return this.color2Link;
    }

    public void setColor2Link(String color2Link) {
        this.color2Link = color2Link;
    }

    public SiteEntity color2Text(String color2Text) {
        this.color2Text = color2Text;
        return this;
    }

    @Schema(example="#0066a7", description="Page link and button color")
    public String getColor2Text() {
        return this.color2Text;
    }

    public void setColor2Text(String color2Text) {
        this.color2Text = color2Text;
    }

    public SiteEntity color2Top(String color2Top) {
        this.color2Top = color2Top;
        return this;
    }

    @Schema(example="#000000", description="Top bar background color")
    public String getColor2Top() {
        return this.color2Top;
    }

    public void setColor2Top(String color2Top) {
        this.color2Top = color2Top;
    }

    public SiteEntity color2TopText(String color2TopText) {
        this.color2TopText = color2TopText;
        return this;
    }

    @Schema(example="#ffffff", description="Top bar text color")
    public String getColor2TopText() {
        return this.color2TopText;
    }

    public void setColor2TopText(String color2TopText) {
        this.color2TopText = color2TopText;
    }

    public SiteEntity contactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    @Schema(example="John Doe", description="Site main contact name")
    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public SiteEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Time this site was created")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public SiteEntity currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Schema(example="USD", description="Preferred currency")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SiteEntity customNamespace(Boolean customNamespace) {
        this.customNamespace = customNamespace;
        return this;
    }

    @Schema(example="true", description="Is this site using a custom namespace for users?")
    public Boolean isCustomNamespace() {
        return this.customNamespace;
    }

    public void setCustomNamespace(Boolean customNamespace) {
        this.customNamespace = customNamespace;
    }

    public SiteEntity daysToRetainBackups(Integer daysToRetainBackups) {
        this.daysToRetainBackups = daysToRetainBackups;
        return this;
    }

    @Schema(example="30", description="Number of days to keep deleted files")
    public Integer getDaysToRetainBackups() {
        return this.daysToRetainBackups;
    }

    public void setDaysToRetainBackups(Integer daysToRetainBackups) {
        this.daysToRetainBackups = daysToRetainBackups;
    }

    public SiteEntity defaultTimeZone(String defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
        return this;
    }

    @Schema(example="Pacific Time (US & Canada)", description="Site default time zone")
    public String getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public void setDefaultTimeZone(String defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public SiteEntity desktopApp(Boolean desktopApp) {
        this.desktopApp = desktopApp;
        return this;
    }

    @Schema(example="true", description="Is the desktop app enabled?")
    public Boolean isDesktopApp() {
        return this.desktopApp;
    }

    public void setDesktopApp(Boolean desktopApp) {
        this.desktopApp = desktopApp;
    }

    public SiteEntity desktopAppSessionIpPinning(Boolean desktopAppSessionIpPinning) {
        this.desktopAppSessionIpPinning = desktopAppSessionIpPinning;
        return this;
    }

    @Schema(example="true", description="Is desktop app session IP pinning enabled?")
    public Boolean isDesktopAppSessionIpPinning() {
        return this.desktopAppSessionIpPinning;
    }

    public void setDesktopAppSessionIpPinning(Boolean desktopAppSessionIpPinning) {
        this.desktopAppSessionIpPinning = desktopAppSessionIpPinning;
    }

    public SiteEntity desktopAppSessionLifetime(Integer desktopAppSessionLifetime) {
        this.desktopAppSessionLifetime = desktopAppSessionLifetime;
        return this;
    }

    @Schema(example="1", description="Desktop app session lifetime (in hours)")
    public Integer getDesktopAppSessionLifetime() {
        return this.desktopAppSessionLifetime;
    }

    public void setDesktopAppSessionLifetime(Integer desktopAppSessionLifetime) {
        this.desktopAppSessionLifetime = desktopAppSessionLifetime;
    }

    public SiteEntity disallowedCountries(String disallowedCountries) {
        this.disallowedCountries = disallowedCountries;
        return this;
    }

    @Schema(example="US,DE", description="Comma seperated list of disallowed Country codes")
    public String getDisallowedCountries() {
        return this.disallowedCountries;
    }

    public void setDisallowedCountries(String disallowedCountries) {
        this.disallowedCountries = disallowedCountries;
    }

    public SiteEntity disableNotifications(Boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
        return this;
    }

    @Schema(example="true", description="Are notifications disabled?")
    public Boolean isDisableNotifications() {
        return this.disableNotifications;
    }

    public void setDisableNotifications(Boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
    }

    public SiteEntity disablePasswordReset(Boolean disablePasswordReset) {
        this.disablePasswordReset = disablePasswordReset;
        return this;
    }

    @Schema(example="true", description="Is password reset disabled?")
    public Boolean isDisablePasswordReset() {
        return this.disablePasswordReset;
    }

    public void setDisablePasswordReset(Boolean disablePasswordReset) {
        this.disablePasswordReset = disablePasswordReset;
    }

    public SiteEntity domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(example="my-custom-domain.com", description="Custom domain")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public SiteEntity email(String email) {
        this.email = email;
        return this;
    }

    @Schema(example="john.doe@files.com", description="Main email for this site")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public SiteEntity replyToEmail(String replyToEmail) {
        this.replyToEmail = replyToEmail;
        return this;
    }

    @Schema(example="jane.doe@files.com", description="Reply-to email for this site")
    public String getReplyToEmail() {
        return this.replyToEmail;
    }

    public void setReplyToEmail(String replyToEmail) {
        this.replyToEmail = replyToEmail;
    }

    public SiteEntity nonSsoGroupsAllowed(Boolean nonSsoGroupsAllowed) {
        this.nonSsoGroupsAllowed = nonSsoGroupsAllowed;
        return this;
    }

    @Schema(example="true", description="If true, groups can be manually created / modified / deleted by Site Admins. Otherwise, groups can only be managed via your SSO provider.")
    public Boolean isNonSsoGroupsAllowed() {
        return this.nonSsoGroupsAllowed;
    }

    public void setNonSsoGroupsAllowed(Boolean nonSsoGroupsAllowed) {
        this.nonSsoGroupsAllowed = nonSsoGroupsAllowed;
    }

    public SiteEntity nonSsoUsersAllowed(Boolean nonSsoUsersAllowed) {
        this.nonSsoUsersAllowed = nonSsoUsersAllowed;
        return this;
    }

    @Schema(example="true", description="If true, users can be manually created / modified / deleted by Site Admins. Otherwise, users can only be managed via your SSO provider.")
    public Boolean isNonSsoUsersAllowed() {
        return this.nonSsoUsersAllowed;
    }

    public void setNonSsoUsersAllowed(Boolean nonSsoUsersAllowed) {
        this.nonSsoUsersAllowed = nonSsoUsersAllowed;
    }

    public SiteEntity folderPermissionsGroupsOnly(Boolean folderPermissionsGroupsOnly) {
        this.folderPermissionsGroupsOnly = folderPermissionsGroupsOnly;
        return this;
    }

    @Schema(example="true", description="If true, permissions for this site must be bound to a group (not a user). Otherwise, permissions must be bound to a user.")
    public Boolean isFolderPermissionsGroupsOnly() {
        return this.folderPermissionsGroupsOnly;
    }

    public void setFolderPermissionsGroupsOnly(Boolean folderPermissionsGroupsOnly) {
        this.folderPermissionsGroupsOnly = folderPermissionsGroupsOnly;
    }

    public SiteEntity hipaa(Boolean hipaa) {
        this.hipaa = hipaa;
        return this;
    }

    @Schema(example="true", description="Is there a signed HIPAA BAA between Files.com and this site?")
    public Boolean isHipaa() {
        return this.hipaa;
    }

    public void setHipaa(Boolean hipaa) {
        this.hipaa = hipaa;
    }

    public SiteEntity icon128(ImageEntity icon128) {
        this.icon128 = icon128;
        return this;
    }

    @Schema(description="")
    public ImageEntity getIcon128() {
        return this.icon128;
    }

    public void setIcon128(ImageEntity icon128) {
        this.icon128 = icon128;
    }

    public SiteEntity icon16(ImageEntity icon16) {
        this.icon16 = icon16;
        return this;
    }

    @Schema(description="")
    public ImageEntity getIcon16() {
        return this.icon16;
    }

    public void setIcon16(ImageEntity icon16) {
        this.icon16 = icon16;
    }

    public SiteEntity icon32(ImageEntity icon32) {
        this.icon32 = icon32;
        return this;
    }

    @Schema(description="")
    public ImageEntity getIcon32() {
        return this.icon32;
    }

    public void setIcon32(ImageEntity icon32) {
        this.icon32 = icon32;
    }

    public SiteEntity icon48(ImageEntity icon48) {
        this.icon48 = icon48;
        return this;
    }

    @Schema(description="")
    public ImageEntity getIcon48() {
        return this.icon48;
    }

    public void setIcon48(ImageEntity icon48) {
        this.icon48 = icon48;
    }

    public SiteEntity immutableFilesSetAt(DateTime immutableFilesSetAt) {
        this.immutableFilesSetAt = immutableFilesSetAt;
        return this;
    }

    @Schema(description="Can files be modified?")
    public DateTime getImmutableFilesSetAt() {
        return this.immutableFilesSetAt;
    }

    public void setImmutableFilesSetAt(DateTime immutableFilesSetAt) {
        this.immutableFilesSetAt = immutableFilesSetAt;
    }

    public SiteEntity includePasswordInWelcomeEmail(Boolean includePasswordInWelcomeEmail) {
        this.includePasswordInWelcomeEmail = includePasswordInWelcomeEmail;
        return this;
    }

    @Schema(example="true", description="Include password in emails to new users?")
    public Boolean isIncludePasswordInWelcomeEmail() {
        return this.includePasswordInWelcomeEmail;
    }

    public void setIncludePasswordInWelcomeEmail(Boolean includePasswordInWelcomeEmail) {
        this.includePasswordInWelcomeEmail = includePasswordInWelcomeEmail;
    }

    public SiteEntity language(String language) {
        this.language = language;
        return this;
    }

    @Schema(example="en", description="Site default language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public SiteEntity ldapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
        return this;
    }

    @Schema(description="Base DN for looking up users in LDAP server")
    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    public void setLdapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
    }

    public SiteEntity ldapDomain(String ldapDomain) {
        this.ldapDomain = ldapDomain;
        return this;
    }

    @Schema(example="mysite.com", description="Domain name that will be appended to usernames")
    public String getLdapDomain() {
        return this.ldapDomain;
    }

    public void setLdapDomain(String ldapDomain) {
        this.ldapDomain = ldapDomain;
    }

    public SiteEntity ldapEnabled(Boolean ldapEnabled) {
        this.ldapEnabled = ldapEnabled;
        return this;
    }

    @Schema(example="true", description="Main LDAP setting: is LDAP enabled?")
    public Boolean isLdapEnabled() {
        return this.ldapEnabled;
    }

    public void setLdapEnabled(Boolean ldapEnabled) {
        this.ldapEnabled = ldapEnabled;
    }

    public SiteEntity ldapGroupAction(String ldapGroupAction) {
        this.ldapGroupAction = ldapGroupAction;
        return this;
    }

    @Schema(example="disabled", description="Should we sync groups from LDAP server?")
    public String getLdapGroupAction() {
        return this.ldapGroupAction;
    }

    public void setLdapGroupAction(String ldapGroupAction) {
        this.ldapGroupAction = ldapGroupAction;
    }

    public SiteEntity ldapGroupExclusion(String ldapGroupExclusion) {
        this.ldapGroupExclusion = ldapGroupExclusion;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) to exclude when syncing.")
    public String getLdapGroupExclusion() {
        return this.ldapGroupExclusion;
    }

    public void setLdapGroupExclusion(String ldapGroupExclusion) {
        this.ldapGroupExclusion = ldapGroupExclusion;
    }

    public SiteEntity ldapGroupInclusion(String ldapGroupInclusion) {
        this.ldapGroupInclusion = ldapGroupInclusion;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) to include when syncing.")
    public String getLdapGroupInclusion() {
        return this.ldapGroupInclusion;
    }

    public void setLdapGroupInclusion(String ldapGroupInclusion) {
        this.ldapGroupInclusion = ldapGroupInclusion;
    }

    public SiteEntity ldapHost(String ldapHost) {
        this.ldapHost = ldapHost;
        return this;
    }

    @Schema(example="ldap.site.com", description="LDAP host")
    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public SiteEntity ldapHost2(String ldapHost2) {
        this.ldapHost2 = ldapHost2;
        return this;
    }

    @Schema(example="ldap2.site.com", description="LDAP backup host")
    public String getLdapHost2() {
        return this.ldapHost2;
    }

    public void setLdapHost2(String ldapHost2) {
        this.ldapHost2 = ldapHost2;
    }

    public SiteEntity ldapHost3(String ldapHost3) {
        this.ldapHost3 = ldapHost3;
        return this;
    }

    @Schema(example="ldap3.site.com", description="LDAP backup host")
    public String getLdapHost3() {
        return this.ldapHost3;
    }

    public void setLdapHost3(String ldapHost3) {
        this.ldapHost3 = ldapHost3;
    }

    public SiteEntity ldapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
        return this;
    }

    @Schema(example="1", description="LDAP port")
    public Integer getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
    }

    public SiteEntity ldapSecure(Boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
        return this;
    }

    @Schema(example="true", description="Use secure LDAP?")
    public Boolean isLdapSecure() {
        return this.ldapSecure;
    }

    public void setLdapSecure(Boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
    }

    public SiteEntity ldapType(String ldapType) {
        this.ldapType = ldapType;
        return this;
    }

    @Schema(example="open_ldap", description="LDAP type")
    public String getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(String ldapType) {
        this.ldapType = ldapType;
    }

    public SiteEntity ldapUserAction(String ldapUserAction) {
        this.ldapUserAction = ldapUserAction;
        return this;
    }

    @Schema(example="disabled", description="Should we sync users from LDAP server?")
    public String getLdapUserAction() {
        return this.ldapUserAction;
    }

    public void setLdapUserAction(String ldapUserAction) {
        this.ldapUserAction = ldapUserAction;
    }

    public SiteEntity ldapUserIncludeGroups(String ldapUserIncludeGroups) {
        this.ldapUserIncludeGroups = ldapUserIncludeGroups;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) - if provided, only users in these groups will be added or synced.")
    public String getLdapUserIncludeGroups() {
        return this.ldapUserIncludeGroups;
    }

    public void setLdapUserIncludeGroups(String ldapUserIncludeGroups) {
        this.ldapUserIncludeGroups = ldapUserIncludeGroups;
    }

    public SiteEntity ldapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
        return this;
    }

    @Schema(example="[ldap username]", description="Username for signing in to LDAP server.")
    public String getLdapUsername() {
        return this.ldapUsername;
    }

    public void setLdapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
    }

    public SiteEntity ldapUsernameField(String ldapUsernameField) {
        this.ldapUsernameField = ldapUsernameField;
        return this;
    }

    @Schema(example="sAMAccountName", description="LDAP username field")
    public String getLdapUsernameField() {
        return this.ldapUsernameField;
    }

    public void setLdapUsernameField(String ldapUsernameField) {
        this.ldapUsernameField = ldapUsernameField;
    }

    public SiteEntity loginHelpText(String loginHelpText) {
        this.loginHelpText = loginHelpText;
        return this;
    }

    @Schema(example="Login page help text.", description="Login help text")
    public String getLoginHelpText() {
        return this.loginHelpText;
    }

    public void setLoginHelpText(String loginHelpText) {
        this.loginHelpText = loginHelpText;
    }

    public SiteEntity logo(ImageEntity logo) {
        this.logo = logo;
        return this;
    }

    @Schema(description="")
    public ImageEntity getLogo() {
        return this.logo;
    }

    public void setLogo(ImageEntity logo) {
        this.logo = logo;
    }

    public SiteEntity maxPriorPasswords(Integer maxPriorPasswords) {
        this.maxPriorPasswords = maxPriorPasswords;
        return this;
    }

    @Schema(example="1", description="Number of prior passwords to disallow")
    public Integer getMaxPriorPasswords() {
        return this.maxPriorPasswords;
    }

    public void setMaxPriorPasswords(Integer maxPriorPasswords) {
        this.maxPriorPasswords = maxPriorPasswords;
    }

    public SiteEntity nextBillingAmount(Double nextBillingAmount) {
        this.nextBillingAmount = nextBillingAmount;
        return this;
    }

    @Schema(example="1", description="Next billing amount")
    public Double getNextBillingAmount() {
        return this.nextBillingAmount;
    }

    public void setNextBillingAmount(Double nextBillingAmount) {
        this.nextBillingAmount = nextBillingAmount;
    }

    public SiteEntity nextBillingDate(String nextBillingDate) {
        this.nextBillingDate = nextBillingDate;
        return this;
    }

    @Schema(example="Apr 20", description="Next billing date")
    public String getNextBillingDate() {
        return this.nextBillingDate;
    }

    public void setNextBillingDate(String nextBillingDate) {
        this.nextBillingDate = nextBillingDate;
    }

    public SiteEntity officeIntegrationAvailable(Boolean officeIntegrationAvailable) {
        this.officeIntegrationAvailable = officeIntegrationAvailable;
        return this;
    }

    @Schema(example="true", description="Allow users to use Office for the web?")
    public Boolean isOfficeIntegrationAvailable() {
        return this.officeIntegrationAvailable;
    }

    public void setOfficeIntegrationAvailable(Boolean officeIntegrationAvailable) {
        this.officeIntegrationAvailable = officeIntegrationAvailable;
    }

    public SiteEntity oncehubLink(String oncehubLink) {
        this.oncehubLink = oncehubLink;
        return this;
    }

    @Schema(example="https://go.oncehub.com/files", description="Link to scheduling a meeting with our Sales team")
    public String getOncehubLink() {
        return this.oncehubLink;
    }

    public void setOncehubLink(String oncehubLink) {
        this.oncehubLink = oncehubLink;
    }

    public SiteEntity optOutGlobal(Boolean optOutGlobal) {
        this.optOutGlobal = optOutGlobal;
        return this;
    }

    @Schema(example="true", description="Use servers in the USA only?")
    public Boolean isOptOutGlobal() {
        return this.optOutGlobal;
    }

    public void setOptOutGlobal(Boolean optOutGlobal) {
        this.optOutGlobal = optOutGlobal;
    }

    public SiteEntity overageNotifiedAt(DateTime overageNotifiedAt) {
        this.overageNotifiedAt = overageNotifiedAt;
        return this;
    }

    @Schema(description="Last time the site was notified about an overage")
    public DateTime getOverageNotifiedAt() {
        return this.overageNotifiedAt;
    }

    public void setOverageNotifiedAt(DateTime overageNotifiedAt) {
        this.overageNotifiedAt = overageNotifiedAt;
    }

    public SiteEntity overageNotify(Boolean overageNotify) {
        this.overageNotify = overageNotify;
        return this;
    }

    @Schema(example="true", description="Notify site email of overages?")
    public Boolean isOverageNotify() {
        return this.overageNotify;
    }

    public void setOverageNotify(Boolean overageNotify) {
        this.overageNotify = overageNotify;
    }

    public SiteEntity overdue(Boolean overdue) {
        this.overdue = overdue;
        return this;
    }

    @Schema(example="true", description="Is this site's billing overdue?")
    public Boolean isOverdue() {
        return this.overdue;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    public SiteEntity passwordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
        return this;
    }

    @Schema(example="1", description="Shortest password length for users")
    public Integer getPasswordMinLength() {
        return this.passwordMinLength;
    }

    public void setPasswordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public SiteEntity passwordRequireLetter(Boolean passwordRequireLetter) {
        this.passwordRequireLetter = passwordRequireLetter;
        return this;
    }

    @Schema(example="true", description="Require a letter in passwords?")
    public Boolean isPasswordRequireLetter() {
        return this.passwordRequireLetter;
    }

    public void setPasswordRequireLetter(Boolean passwordRequireLetter) {
        this.passwordRequireLetter = passwordRequireLetter;
    }

    public SiteEntity passwordRequireMixed(Boolean passwordRequireMixed) {
        this.passwordRequireMixed = passwordRequireMixed;
        return this;
    }

    @Schema(example="true", description="Require lower and upper case letters in passwords?")
    public Boolean isPasswordRequireMixed() {
        return this.passwordRequireMixed;
    }

    public void setPasswordRequireMixed(Boolean passwordRequireMixed) {
        this.passwordRequireMixed = passwordRequireMixed;
    }

    public SiteEntity passwordRequireNumber(Boolean passwordRequireNumber) {
        this.passwordRequireNumber = passwordRequireNumber;
        return this;
    }

    @Schema(example="true", description="Require a number in passwords?")
    public Boolean isPasswordRequireNumber() {
        return this.passwordRequireNumber;
    }

    public void setPasswordRequireNumber(Boolean passwordRequireNumber) {
        this.passwordRequireNumber = passwordRequireNumber;
    }

    public SiteEntity passwordRequireSpecial(Boolean passwordRequireSpecial) {
        this.passwordRequireSpecial = passwordRequireSpecial;
        return this;
    }

    @Schema(example="true", description="Require special characters in password?")
    public Boolean isPasswordRequireSpecial() {
        return this.passwordRequireSpecial;
    }

    public void setPasswordRequireSpecial(Boolean passwordRequireSpecial) {
        this.passwordRequireSpecial = passwordRequireSpecial;
    }

    public SiteEntity passwordRequireUnbreached(Boolean passwordRequireUnbreached) {
        this.passwordRequireUnbreached = passwordRequireUnbreached;
        return this;
    }

    @Schema(example="true", description="Require passwords that have not been previously breached? (see https://haveibeenpwned.com/)")
    public Boolean isPasswordRequireUnbreached() {
        return this.passwordRequireUnbreached;
    }

    public void setPasswordRequireUnbreached(Boolean passwordRequireUnbreached) {
        this.passwordRequireUnbreached = passwordRequireUnbreached;
    }

    public SiteEntity passwordRequirementsApplyToBundles(Boolean passwordRequirementsApplyToBundles) {
        this.passwordRequirementsApplyToBundles = passwordRequirementsApplyToBundles;
        return this;
    }

    @Schema(example="true", description="Require bundles' passwords, and passwords for other items (inboxes, public shares, etc.) to conform to the same requirements as users' passwords?")
    public Boolean isPasswordRequirementsApplyToBundles() {
        return this.passwordRequirementsApplyToBundles;
    }

    public void setPasswordRequirementsApplyToBundles(Boolean passwordRequirementsApplyToBundles) {
        this.passwordRequirementsApplyToBundles = passwordRequirementsApplyToBundles;
    }

    public SiteEntity passwordValidityDays(Integer passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
        return this;
    }

    @Schema(example="1", description="Number of days password is valid")
    public Integer getPasswordValidityDays() {
        return this.passwordValidityDays;
    }

    public void setPasswordValidityDays(Integer passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
    }

    public SiteEntity phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(example="555-555-5555", description="Site phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public SiteEntity require2fa(Boolean require2fa) {
        this.require2fa = require2fa;
        return this;
    }

    @Schema(example="true", description="Require two-factor authentication for all users?")
    public Boolean isRequire2fa() {
        return this.require2fa;
    }

    public void setRequire2fa(Boolean require2fa) {
        this.require2fa = require2fa;
    }

    public SiteEntity require2faStopTime(DateTime require2faStopTime) {
        this.require2faStopTime = require2faStopTime;
        return this;
    }

    @Schema(description="If set, requirement for two-factor authentication has been scheduled to end on this date-time.")
    public DateTime getRequire2faStopTime() {
        return this.require2faStopTime;
    }

    public void setRequire2faStopTime(DateTime require2faStopTime) {
        this.require2faStopTime = require2faStopTime;
    }

    public SiteEntity require2faUserType(Require2faUserTypeEnum require2faUserType) {
        this.require2faUserType = require2faUserType;
        return this;
    }

    @Schema(example="`site_admins`", description="What type of user is required to use two-factor authentication (when require_2fa is set to `true` for this site)?")
    public Require2faUserTypeEnum getRequire2faUserType() {
        return this.require2faUserType;
    }

    public void setRequire2faUserType(Require2faUserTypeEnum require2faUserType) {
        this.require2faUserType = require2faUserType;
    }

    public SiteEntity session(SessionEntity session) {
        this.session = session;
        return this;
    }

    @Schema(description="")
    public SessionEntity getSession() {
        return this.session;
    }

    public void setSession(SessionEntity session) {
        this.session = session;
    }

    public SiteEntity sessionPinnedByIp(Boolean sessionPinnedByIp) {
        this.sessionPinnedByIp = sessionPinnedByIp;
        return this;
    }

    @Schema(example="true", description="Are sessions locked to the same IP? (i.e. do users need to log in again if they change IPs?)")
    public Boolean isSessionPinnedByIp() {
        return this.sessionPinnedByIp;
    }

    public void setSessionPinnedByIp(Boolean sessionPinnedByIp) {
        this.sessionPinnedByIp = sessionPinnedByIp;
    }

    public SiteEntity sftpUserRootEnabled(Boolean sftpUserRootEnabled) {
        this.sftpUserRootEnabled = sftpUserRootEnabled;
        return this;
    }

    @Schema(description="Use user FTP roots also for SFTP?")
    public Boolean isSftpUserRootEnabled() {
        return this.sftpUserRootEnabled;
    }

    public void setSftpUserRootEnabled(Boolean sftpUserRootEnabled) {
        this.sftpUserRootEnabled = sftpUserRootEnabled;
    }

    public SiteEntity sharingEnabled(Boolean sharingEnabled) {
        this.sharingEnabled = sharingEnabled;
        return this;
    }

    @Schema(example="true", description="Allow bundle creation")
    public Boolean isSharingEnabled() {
        return this.sharingEnabled;
    }

    public void setSharingEnabled(Boolean sharingEnabled) {
        this.sharingEnabled = sharingEnabled;
    }

    public SiteEntity showRequestAccessLink(Boolean showRequestAccessLink) {
        this.showRequestAccessLink = showRequestAccessLink;
        return this;
    }

    @Schema(example="true", description="Show request access link for users without access?  Currently unused.")
    public Boolean isShowRequestAccessLink() {
        return this.showRequestAccessLink;
    }

    public void setShowRequestAccessLink(Boolean showRequestAccessLink) {
        this.showRequestAccessLink = showRequestAccessLink;
    }

    public SiteEntity siteFooter(String siteFooter) {
        this.siteFooter = siteFooter;
        return this;
    }

    @Schema(description="Custom site footer text")
    public String getSiteFooter() {
        return this.siteFooter;
    }

    public void setSiteFooter(String siteFooter) {
        this.siteFooter = siteFooter;
    }

    public SiteEntity siteHeader(String siteHeader) {
        this.siteHeader = siteHeader;
        return this;
    }

    @Schema(description="Custom site header text")
    public String getSiteHeader() {
        return this.siteHeader;
    }

    public void setSiteHeader(String siteHeader) {
        this.siteHeader = siteHeader;
    }

    public SiteEntity smtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
        return this;
    }

    @Schema(example="smtp.my-mail-server.com", description="SMTP server hostname or IP")
    public String getSmtpAddress() {
        return this.smtpAddress;
    }

    public void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }

    public SiteEntity smtpAuthentication(String smtpAuthentication) {
        this.smtpAuthentication = smtpAuthentication;
        return this;
    }

    @Schema(example="plain", description="SMTP server authentication type")
    public String getSmtpAuthentication() {
        return this.smtpAuthentication;
    }

    public void setSmtpAuthentication(String smtpAuthentication) {
        this.smtpAuthentication = smtpAuthentication;
    }

    public SiteEntity smtpFrom(String smtpFrom) {
        this.smtpFrom = smtpFrom;
        return this;
    }

    @Schema(example="me@my-mail-server.com", description="From address to use when mailing through custom SMTP")
    public String getSmtpFrom() {
        return this.smtpFrom;
    }

    public void setSmtpFrom(String smtpFrom) {
        this.smtpFrom = smtpFrom;
    }

    public SiteEntity smtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
        return this;
    }

    @Schema(example="25", description="SMTP server port")
    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    public SiteEntity smtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
        return this;
    }

    @Schema(example="mail", description="SMTP server username")
    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
    }

    public SiteEntity sessionExpiry(Double sessionExpiry) {
        this.sessionExpiry = sessionExpiry;
        return this;
    }

    @Schema(example="6", description="Session expiry in hours")
    public Double getSessionExpiry() {
        return this.sessionExpiry;
    }

    public void setSessionExpiry(Double sessionExpiry) {
        this.sessionExpiry = sessionExpiry;
    }

    public SiteEntity sslRequired(Boolean sslRequired) {
        this.sslRequired = sslRequired;
        return this;
    }

    @Schema(example="true", description="Is SSL required?  Disabling this is insecure.")
    public Boolean isSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(Boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    public SiteEntity subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Schema(example="mysite", description="Site subdomain")
    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public SiteEntity switchToPlanDate(DateTime switchToPlanDate) {
        this.switchToPlanDate = switchToPlanDate;
        return this;
    }

    @Schema(description="If switching plans, when does the new plan take effect?")
    public DateTime getSwitchToPlanDate() {
        return this.switchToPlanDate;
    }

    public void setSwitchToPlanDate(DateTime switchToPlanDate) {
        this.switchToPlanDate = switchToPlanDate;
    }

    public SiteEntity tlsDisabled(Boolean tlsDisabled) {
        this.tlsDisabled = tlsDisabled;
        return this;
    }

    @Schema(description="Is TLS disabled(site setting)?")
    public Boolean isTlsDisabled() {
        return this.tlsDisabled;
    }

    public void setTlsDisabled(Boolean tlsDisabled) {
        this.tlsDisabled = tlsDisabled;
    }

    public SiteEntity trialDaysLeft(Integer trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
        return this;
    }

    @Schema(example="1", description="Number of days left in trial")
    public Integer getTrialDaysLeft() {
        return this.trialDaysLeft;
    }

    public void setTrialDaysLeft(Integer trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
    }

    public SiteEntity trialUntil(DateTime trialUntil) {
        this.trialUntil = trialUntil;
        return this;
    }

    @Schema(description="When does this Site trial expire?")
    public DateTime getTrialUntil() {
        return this.trialUntil;
    }

    public void setTrialUntil(DateTime trialUntil) {
        this.trialUntil = trialUntil;
    }

    public SiteEntity updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Last time this Site was updated")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public SiteEntity useProvidedModifiedAt(Boolean useProvidedModifiedAt) {
        this.useProvidedModifiedAt = useProvidedModifiedAt;
        return this;
    }

    @Schema(example="true", description="Allow uploaders to set `provided_modified_at` for uploaded files?")
    public Boolean isUseProvidedModifiedAt() {
        return this.useProvidedModifiedAt;
    }

    public void setUseProvidedModifiedAt(Boolean useProvidedModifiedAt) {
        this.useProvidedModifiedAt = useProvidedModifiedAt;
    }

    public SiteEntity user(UserEntity user) {
        this.user = user;
        return this;
    }

    @Schema(description="")
    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public SiteEntity userLockout(Boolean userLockout) {
        this.userLockout = userLockout;
        return this;
    }

    @Schema(example="true", description="Will users be locked out after incorrect login attempts?")
    public Boolean isUserLockout() {
        return this.userLockout;
    }

    public void setUserLockout(Boolean userLockout) {
        this.userLockout = userLockout;
    }

    public SiteEntity userLockoutLockPeriod(Integer userLockoutLockPeriod) {
        this.userLockoutLockPeriod = userLockoutLockPeriod;
        return this;
    }

    @Schema(example="1", description="How many hours to lock user out for failed password?")
    public Integer getUserLockoutLockPeriod() {
        return this.userLockoutLockPeriod;
    }

    public void setUserLockoutLockPeriod(Integer userLockoutLockPeriod) {
        this.userLockoutLockPeriod = userLockoutLockPeriod;
    }

    public SiteEntity userLockoutTries(Integer userLockoutTries) {
        this.userLockoutTries = userLockoutTries;
        return this;
    }

    @Schema(example="1", description="Number of login tries within `user_lockout_within` hours before users are locked out")
    public Integer getUserLockoutTries() {
        return this.userLockoutTries;
    }

    public void setUserLockoutTries(Integer userLockoutTries) {
        this.userLockoutTries = userLockoutTries;
    }

    public SiteEntity userLockoutWithin(Integer userLockoutWithin) {
        this.userLockoutWithin = userLockoutWithin;
        return this;
    }

    @Schema(example="6", description="Number of hours for user lockout window")
    public Integer getUserLockoutWithin() {
        return this.userLockoutWithin;
    }

    public void setUserLockoutWithin(Integer userLockoutWithin) {
        this.userLockoutWithin = userLockoutWithin;
    }

    public SiteEntity userRequestsEnabled(Boolean userRequestsEnabled) {
        this.userRequestsEnabled = userRequestsEnabled;
        return this;
    }

    @Schema(example="true", description="Enable User Requests feature")
    public Boolean isUserRequestsEnabled() {
        return this.userRequestsEnabled;
    }

    public void setUserRequestsEnabled(Boolean userRequestsEnabled) {
        this.userRequestsEnabled = userRequestsEnabled;
    }

    public SiteEntity welcomeCustomText(String welcomeCustomText) {
        this.welcomeCustomText = welcomeCustomText;
        return this;
    }

    @Schema(example="Welcome to my site!", description="Custom text send in user welcome email")
    public String getWelcomeCustomText() {
        return this.welcomeCustomText;
    }

    public void setWelcomeCustomText(String welcomeCustomText) {
        this.welcomeCustomText = welcomeCustomText;
    }

    public SiteEntity welcomeEmailCc(String welcomeEmailCc) {
        this.welcomeEmailCc = welcomeEmailCc;
        return this;
    }

    @Schema(description="Include this email in welcome emails if enabled")
    public String getWelcomeEmailCc() {
        return this.welcomeEmailCc;
    }

    public void setWelcomeEmailCc(String welcomeEmailCc) {
        this.welcomeEmailCc = welcomeEmailCc;
    }

    public SiteEntity welcomeEmailEnabled(Boolean welcomeEmailEnabled) {
        this.welcomeEmailEnabled = welcomeEmailEnabled;
        return this;
    }

    @Schema(example="true", description="Will the welcome email be sent to new users?")
    public Boolean isWelcomeEmailEnabled() {
        return this.welcomeEmailEnabled;
    }

    public void setWelcomeEmailEnabled(Boolean welcomeEmailEnabled) {
        this.welcomeEmailEnabled = welcomeEmailEnabled;
    }

    public SiteEntity welcomeScreen(WelcomeScreenEnum welcomeScreen) {
        this.welcomeScreen = welcomeScreen;
        return this;
    }

    @Schema(example="user_controlled", description="Does the welcome screen appear?")
    public WelcomeScreenEnum getWelcomeScreen() {
        return this.welcomeScreen;
    }

    public void setWelcomeScreen(WelcomeScreenEnum welcomeScreen) {
        this.welcomeScreen = welcomeScreen;
    }

    public SiteEntity windowsModeFtp(Boolean windowsModeFtp) {
        this.windowsModeFtp = windowsModeFtp;
        return this;
    }

    @Schema(example="true", description="Does FTP user Windows emulation mode?")
    public Boolean isWindowsModeFtp() {
        return this.windowsModeFtp;
    }

    public void setWindowsModeFtp(Boolean windowsModeFtp) {
        this.windowsModeFtp = windowsModeFtp;
    }

    public SiteEntity disableUsersFromInactivityPeriodDays(Integer disableUsersFromInactivityPeriodDays) {
        this.disableUsersFromInactivityPeriodDays = disableUsersFromInactivityPeriodDays;
        return this;
    }

    @Schema(example="1", description="If greater than zero, users will unable to login if they do not show activity within this number of days.")
    public Integer getDisableUsersFromInactivityPeriodDays() {
        return this.disableUsersFromInactivityPeriodDays;
    }

    public void setDisableUsersFromInactivityPeriodDays(Integer disableUsersFromInactivityPeriodDays) {
        this.disableUsersFromInactivityPeriodDays = disableUsersFromInactivityPeriodDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteEntity siteEntity = (SiteEntity)o;
        return Objects.equals(this.name, siteEntity.name) && Objects.equals(this.allowed2faMethodSms, siteEntity.allowed2faMethodSms) && Objects.equals(this.allowed2faMethodTotp, siteEntity.allowed2faMethodTotp) && Objects.equals(this.allowed2faMethodU2f, siteEntity.allowed2faMethodU2f) && Objects.equals(this.allowed2faMethodYubi, siteEntity.allowed2faMethodYubi) && Objects.equals(this.adminUserId, siteEntity.adminUserId) && Objects.equals(this.allowBundleNames, siteEntity.allowBundleNames) && Objects.equals(this.allowedCountries, siteEntity.allowedCountries) && Objects.equals(this.allowedIps, siteEntity.allowedIps) && Objects.equals(this.askAboutOverwrites, siteEntity.askAboutOverwrites) && Objects.equals(this.bundleExpiration, siteEntity.bundleExpiration) && Objects.equals(this.bundlePasswordRequired, siteEntity.bundlePasswordRequired) && Objects.equals(this.bundleRequireShareRecipient, siteEntity.bundleRequireShareRecipient) && Objects.equals(this.color2Left, siteEntity.color2Left) && Objects.equals(this.color2Link, siteEntity.color2Link) && Objects.equals(this.color2Text, siteEntity.color2Text) && Objects.equals(this.color2Top, siteEntity.color2Top) && Objects.equals(this.color2TopText, siteEntity.color2TopText) && Objects.equals(this.contactName, siteEntity.contactName) && Objects.equals(this.createdAt, siteEntity.createdAt) && Objects.equals(this.currency, siteEntity.currency) && Objects.equals(this.customNamespace, siteEntity.customNamespace) && Objects.equals(this.daysToRetainBackups, siteEntity.daysToRetainBackups) && Objects.equals(this.defaultTimeZone, siteEntity.defaultTimeZone) && Objects.equals(this.desktopApp, siteEntity.desktopApp) && Objects.equals(this.desktopAppSessionIpPinning, siteEntity.desktopAppSessionIpPinning) && Objects.equals(this.desktopAppSessionLifetime, siteEntity.desktopAppSessionLifetime) && Objects.equals(this.disallowedCountries, siteEntity.disallowedCountries) && Objects.equals(this.disableNotifications, siteEntity.disableNotifications) && Objects.equals(this.disablePasswordReset, siteEntity.disablePasswordReset) && Objects.equals(this.domain, siteEntity.domain) && Objects.equals(this.email, siteEntity.email) && Objects.equals(this.replyToEmail, siteEntity.replyToEmail) && Objects.equals(this.nonSsoGroupsAllowed, siteEntity.nonSsoGroupsAllowed) && Objects.equals(this.nonSsoUsersAllowed, siteEntity.nonSsoUsersAllowed) && Objects.equals(this.folderPermissionsGroupsOnly, siteEntity.folderPermissionsGroupsOnly) && Objects.equals(this.hipaa, siteEntity.hipaa) && Objects.equals(this.icon128, siteEntity.icon128) && Objects.equals(this.icon16, siteEntity.icon16) && Objects.equals(this.icon32, siteEntity.icon32) && Objects.equals(this.icon48, siteEntity.icon48) && Objects.equals(this.immutableFilesSetAt, siteEntity.immutableFilesSetAt) && Objects.equals(this.includePasswordInWelcomeEmail, siteEntity.includePasswordInWelcomeEmail) && Objects.equals(this.language, siteEntity.language) && Objects.equals(this.ldapBaseDn, siteEntity.ldapBaseDn) && Objects.equals(this.ldapDomain, siteEntity.ldapDomain) && Objects.equals(this.ldapEnabled, siteEntity.ldapEnabled) && Objects.equals(this.ldapGroupAction, siteEntity.ldapGroupAction) && Objects.equals(this.ldapGroupExclusion, siteEntity.ldapGroupExclusion) && Objects.equals(this.ldapGroupInclusion, siteEntity.ldapGroupInclusion) && Objects.equals(this.ldapHost, siteEntity.ldapHost) && Objects.equals(this.ldapHost2, siteEntity.ldapHost2) && Objects.equals(this.ldapHost3, siteEntity.ldapHost3) && Objects.equals(this.ldapPort, siteEntity.ldapPort) && Objects.equals(this.ldapSecure, siteEntity.ldapSecure) && Objects.equals(this.ldapType, siteEntity.ldapType) && Objects.equals(this.ldapUserAction, siteEntity.ldapUserAction) && Objects.equals(this.ldapUserIncludeGroups, siteEntity.ldapUserIncludeGroups) && Objects.equals(this.ldapUsername, siteEntity.ldapUsername) && Objects.equals(this.ldapUsernameField, siteEntity.ldapUsernameField) && Objects.equals(this.loginHelpText, siteEntity.loginHelpText) && Objects.equals(this.logo, siteEntity.logo) && Objects.equals(this.maxPriorPasswords, siteEntity.maxPriorPasswords) && Objects.equals(this.nextBillingAmount, siteEntity.nextBillingAmount) && Objects.equals(this.nextBillingDate, siteEntity.nextBillingDate) && Objects.equals(this.officeIntegrationAvailable, siteEntity.officeIntegrationAvailable) && Objects.equals(this.oncehubLink, siteEntity.oncehubLink) && Objects.equals(this.optOutGlobal, siteEntity.optOutGlobal) && Objects.equals(this.overageNotifiedAt, siteEntity.overageNotifiedAt) && Objects.equals(this.overageNotify, siteEntity.overageNotify) && Objects.equals(this.overdue, siteEntity.overdue) && Objects.equals(this.passwordMinLength, siteEntity.passwordMinLength) && Objects.equals(this.passwordRequireLetter, siteEntity.passwordRequireLetter) && Objects.equals(this.passwordRequireMixed, siteEntity.passwordRequireMixed) && Objects.equals(this.passwordRequireNumber, siteEntity.passwordRequireNumber) && Objects.equals(this.passwordRequireSpecial, siteEntity.passwordRequireSpecial) && Objects.equals(this.passwordRequireUnbreached, siteEntity.passwordRequireUnbreached) && Objects.equals(this.passwordRequirementsApplyToBundles, siteEntity.passwordRequirementsApplyToBundles) && Objects.equals(this.passwordValidityDays, siteEntity.passwordValidityDays) && Objects.equals(this.phone, siteEntity.phone) && Objects.equals(this.require2fa, siteEntity.require2fa) && Objects.equals(this.require2faStopTime, siteEntity.require2faStopTime) && Objects.equals((Object)this.require2faUserType, (Object)siteEntity.require2faUserType) && Objects.equals(this.session, siteEntity.session) && Objects.equals(this.sessionPinnedByIp, siteEntity.sessionPinnedByIp) && Objects.equals(this.sftpUserRootEnabled, siteEntity.sftpUserRootEnabled) && Objects.equals(this.sharingEnabled, siteEntity.sharingEnabled) && Objects.equals(this.showRequestAccessLink, siteEntity.showRequestAccessLink) && Objects.equals(this.siteFooter, siteEntity.siteFooter) && Objects.equals(this.siteHeader, siteEntity.siteHeader) && Objects.equals(this.smtpAddress, siteEntity.smtpAddress) && Objects.equals(this.smtpAuthentication, siteEntity.smtpAuthentication) && Objects.equals(this.smtpFrom, siteEntity.smtpFrom) && Objects.equals(this.smtpPort, siteEntity.smtpPort) && Objects.equals(this.smtpUsername, siteEntity.smtpUsername) && Objects.equals(this.sessionExpiry, siteEntity.sessionExpiry) && Objects.equals(this.sslRequired, siteEntity.sslRequired) && Objects.equals(this.subdomain, siteEntity.subdomain) && Objects.equals(this.switchToPlanDate, siteEntity.switchToPlanDate) && Objects.equals(this.tlsDisabled, siteEntity.tlsDisabled) && Objects.equals(this.trialDaysLeft, siteEntity.trialDaysLeft) && Objects.equals(this.trialUntil, siteEntity.trialUntil) && Objects.equals(this.updatedAt, siteEntity.updatedAt) && Objects.equals(this.useProvidedModifiedAt, siteEntity.useProvidedModifiedAt) && Objects.equals(this.user, siteEntity.user) && Objects.equals(this.userLockout, siteEntity.userLockout) && Objects.equals(this.userLockoutLockPeriod, siteEntity.userLockoutLockPeriod) && Objects.equals(this.userLockoutTries, siteEntity.userLockoutTries) && Objects.equals(this.userLockoutWithin, siteEntity.userLockoutWithin) && Objects.equals(this.userRequestsEnabled, siteEntity.userRequestsEnabled) && Objects.equals(this.welcomeCustomText, siteEntity.welcomeCustomText) && Objects.equals(this.welcomeEmailCc, siteEntity.welcomeEmailCc) && Objects.equals(this.welcomeEmailEnabled, siteEntity.welcomeEmailEnabled) && Objects.equals((Object)this.welcomeScreen, (Object)siteEntity.welcomeScreen) && Objects.equals(this.windowsModeFtp, siteEntity.windowsModeFtp) && Objects.equals(this.disableUsersFromInactivityPeriodDays, siteEntity.disableUsersFromInactivityPeriodDays);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.allowed2faMethodSms, this.allowed2faMethodTotp, this.allowed2faMethodU2f, this.allowed2faMethodYubi, this.adminUserId, this.allowBundleNames, this.allowedCountries, this.allowedIps, this.askAboutOverwrites, this.bundleExpiration, this.bundlePasswordRequired, this.bundleRequireShareRecipient, this.color2Left, this.color2Link, this.color2Text, this.color2Top, this.color2TopText, this.contactName, this.createdAt, this.currency, this.customNamespace, this.daysToRetainBackups, this.defaultTimeZone, this.desktopApp, this.desktopAppSessionIpPinning, this.desktopAppSessionLifetime, this.disallowedCountries, this.disableNotifications, this.disablePasswordReset, this.domain, this.email, this.replyToEmail, this.nonSsoGroupsAllowed, this.nonSsoUsersAllowed, this.folderPermissionsGroupsOnly, this.hipaa, this.icon128, this.icon16, this.icon32, this.icon48, this.immutableFilesSetAt, this.includePasswordInWelcomeEmail, this.language, this.ldapBaseDn, this.ldapDomain, this.ldapEnabled, this.ldapGroupAction, this.ldapGroupExclusion, this.ldapGroupInclusion, this.ldapHost, this.ldapHost2, this.ldapHost3, this.ldapPort, this.ldapSecure, this.ldapType, this.ldapUserAction, this.ldapUserIncludeGroups, this.ldapUsername, this.ldapUsernameField, this.loginHelpText, this.logo, this.maxPriorPasswords, this.nextBillingAmount, this.nextBillingDate, this.officeIntegrationAvailable, this.oncehubLink, this.optOutGlobal, this.overageNotifiedAt, this.overageNotify, this.overdue, this.passwordMinLength, this.passwordRequireLetter, this.passwordRequireMixed, this.passwordRequireNumber, this.passwordRequireSpecial, this.passwordRequireUnbreached, this.passwordRequirementsApplyToBundles, this.passwordValidityDays, this.phone, this.require2fa, this.require2faStopTime, this.require2faUserType, this.session, this.sessionPinnedByIp, this.sftpUserRootEnabled, this.sharingEnabled, this.showRequestAccessLink, this.siteFooter, this.siteHeader, this.smtpAddress, this.smtpAuthentication, this.smtpFrom, this.smtpPort, this.smtpUsername, this.sessionExpiry, this.sslRequired, this.subdomain, this.switchToPlanDate, this.tlsDisabled, this.trialDaysLeft, this.trialUntil, this.updatedAt, this.useProvidedModifiedAt, this.user, this.userLockout, this.userLockoutLockPeriod, this.userLockoutTries, this.userLockoutWithin, this.userRequestsEnabled, this.welcomeCustomText, this.welcomeEmailCc, this.welcomeEmailEnabled, this.welcomeScreen, this.windowsModeFtp, this.disableUsersFromInactivityPeriodDays});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SiteEntity {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    allowed2faMethodSms: ").append(this.toIndentedString(this.allowed2faMethodSms)).append("\n");
        sb.append("    allowed2faMethodTotp: ").append(this.toIndentedString(this.allowed2faMethodTotp)).append("\n");
        sb.append("    allowed2faMethodU2f: ").append(this.toIndentedString(this.allowed2faMethodU2f)).append("\n");
        sb.append("    allowed2faMethodYubi: ").append(this.toIndentedString(this.allowed2faMethodYubi)).append("\n");
        sb.append("    adminUserId: ").append(this.toIndentedString(this.adminUserId)).append("\n");
        sb.append("    allowBundleNames: ").append(this.toIndentedString(this.allowBundleNames)).append("\n");
        sb.append("    allowedCountries: ").append(this.toIndentedString(this.allowedCountries)).append("\n");
        sb.append("    allowedIps: ").append(this.toIndentedString(this.allowedIps)).append("\n");
        sb.append("    askAboutOverwrites: ").append(this.toIndentedString(this.askAboutOverwrites)).append("\n");
        sb.append("    bundleExpiration: ").append(this.toIndentedString(this.bundleExpiration)).append("\n");
        sb.append("    bundlePasswordRequired: ").append(this.toIndentedString(this.bundlePasswordRequired)).append("\n");
        sb.append("    bundleRequireShareRecipient: ").append(this.toIndentedString(this.bundleRequireShareRecipient)).append("\n");
        sb.append("    color2Left: ").append(this.toIndentedString(this.color2Left)).append("\n");
        sb.append("    color2Link: ").append(this.toIndentedString(this.color2Link)).append("\n");
        sb.append("    color2Text: ").append(this.toIndentedString(this.color2Text)).append("\n");
        sb.append("    color2Top: ").append(this.toIndentedString(this.color2Top)).append("\n");
        sb.append("    color2TopText: ").append(this.toIndentedString(this.color2TopText)).append("\n");
        sb.append("    contactName: ").append(this.toIndentedString(this.contactName)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    customNamespace: ").append(this.toIndentedString(this.customNamespace)).append("\n");
        sb.append("    daysToRetainBackups: ").append(this.toIndentedString(this.daysToRetainBackups)).append("\n");
        sb.append("    defaultTimeZone: ").append(this.toIndentedString(this.defaultTimeZone)).append("\n");
        sb.append("    desktopApp: ").append(this.toIndentedString(this.desktopApp)).append("\n");
        sb.append("    desktopAppSessionIpPinning: ").append(this.toIndentedString(this.desktopAppSessionIpPinning)).append("\n");
        sb.append("    desktopAppSessionLifetime: ").append(this.toIndentedString(this.desktopAppSessionLifetime)).append("\n");
        sb.append("    disallowedCountries: ").append(this.toIndentedString(this.disallowedCountries)).append("\n");
        sb.append("    disableNotifications: ").append(this.toIndentedString(this.disableNotifications)).append("\n");
        sb.append("    disablePasswordReset: ").append(this.toIndentedString(this.disablePasswordReset)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    replyToEmail: ").append(this.toIndentedString(this.replyToEmail)).append("\n");
        sb.append("    nonSsoGroupsAllowed: ").append(this.toIndentedString(this.nonSsoGroupsAllowed)).append("\n");
        sb.append("    nonSsoUsersAllowed: ").append(this.toIndentedString(this.nonSsoUsersAllowed)).append("\n");
        sb.append("    folderPermissionsGroupsOnly: ").append(this.toIndentedString(this.folderPermissionsGroupsOnly)).append("\n");
        sb.append("    hipaa: ").append(this.toIndentedString(this.hipaa)).append("\n");
        sb.append("    icon128: ").append(this.toIndentedString(this.icon128)).append("\n");
        sb.append("    icon16: ").append(this.toIndentedString(this.icon16)).append("\n");
        sb.append("    icon32: ").append(this.toIndentedString(this.icon32)).append("\n");
        sb.append("    icon48: ").append(this.toIndentedString(this.icon48)).append("\n");
        sb.append("    immutableFilesSetAt: ").append(this.toIndentedString(this.immutableFilesSetAt)).append("\n");
        sb.append("    includePasswordInWelcomeEmail: ").append(this.toIndentedString(this.includePasswordInWelcomeEmail)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    ldapBaseDn: ").append(this.toIndentedString(this.ldapBaseDn)).append("\n");
        sb.append("    ldapDomain: ").append(this.toIndentedString(this.ldapDomain)).append("\n");
        sb.append("    ldapEnabled: ").append(this.toIndentedString(this.ldapEnabled)).append("\n");
        sb.append("    ldapGroupAction: ").append(this.toIndentedString(this.ldapGroupAction)).append("\n");
        sb.append("    ldapGroupExclusion: ").append(this.toIndentedString(this.ldapGroupExclusion)).append("\n");
        sb.append("    ldapGroupInclusion: ").append(this.toIndentedString(this.ldapGroupInclusion)).append("\n");
        sb.append("    ldapHost: ").append(this.toIndentedString(this.ldapHost)).append("\n");
        sb.append("    ldapHost2: ").append(this.toIndentedString(this.ldapHost2)).append("\n");
        sb.append("    ldapHost3: ").append(this.toIndentedString(this.ldapHost3)).append("\n");
        sb.append("    ldapPort: ").append(this.toIndentedString(this.ldapPort)).append("\n");
        sb.append("    ldapSecure: ").append(this.toIndentedString(this.ldapSecure)).append("\n");
        sb.append("    ldapType: ").append(this.toIndentedString(this.ldapType)).append("\n");
        sb.append("    ldapUserAction: ").append(this.toIndentedString(this.ldapUserAction)).append("\n");
        sb.append("    ldapUserIncludeGroups: ").append(this.toIndentedString(this.ldapUserIncludeGroups)).append("\n");
        sb.append("    ldapUsername: ").append(this.toIndentedString(this.ldapUsername)).append("\n");
        sb.append("    ldapUsernameField: ").append(this.toIndentedString(this.ldapUsernameField)).append("\n");
        sb.append("    loginHelpText: ").append(this.toIndentedString(this.loginHelpText)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    maxPriorPasswords: ").append(this.toIndentedString(this.maxPriorPasswords)).append("\n");
        sb.append("    nextBillingAmount: ").append(this.toIndentedString(this.nextBillingAmount)).append("\n");
        sb.append("    nextBillingDate: ").append(this.toIndentedString(this.nextBillingDate)).append("\n");
        sb.append("    officeIntegrationAvailable: ").append(this.toIndentedString(this.officeIntegrationAvailable)).append("\n");
        sb.append("    oncehubLink: ").append(this.toIndentedString(this.oncehubLink)).append("\n");
        sb.append("    optOutGlobal: ").append(this.toIndentedString(this.optOutGlobal)).append("\n");
        sb.append("    overageNotifiedAt: ").append(this.toIndentedString(this.overageNotifiedAt)).append("\n");
        sb.append("    overageNotify: ").append(this.toIndentedString(this.overageNotify)).append("\n");
        sb.append("    overdue: ").append(this.toIndentedString(this.overdue)).append("\n");
        sb.append("    passwordMinLength: ").append(this.toIndentedString(this.passwordMinLength)).append("\n");
        sb.append("    passwordRequireLetter: ").append(this.toIndentedString(this.passwordRequireLetter)).append("\n");
        sb.append("    passwordRequireMixed: ").append(this.toIndentedString(this.passwordRequireMixed)).append("\n");
        sb.append("    passwordRequireNumber: ").append(this.toIndentedString(this.passwordRequireNumber)).append("\n");
        sb.append("    passwordRequireSpecial: ").append(this.toIndentedString(this.passwordRequireSpecial)).append("\n");
        sb.append("    passwordRequireUnbreached: ").append(this.toIndentedString(this.passwordRequireUnbreached)).append("\n");
        sb.append("    passwordRequirementsApplyToBundles: ").append(this.toIndentedString(this.passwordRequirementsApplyToBundles)).append("\n");
        sb.append("    passwordValidityDays: ").append(this.toIndentedString(this.passwordValidityDays)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    require2fa: ").append(this.toIndentedString(this.require2fa)).append("\n");
        sb.append("    require2faStopTime: ").append(this.toIndentedString(this.require2faStopTime)).append("\n");
        sb.append("    require2faUserType: ").append(this.toIndentedString((Object)this.require2faUserType)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("    sessionPinnedByIp: ").append(this.toIndentedString(this.sessionPinnedByIp)).append("\n");
        sb.append("    sftpUserRootEnabled: ").append(this.toIndentedString(this.sftpUserRootEnabled)).append("\n");
        sb.append("    sharingEnabled: ").append(this.toIndentedString(this.sharingEnabled)).append("\n");
        sb.append("    showRequestAccessLink: ").append(this.toIndentedString(this.showRequestAccessLink)).append("\n");
        sb.append("    siteFooter: ").append(this.toIndentedString(this.siteFooter)).append("\n");
        sb.append("    siteHeader: ").append(this.toIndentedString(this.siteHeader)).append("\n");
        sb.append("    smtpAddress: ").append(this.toIndentedString(this.smtpAddress)).append("\n");
        sb.append("    smtpAuthentication: ").append(this.toIndentedString(this.smtpAuthentication)).append("\n");
        sb.append("    smtpFrom: ").append(this.toIndentedString(this.smtpFrom)).append("\n");
        sb.append("    smtpPort: ").append(this.toIndentedString(this.smtpPort)).append("\n");
        sb.append("    smtpUsername: ").append(this.toIndentedString(this.smtpUsername)).append("\n");
        sb.append("    sessionExpiry: ").append(this.toIndentedString(this.sessionExpiry)).append("\n");
        sb.append("    sslRequired: ").append(this.toIndentedString(this.sslRequired)).append("\n");
        sb.append("    subdomain: ").append(this.toIndentedString(this.subdomain)).append("\n");
        sb.append("    switchToPlanDate: ").append(this.toIndentedString(this.switchToPlanDate)).append("\n");
        sb.append("    tlsDisabled: ").append(this.toIndentedString(this.tlsDisabled)).append("\n");
        sb.append("    trialDaysLeft: ").append(this.toIndentedString(this.trialDaysLeft)).append("\n");
        sb.append("    trialUntil: ").append(this.toIndentedString(this.trialUntil)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    useProvidedModifiedAt: ").append(this.toIndentedString(this.useProvidedModifiedAt)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    userLockout: ").append(this.toIndentedString(this.userLockout)).append("\n");
        sb.append("    userLockoutLockPeriod: ").append(this.toIndentedString(this.userLockoutLockPeriod)).append("\n");
        sb.append("    userLockoutTries: ").append(this.toIndentedString(this.userLockoutTries)).append("\n");
        sb.append("    userLockoutWithin: ").append(this.toIndentedString(this.userLockoutWithin)).append("\n");
        sb.append("    userRequestsEnabled: ").append(this.toIndentedString(this.userRequestsEnabled)).append("\n");
        sb.append("    welcomeCustomText: ").append(this.toIndentedString(this.welcomeCustomText)).append("\n");
        sb.append("    welcomeEmailCc: ").append(this.toIndentedString(this.welcomeEmailCc)).append("\n");
        sb.append("    welcomeEmailEnabled: ").append(this.toIndentedString(this.welcomeEmailEnabled)).append("\n");
        sb.append("    welcomeScreen: ").append(this.toIndentedString((Object)this.welcomeScreen)).append("\n");
        sb.append("    windowsModeFtp: ").append(this.toIndentedString(this.windowsModeFtp)).append("\n");
        sb.append("    disableUsersFromInactivityPeriodDays: ").append(this.toIndentedString(this.disableUsersFromInactivityPeriodDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Require2faUserTypeEnum {
        ALL("all"),
        FOLDER_AND_SITE_ADMINS("folder_and_site_admins"),
        SITE_ADMINS("site_admins");

        private String value;

        private Require2faUserTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static Require2faUserTypeEnum fromValue(String text) {
            for (Require2faUserTypeEnum b : Require2faUserTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum WelcomeScreenEnum {
        ENABLED("enabled"),
        HIDDEN("hidden"),
        DISABLED("disabled");

        private String value;

        private WelcomeScreenEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WelcomeScreenEnum fromValue(String text) {
            for (WelcomeScreenEnum b : WelcomeScreenEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

