/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.util.Objects;

public class SiteBody {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="subdomain")
    private String subdomain = null;
    @JsonProperty(value="domain")
    private String domain = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="reply_to_email")
    private String replyToEmail = null;
    @JsonProperty(value="allow_bundle_names")
    private Boolean allowBundleNames = null;
    @JsonProperty(value="bundle_expiration")
    private Integer bundleExpiration = null;
    @JsonProperty(value="overage_notify")
    private Boolean overageNotify = null;
    @JsonProperty(value="welcome_email_enabled")
    private Boolean welcomeEmailEnabled = null;
    @JsonProperty(value="ask_about_overwrites")
    private Boolean askAboutOverwrites = null;
    @JsonProperty(value="show_request_access_link")
    private Boolean showRequestAccessLink = null;
    @JsonProperty(value="welcome_email_cc")
    private String welcomeEmailCc = null;
    @JsonProperty(value="welcome_custom_text")
    private String welcomeCustomText = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="windows_mode_ftp")
    private Boolean windowsModeFtp = null;
    @JsonProperty(value="default_time_zone")
    private String defaultTimeZone = null;
    @JsonProperty(value="desktop_app")
    private Boolean desktopApp = null;
    @JsonProperty(value="desktop_app_session_ip_pinning")
    private Boolean desktopAppSessionIpPinning = null;
    @JsonProperty(value="desktop_app_session_lifetime")
    private Integer desktopAppSessionLifetime = null;
    @JsonProperty(value="folder_permissions_groups_only")
    private Boolean folderPermissionsGroupsOnly = null;
    @JsonProperty(value="welcome_screen")
    private String welcomeScreen = null;
    @JsonProperty(value="office_integration_available")
    private Boolean officeIntegrationAvailable = null;
    @JsonProperty(value="session_expiry")
    private Double sessionExpiry = null;
    @JsonProperty(value="ssl_required")
    private Boolean sslRequired = null;
    @JsonProperty(value="tls_disabled")
    private Boolean tlsDisabled = null;
    @JsonProperty(value="user_lockout")
    private Boolean userLockout = null;
    @JsonProperty(value="user_lockout_tries")
    private Integer userLockoutTries = null;
    @JsonProperty(value="user_lockout_within")
    private Integer userLockoutWithin = null;
    @JsonProperty(value="user_lockout_lock_period")
    private Integer userLockoutLockPeriod = null;
    @JsonProperty(value="include_password_in_welcome_email")
    private Boolean includePasswordInWelcomeEmail = null;
    @JsonProperty(value="allowed_countries")
    private String allowedCountries = null;
    @JsonProperty(value="allowed_ips")
    private String allowedIps = null;
    @JsonProperty(value="disallowed_countries")
    private String disallowedCountries = null;
    @JsonProperty(value="days_to_retain_backups")
    private Integer daysToRetainBackups = null;
    @JsonProperty(value="max_prior_passwords")
    private Integer maxPriorPasswords = null;
    @JsonProperty(value="password_validity_days")
    private Integer passwordValidityDays = null;
    @JsonProperty(value="password_min_length")
    private Integer passwordMinLength = null;
    @JsonProperty(value="password_require_letter")
    private Boolean passwordRequireLetter = null;
    @JsonProperty(value="password_require_mixed")
    private Boolean passwordRequireMixed = null;
    @JsonProperty(value="password_require_special")
    private Boolean passwordRequireSpecial = null;
    @JsonProperty(value="password_require_number")
    private Boolean passwordRequireNumber = null;
    @JsonProperty(value="password_require_unbreached")
    private Boolean passwordRequireUnbreached = null;
    @JsonProperty(value="sftp_user_root_enabled")
    private Boolean sftpUserRootEnabled = null;
    @JsonProperty(value="disable_password_reset")
    private Boolean disablePasswordReset = null;
    @JsonProperty(value="immutable_files")
    private Boolean immutableFiles = null;
    @JsonProperty(value="session_pinned_by_ip")
    private Boolean sessionPinnedByIp = null;
    @JsonProperty(value="bundle_password_required")
    private Boolean bundlePasswordRequired = null;
    @JsonProperty(value="bundle_require_share_recipient")
    private Boolean bundleRequireShareRecipient = null;
    @JsonProperty(value="password_requirements_apply_to_bundles")
    private Boolean passwordRequirementsApplyToBundles = null;
    @JsonProperty(value="opt_out_global")
    private Boolean optOutGlobal = null;
    @JsonProperty(value="use_provided_modified_at")
    private Boolean useProvidedModifiedAt = null;
    @JsonProperty(value="custom_namespace")
    private Boolean customNamespace = null;
    @JsonProperty(value="disable_users_from_inactivity_period_days")
    private Integer disableUsersFromInactivityPeriodDays = null;
    @JsonProperty(value="non_sso_groups_allowed")
    private Boolean nonSsoGroupsAllowed = null;
    @JsonProperty(value="non_sso_users_allowed")
    private Boolean nonSsoUsersAllowed = null;
    @JsonProperty(value="sharing_enabled")
    private Boolean sharingEnabled = null;
    @JsonProperty(value="user_requests_enabled")
    private Boolean userRequestsEnabled = null;
    @JsonProperty(value="allowed_2fa_method_sms")
    private Boolean allowed2faMethodSms = null;
    @JsonProperty(value="allowed_2fa_method_u2f")
    private Boolean allowed2faMethodU2f = null;
    @JsonProperty(value="allowed_2fa_method_totp")
    private Boolean allowed2faMethodTotp = null;
    @JsonProperty(value="allowed_2fa_method_yubi")
    private Boolean allowed2faMethodYubi = null;
    @JsonProperty(value="require_2fa")
    private Boolean require2fa = null;
    @JsonProperty(value="require_2fa_user_type")
    private String require2faUserType = null;
    @JsonProperty(value="color2_top")
    private String color2Top = null;
    @JsonProperty(value="color2_left")
    private String color2Left = null;
    @JsonProperty(value="color2_link")
    private String color2Link = null;
    @JsonProperty(value="color2_text")
    private String color2Text = null;
    @JsonProperty(value="color2_top_text")
    private String color2TopText = null;
    @JsonProperty(value="site_header")
    private String siteHeader = null;
    @JsonProperty(value="site_footer")
    private String siteFooter = null;
    @JsonProperty(value="login_help_text")
    private String loginHelpText = null;
    @JsonProperty(value="smtp_address")
    private String smtpAddress = null;
    @JsonProperty(value="smtp_authentication")
    private String smtpAuthentication = null;
    @JsonProperty(value="smtp_from")
    private String smtpFrom = null;
    @JsonProperty(value="smtp_username")
    private String smtpUsername = null;
    @JsonProperty(value="smtp_port")
    private Integer smtpPort = null;
    @JsonProperty(value="ldap_enabled")
    private Boolean ldapEnabled = null;
    @JsonProperty(value="ldap_type")
    private String ldapType = null;
    @JsonProperty(value="ldap_host")
    private String ldapHost = null;
    @JsonProperty(value="ldap_host_2")
    private String ldapHost2 = null;
    @JsonProperty(value="ldap_host_3")
    private String ldapHost3 = null;
    @JsonProperty(value="ldap_port")
    private Integer ldapPort = null;
    @JsonProperty(value="ldap_secure")
    private Boolean ldapSecure = null;
    @JsonProperty(value="ldap_username")
    private String ldapUsername = null;
    @JsonProperty(value="ldap_username_field")
    private String ldapUsernameField = null;
    @JsonProperty(value="ldap_domain")
    private String ldapDomain = null;
    @JsonProperty(value="ldap_user_action")
    private String ldapUserAction = null;
    @JsonProperty(value="ldap_group_action")
    private String ldapGroupAction = null;
    @JsonProperty(value="ldap_user_include_groups")
    private String ldapUserIncludeGroups = null;
    @JsonProperty(value="ldap_group_exclusion")
    private String ldapGroupExclusion = null;
    @JsonProperty(value="ldap_group_inclusion")
    private String ldapGroupInclusion = null;
    @JsonProperty(value="ldap_base_dn")
    private String ldapBaseDn = null;
    @JsonProperty(value="icon16_file")
    private File icon16File = null;
    @JsonProperty(value="icon16_delete")
    private Boolean icon16Delete = null;
    @JsonProperty(value="icon32_file")
    private File icon32File = null;
    @JsonProperty(value="icon32_delete")
    private Boolean icon32Delete = null;
    @JsonProperty(value="icon48_file")
    private File icon48File = null;
    @JsonProperty(value="icon48_delete")
    private Boolean icon48Delete = null;
    @JsonProperty(value="icon128_file")
    private File icon128File = null;
    @JsonProperty(value="icon128_delete")
    private Boolean icon128Delete = null;
    @JsonProperty(value="logo_file")
    private File logoFile = null;
    @JsonProperty(value="logo_delete")
    private Boolean logoDelete = null;
    @JsonProperty(value="disable_2fa_with_delay")
    private Boolean disable2faWithDelay = null;
    @JsonProperty(value="ldap_password_change")
    private String ldapPasswordChange = null;
    @JsonProperty(value="ldap_password_change_confirmation")
    private String ldapPasswordChangeConfirmation = null;
    @JsonProperty(value="smtp_password")
    private String smtpPassword = null;

    public SiteBody name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Site name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SiteBody subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Schema(description="Site subdomain")
    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public SiteBody domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(description="Custom domain")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public SiteBody email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Main email for this site")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public SiteBody replyToEmail(String replyToEmail) {
        this.replyToEmail = replyToEmail;
        return this;
    }

    @Schema(description="Reply-to email for this site")
    public String getReplyToEmail() {
        return this.replyToEmail;
    }

    public void setReplyToEmail(String replyToEmail) {
        this.replyToEmail = replyToEmail;
    }

    public SiteBody allowBundleNames(Boolean allowBundleNames) {
        this.allowBundleNames = allowBundleNames;
        return this;
    }

    @Schema(description="Are manual Bundle names allowed?")
    public Boolean isAllowBundleNames() {
        return this.allowBundleNames;
    }

    public void setAllowBundleNames(Boolean allowBundleNames) {
        this.allowBundleNames = allowBundleNames;
    }

    public SiteBody bundleExpiration(Integer bundleExpiration) {
        this.bundleExpiration = bundleExpiration;
        return this;
    }

    @Schema(description="Site-wide Bundle expiration in days")
    public Integer getBundleExpiration() {
        return this.bundleExpiration;
    }

    public void setBundleExpiration(Integer bundleExpiration) {
        this.bundleExpiration = bundleExpiration;
    }

    public SiteBody overageNotify(Boolean overageNotify) {
        this.overageNotify = overageNotify;
        return this;
    }

    @Schema(description="Notify site email of overages?")
    public Boolean isOverageNotify() {
        return this.overageNotify;
    }

    public void setOverageNotify(Boolean overageNotify) {
        this.overageNotify = overageNotify;
    }

    public SiteBody welcomeEmailEnabled(Boolean welcomeEmailEnabled) {
        this.welcomeEmailEnabled = welcomeEmailEnabled;
        return this;
    }

    @Schema(description="Will the welcome email be sent to new users?")
    public Boolean isWelcomeEmailEnabled() {
        return this.welcomeEmailEnabled;
    }

    public void setWelcomeEmailEnabled(Boolean welcomeEmailEnabled) {
        this.welcomeEmailEnabled = welcomeEmailEnabled;
    }

    public SiteBody askAboutOverwrites(Boolean askAboutOverwrites) {
        this.askAboutOverwrites = askAboutOverwrites;
        return this;
    }

    @Schema(description="If false, rename conflicting files instead of asking for overwrite confirmation.  Only applies to web interface.")
    public Boolean isAskAboutOverwrites() {
        return this.askAboutOverwrites;
    }

    public void setAskAboutOverwrites(Boolean askAboutOverwrites) {
        this.askAboutOverwrites = askAboutOverwrites;
    }

    public SiteBody showRequestAccessLink(Boolean showRequestAccessLink) {
        this.showRequestAccessLink = showRequestAccessLink;
        return this;
    }

    @Schema(description="Show request access link for users without access?  Currently unused.")
    public Boolean isShowRequestAccessLink() {
        return this.showRequestAccessLink;
    }

    public void setShowRequestAccessLink(Boolean showRequestAccessLink) {
        this.showRequestAccessLink = showRequestAccessLink;
    }

    public SiteBody welcomeEmailCc(String welcomeEmailCc) {
        this.welcomeEmailCc = welcomeEmailCc;
        return this;
    }

    @Schema(description="Include this email in welcome emails if enabled")
    public String getWelcomeEmailCc() {
        return this.welcomeEmailCc;
    }

    public void setWelcomeEmailCc(String welcomeEmailCc) {
        this.welcomeEmailCc = welcomeEmailCc;
    }

    public SiteBody welcomeCustomText(String welcomeCustomText) {
        this.welcomeCustomText = welcomeCustomText;
        return this;
    }

    @Schema(description="Custom text send in user welcome email")
    public String getWelcomeCustomText() {
        return this.welcomeCustomText;
    }

    public void setWelcomeCustomText(String welcomeCustomText) {
        this.welcomeCustomText = welcomeCustomText;
    }

    public SiteBody language(String language) {
        this.language = language;
        return this;
    }

    @Schema(description="Site default language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public SiteBody windowsModeFtp(Boolean windowsModeFtp) {
        this.windowsModeFtp = windowsModeFtp;
        return this;
    }

    @Schema(description="Does FTP user Windows emulation mode?")
    public Boolean isWindowsModeFtp() {
        return this.windowsModeFtp;
    }

    public void setWindowsModeFtp(Boolean windowsModeFtp) {
        this.windowsModeFtp = windowsModeFtp;
    }

    public SiteBody defaultTimeZone(String defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
        return this;
    }

    @Schema(description="Site default time zone")
    public String getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public void setDefaultTimeZone(String defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public SiteBody desktopApp(Boolean desktopApp) {
        this.desktopApp = desktopApp;
        return this;
    }

    @Schema(description="Is the desktop app enabled?")
    public Boolean isDesktopApp() {
        return this.desktopApp;
    }

    public void setDesktopApp(Boolean desktopApp) {
        this.desktopApp = desktopApp;
    }

    public SiteBody desktopAppSessionIpPinning(Boolean desktopAppSessionIpPinning) {
        this.desktopAppSessionIpPinning = desktopAppSessionIpPinning;
        return this;
    }

    @Schema(description="Is desktop app session IP pinning enabled?")
    public Boolean isDesktopAppSessionIpPinning() {
        return this.desktopAppSessionIpPinning;
    }

    public void setDesktopAppSessionIpPinning(Boolean desktopAppSessionIpPinning) {
        this.desktopAppSessionIpPinning = desktopAppSessionIpPinning;
    }

    public SiteBody desktopAppSessionLifetime(Integer desktopAppSessionLifetime) {
        this.desktopAppSessionLifetime = desktopAppSessionLifetime;
        return this;
    }

    @Schema(description="Desktop app session lifetime (in hours)")
    public Integer getDesktopAppSessionLifetime() {
        return this.desktopAppSessionLifetime;
    }

    public void setDesktopAppSessionLifetime(Integer desktopAppSessionLifetime) {
        this.desktopAppSessionLifetime = desktopAppSessionLifetime;
    }

    public SiteBody folderPermissionsGroupsOnly(Boolean folderPermissionsGroupsOnly) {
        this.folderPermissionsGroupsOnly = folderPermissionsGroupsOnly;
        return this;
    }

    @Schema(description="If true, permissions for this site must be bound to a group (not a user). Otherwise, permissions must be bound to a user.")
    public Boolean isFolderPermissionsGroupsOnly() {
        return this.folderPermissionsGroupsOnly;
    }

    public void setFolderPermissionsGroupsOnly(Boolean folderPermissionsGroupsOnly) {
        this.folderPermissionsGroupsOnly = folderPermissionsGroupsOnly;
    }

    public SiteBody welcomeScreen(String welcomeScreen) {
        this.welcomeScreen = welcomeScreen;
        return this;
    }

    @Schema(description="Does the welcome screen appear?")
    public String getWelcomeScreen() {
        return this.welcomeScreen;
    }

    public void setWelcomeScreen(String welcomeScreen) {
        this.welcomeScreen = welcomeScreen;
    }

    public SiteBody officeIntegrationAvailable(Boolean officeIntegrationAvailable) {
        this.officeIntegrationAvailable = officeIntegrationAvailable;
        return this;
    }

    @Schema(description="Allow users to use Office for the web?")
    public Boolean isOfficeIntegrationAvailable() {
        return this.officeIntegrationAvailable;
    }

    public void setOfficeIntegrationAvailable(Boolean officeIntegrationAvailable) {
        this.officeIntegrationAvailable = officeIntegrationAvailable;
    }

    public SiteBody sessionExpiry(Double sessionExpiry) {
        this.sessionExpiry = sessionExpiry;
        return this;
    }

    @Schema(description="Session expiry in hours")
    public Double getSessionExpiry() {
        return this.sessionExpiry;
    }

    public void setSessionExpiry(Double sessionExpiry) {
        this.sessionExpiry = sessionExpiry;
    }

    public SiteBody sslRequired(Boolean sslRequired) {
        this.sslRequired = sslRequired;
        return this;
    }

    @Schema(description="Is SSL required?  Disabling this is insecure.")
    public Boolean isSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(Boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    public SiteBody tlsDisabled(Boolean tlsDisabled) {
        this.tlsDisabled = tlsDisabled;
        return this;
    }

    @Schema(description="Is TLS disabled(site setting)?")
    public Boolean isTlsDisabled() {
        return this.tlsDisabled;
    }

    public void setTlsDisabled(Boolean tlsDisabled) {
        this.tlsDisabled = tlsDisabled;
    }

    public SiteBody userLockout(Boolean userLockout) {
        this.userLockout = userLockout;
        return this;
    }

    @Schema(description="Will users be locked out after incorrect login attempts?")
    public Boolean isUserLockout() {
        return this.userLockout;
    }

    public void setUserLockout(Boolean userLockout) {
        this.userLockout = userLockout;
    }

    public SiteBody userLockoutTries(Integer userLockoutTries) {
        this.userLockoutTries = userLockoutTries;
        return this;
    }

    @Schema(description="Number of login tries within `user_lockout_within` hours before users are locked out")
    public Integer getUserLockoutTries() {
        return this.userLockoutTries;
    }

    public void setUserLockoutTries(Integer userLockoutTries) {
        this.userLockoutTries = userLockoutTries;
    }

    public SiteBody userLockoutWithin(Integer userLockoutWithin) {
        this.userLockoutWithin = userLockoutWithin;
        return this;
    }

    @Schema(description="Number of hours for user lockout window")
    public Integer getUserLockoutWithin() {
        return this.userLockoutWithin;
    }

    public void setUserLockoutWithin(Integer userLockoutWithin) {
        this.userLockoutWithin = userLockoutWithin;
    }

    public SiteBody userLockoutLockPeriod(Integer userLockoutLockPeriod) {
        this.userLockoutLockPeriod = userLockoutLockPeriod;
        return this;
    }

    @Schema(description="How many hours to lock user out for failed password?")
    public Integer getUserLockoutLockPeriod() {
        return this.userLockoutLockPeriod;
    }

    public void setUserLockoutLockPeriod(Integer userLockoutLockPeriod) {
        this.userLockoutLockPeriod = userLockoutLockPeriod;
    }

    public SiteBody includePasswordInWelcomeEmail(Boolean includePasswordInWelcomeEmail) {
        this.includePasswordInWelcomeEmail = includePasswordInWelcomeEmail;
        return this;
    }

    @Schema(description="Include password in emails to new users?")
    public Boolean isIncludePasswordInWelcomeEmail() {
        return this.includePasswordInWelcomeEmail;
    }

    public void setIncludePasswordInWelcomeEmail(Boolean includePasswordInWelcomeEmail) {
        this.includePasswordInWelcomeEmail = includePasswordInWelcomeEmail;
    }

    public SiteBody allowedCountries(String allowedCountries) {
        this.allowedCountries = allowedCountries;
        return this;
    }

    @Schema(description="Comma seperated list of allowed Country codes")
    public String getAllowedCountries() {
        return this.allowedCountries;
    }

    public void setAllowedCountries(String allowedCountries) {
        this.allowedCountries = allowedCountries;
    }

    public SiteBody allowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
        return this;
    }

    @Schema(description="List of allowed IP addresses")
    public String getAllowedIps() {
        return this.allowedIps;
    }

    public void setAllowedIps(String allowedIps) {
        this.allowedIps = allowedIps;
    }

    public SiteBody disallowedCountries(String disallowedCountries) {
        this.disallowedCountries = disallowedCountries;
        return this;
    }

    @Schema(description="Comma seperated list of disallowed Country codes")
    public String getDisallowedCountries() {
        return this.disallowedCountries;
    }

    public void setDisallowedCountries(String disallowedCountries) {
        this.disallowedCountries = disallowedCountries;
    }

    public SiteBody daysToRetainBackups(Integer daysToRetainBackups) {
        this.daysToRetainBackups = daysToRetainBackups;
        return this;
    }

    @Schema(description="Number of days to keep deleted files")
    public Integer getDaysToRetainBackups() {
        return this.daysToRetainBackups;
    }

    public void setDaysToRetainBackups(Integer daysToRetainBackups) {
        this.daysToRetainBackups = daysToRetainBackups;
    }

    public SiteBody maxPriorPasswords(Integer maxPriorPasswords) {
        this.maxPriorPasswords = maxPriorPasswords;
        return this;
    }

    @Schema(description="Number of prior passwords to disallow")
    public Integer getMaxPriorPasswords() {
        return this.maxPriorPasswords;
    }

    public void setMaxPriorPasswords(Integer maxPriorPasswords) {
        this.maxPriorPasswords = maxPriorPasswords;
    }

    public SiteBody passwordValidityDays(Integer passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
        return this;
    }

    @Schema(description="Number of days password is valid")
    public Integer getPasswordValidityDays() {
        return this.passwordValidityDays;
    }

    public void setPasswordValidityDays(Integer passwordValidityDays) {
        this.passwordValidityDays = passwordValidityDays;
    }

    public SiteBody passwordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
        return this;
    }

    @Schema(description="Shortest password length for users")
    public Integer getPasswordMinLength() {
        return this.passwordMinLength;
    }

    public void setPasswordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public SiteBody passwordRequireLetter(Boolean passwordRequireLetter) {
        this.passwordRequireLetter = passwordRequireLetter;
        return this;
    }

    @Schema(description="Require a letter in passwords?")
    public Boolean isPasswordRequireLetter() {
        return this.passwordRequireLetter;
    }

    public void setPasswordRequireLetter(Boolean passwordRequireLetter) {
        this.passwordRequireLetter = passwordRequireLetter;
    }

    public SiteBody passwordRequireMixed(Boolean passwordRequireMixed) {
        this.passwordRequireMixed = passwordRequireMixed;
        return this;
    }

    @Schema(description="Require lower and upper case letters in passwords?")
    public Boolean isPasswordRequireMixed() {
        return this.passwordRequireMixed;
    }

    public void setPasswordRequireMixed(Boolean passwordRequireMixed) {
        this.passwordRequireMixed = passwordRequireMixed;
    }

    public SiteBody passwordRequireSpecial(Boolean passwordRequireSpecial) {
        this.passwordRequireSpecial = passwordRequireSpecial;
        return this;
    }

    @Schema(description="Require special characters in password?")
    public Boolean isPasswordRequireSpecial() {
        return this.passwordRequireSpecial;
    }

    public void setPasswordRequireSpecial(Boolean passwordRequireSpecial) {
        this.passwordRequireSpecial = passwordRequireSpecial;
    }

    public SiteBody passwordRequireNumber(Boolean passwordRequireNumber) {
        this.passwordRequireNumber = passwordRequireNumber;
        return this;
    }

    @Schema(description="Require a number in passwords?")
    public Boolean isPasswordRequireNumber() {
        return this.passwordRequireNumber;
    }

    public void setPasswordRequireNumber(Boolean passwordRequireNumber) {
        this.passwordRequireNumber = passwordRequireNumber;
    }

    public SiteBody passwordRequireUnbreached(Boolean passwordRequireUnbreached) {
        this.passwordRequireUnbreached = passwordRequireUnbreached;
        return this;
    }

    @Schema(description="Require passwords that have not been previously breached? (see https://haveibeenpwned.com/)")
    public Boolean isPasswordRequireUnbreached() {
        return this.passwordRequireUnbreached;
    }

    public void setPasswordRequireUnbreached(Boolean passwordRequireUnbreached) {
        this.passwordRequireUnbreached = passwordRequireUnbreached;
    }

    public SiteBody sftpUserRootEnabled(Boolean sftpUserRootEnabled) {
        this.sftpUserRootEnabled = sftpUserRootEnabled;
        return this;
    }

    @Schema(description="Use user FTP roots also for SFTP?")
    public Boolean isSftpUserRootEnabled() {
        return this.sftpUserRootEnabled;
    }

    public void setSftpUserRootEnabled(Boolean sftpUserRootEnabled) {
        this.sftpUserRootEnabled = sftpUserRootEnabled;
    }

    public SiteBody disablePasswordReset(Boolean disablePasswordReset) {
        this.disablePasswordReset = disablePasswordReset;
        return this;
    }

    @Schema(description="Is password reset disabled?")
    public Boolean isDisablePasswordReset() {
        return this.disablePasswordReset;
    }

    public void setDisablePasswordReset(Boolean disablePasswordReset) {
        this.disablePasswordReset = disablePasswordReset;
    }

    public SiteBody immutableFiles(Boolean immutableFiles) {
        this.immutableFiles = immutableFiles;
        return this;
    }

    @Schema(description="Are files protected from modification?")
    public Boolean isImmutableFiles() {
        return this.immutableFiles;
    }

    public void setImmutableFiles(Boolean immutableFiles) {
        this.immutableFiles = immutableFiles;
    }

    public SiteBody sessionPinnedByIp(Boolean sessionPinnedByIp) {
        this.sessionPinnedByIp = sessionPinnedByIp;
        return this;
    }

    @Schema(description="Are sessions locked to the same IP? (i.e. do users need to log in again if they change IPs?)")
    public Boolean isSessionPinnedByIp() {
        return this.sessionPinnedByIp;
    }

    public void setSessionPinnedByIp(Boolean sessionPinnedByIp) {
        this.sessionPinnedByIp = sessionPinnedByIp;
    }

    public SiteBody bundlePasswordRequired(Boolean bundlePasswordRequired) {
        this.bundlePasswordRequired = bundlePasswordRequired;
        return this;
    }

    @Schema(description="Do Bundles require password protection?")
    public Boolean isBundlePasswordRequired() {
        return this.bundlePasswordRequired;
    }

    public void setBundlePasswordRequired(Boolean bundlePasswordRequired) {
        this.bundlePasswordRequired = bundlePasswordRequired;
    }

    public SiteBody bundleRequireShareRecipient(Boolean bundleRequireShareRecipient) {
        this.bundleRequireShareRecipient = bundleRequireShareRecipient;
        return this;
    }

    @Schema(description="Do Bundles require recipients for sharing?")
    public Boolean isBundleRequireShareRecipient() {
        return this.bundleRequireShareRecipient;
    }

    public void setBundleRequireShareRecipient(Boolean bundleRequireShareRecipient) {
        this.bundleRequireShareRecipient = bundleRequireShareRecipient;
    }

    public SiteBody passwordRequirementsApplyToBundles(Boolean passwordRequirementsApplyToBundles) {
        this.passwordRequirementsApplyToBundles = passwordRequirementsApplyToBundles;
        return this;
    }

    @Schema(description="Require bundles' passwords, and passwords for other items (inboxes, public shares, etc.) to conform to the same requirements as users' passwords?")
    public Boolean isPasswordRequirementsApplyToBundles() {
        return this.passwordRequirementsApplyToBundles;
    }

    public void setPasswordRequirementsApplyToBundles(Boolean passwordRequirementsApplyToBundles) {
        this.passwordRequirementsApplyToBundles = passwordRequirementsApplyToBundles;
    }

    public SiteBody optOutGlobal(Boolean optOutGlobal) {
        this.optOutGlobal = optOutGlobal;
        return this;
    }

    @Schema(description="Use servers in the USA only?")
    public Boolean isOptOutGlobal() {
        return this.optOutGlobal;
    }

    public void setOptOutGlobal(Boolean optOutGlobal) {
        this.optOutGlobal = optOutGlobal;
    }

    public SiteBody useProvidedModifiedAt(Boolean useProvidedModifiedAt) {
        this.useProvidedModifiedAt = useProvidedModifiedAt;
        return this;
    }

    @Schema(description="Allow uploaders to set `provided_modified_at` for uploaded files?")
    public Boolean isUseProvidedModifiedAt() {
        return this.useProvidedModifiedAt;
    }

    public void setUseProvidedModifiedAt(Boolean useProvidedModifiedAt) {
        this.useProvidedModifiedAt = useProvidedModifiedAt;
    }

    public SiteBody customNamespace(Boolean customNamespace) {
        this.customNamespace = customNamespace;
        return this;
    }

    @Schema(description="Is this site using a custom namespace for users?")
    public Boolean isCustomNamespace() {
        return this.customNamespace;
    }

    public void setCustomNamespace(Boolean customNamespace) {
        this.customNamespace = customNamespace;
    }

    public SiteBody disableUsersFromInactivityPeriodDays(Integer disableUsersFromInactivityPeriodDays) {
        this.disableUsersFromInactivityPeriodDays = disableUsersFromInactivityPeriodDays;
        return this;
    }

    @Schema(description="If greater than zero, users will unable to login if they do not show activity within this number of days.")
    public Integer getDisableUsersFromInactivityPeriodDays() {
        return this.disableUsersFromInactivityPeriodDays;
    }

    public void setDisableUsersFromInactivityPeriodDays(Integer disableUsersFromInactivityPeriodDays) {
        this.disableUsersFromInactivityPeriodDays = disableUsersFromInactivityPeriodDays;
    }

    public SiteBody nonSsoGroupsAllowed(Boolean nonSsoGroupsAllowed) {
        this.nonSsoGroupsAllowed = nonSsoGroupsAllowed;
        return this;
    }

    @Schema(description="If true, groups can be manually created / modified / deleted by Site Admins. Otherwise, groups can only be managed via your SSO provider.")
    public Boolean isNonSsoGroupsAllowed() {
        return this.nonSsoGroupsAllowed;
    }

    public void setNonSsoGroupsAllowed(Boolean nonSsoGroupsAllowed) {
        this.nonSsoGroupsAllowed = nonSsoGroupsAllowed;
    }

    public SiteBody nonSsoUsersAllowed(Boolean nonSsoUsersAllowed) {
        this.nonSsoUsersAllowed = nonSsoUsersAllowed;
        return this;
    }

    @Schema(description="If true, users can be manually created / modified / deleted by Site Admins. Otherwise, users can only be managed via your SSO provider.")
    public Boolean isNonSsoUsersAllowed() {
        return this.nonSsoUsersAllowed;
    }

    public void setNonSsoUsersAllowed(Boolean nonSsoUsersAllowed) {
        this.nonSsoUsersAllowed = nonSsoUsersAllowed;
    }

    public SiteBody sharingEnabled(Boolean sharingEnabled) {
        this.sharingEnabled = sharingEnabled;
        return this;
    }

    @Schema(description="Allow bundle creation")
    public Boolean isSharingEnabled() {
        return this.sharingEnabled;
    }

    public void setSharingEnabled(Boolean sharingEnabled) {
        this.sharingEnabled = sharingEnabled;
    }

    public SiteBody userRequestsEnabled(Boolean userRequestsEnabled) {
        this.userRequestsEnabled = userRequestsEnabled;
        return this;
    }

    @Schema(description="Enable User Requests feature")
    public Boolean isUserRequestsEnabled() {
        return this.userRequestsEnabled;
    }

    public void setUserRequestsEnabled(Boolean userRequestsEnabled) {
        this.userRequestsEnabled = userRequestsEnabled;
    }

    public SiteBody allowed2faMethodSms(Boolean allowed2faMethodSms) {
        this.allowed2faMethodSms = allowed2faMethodSms;
        return this;
    }

    @Schema(description="Is SMS two factor authentication allowed?")
    public Boolean isAllowed2faMethodSms() {
        return this.allowed2faMethodSms;
    }

    public void setAllowed2faMethodSms(Boolean allowed2faMethodSms) {
        this.allowed2faMethodSms = allowed2faMethodSms;
    }

    public SiteBody allowed2faMethodU2f(Boolean allowed2faMethodU2f) {
        this.allowed2faMethodU2f = allowed2faMethodU2f;
        return this;
    }

    @Schema(description="Is U2F two factor authentication allowed?")
    public Boolean isAllowed2faMethodU2f() {
        return this.allowed2faMethodU2f;
    }

    public void setAllowed2faMethodU2f(Boolean allowed2faMethodU2f) {
        this.allowed2faMethodU2f = allowed2faMethodU2f;
    }

    public SiteBody allowed2faMethodTotp(Boolean allowed2faMethodTotp) {
        this.allowed2faMethodTotp = allowed2faMethodTotp;
        return this;
    }

    @Schema(description="Is TOTP two factor authentication allowed?")
    public Boolean isAllowed2faMethodTotp() {
        return this.allowed2faMethodTotp;
    }

    public void setAllowed2faMethodTotp(Boolean allowed2faMethodTotp) {
        this.allowed2faMethodTotp = allowed2faMethodTotp;
    }

    public SiteBody allowed2faMethodYubi(Boolean allowed2faMethodYubi) {
        this.allowed2faMethodYubi = allowed2faMethodYubi;
        return this;
    }

    @Schema(description="Is yubikey two factor authentication allowed?")
    public Boolean isAllowed2faMethodYubi() {
        return this.allowed2faMethodYubi;
    }

    public void setAllowed2faMethodYubi(Boolean allowed2faMethodYubi) {
        this.allowed2faMethodYubi = allowed2faMethodYubi;
    }

    public SiteBody require2fa(Boolean require2fa) {
        this.require2fa = require2fa;
        return this;
    }

    @Schema(description="Require two-factor authentication for all users?")
    public Boolean isRequire2fa() {
        return this.require2fa;
    }

    public void setRequire2fa(Boolean require2fa) {
        this.require2fa = require2fa;
    }

    public SiteBody require2faUserType(String require2faUserType) {
        this.require2faUserType = require2faUserType;
        return this;
    }

    @Schema(description="What type of user is required to use two-factor authentication (when require_2fa is set to `true` for this site)?")
    public String getRequire2faUserType() {
        return this.require2faUserType;
    }

    public void setRequire2faUserType(String require2faUserType) {
        this.require2faUserType = require2faUserType;
    }

    public SiteBody color2Top(String color2Top) {
        this.color2Top = color2Top;
        return this;
    }

    @Schema(description="Top bar background color")
    public String getColor2Top() {
        return this.color2Top;
    }

    public void setColor2Top(String color2Top) {
        this.color2Top = color2Top;
    }

    public SiteBody color2Left(String color2Left) {
        this.color2Left = color2Left;
        return this;
    }

    @Schema(description="Page link and button color")
    public String getColor2Left() {
        return this.color2Left;
    }

    public void setColor2Left(String color2Left) {
        this.color2Left = color2Left;
    }

    public SiteBody color2Link(String color2Link) {
        this.color2Link = color2Link;
        return this;
    }

    @Schema(description="Top bar link color")
    public String getColor2Link() {
        return this.color2Link;
    }

    public void setColor2Link(String color2Link) {
        this.color2Link = color2Link;
    }

    public SiteBody color2Text(String color2Text) {
        this.color2Text = color2Text;
        return this;
    }

    @Schema(description="Page link and button color")
    public String getColor2Text() {
        return this.color2Text;
    }

    public void setColor2Text(String color2Text) {
        this.color2Text = color2Text;
    }

    public SiteBody color2TopText(String color2TopText) {
        this.color2TopText = color2TopText;
        return this;
    }

    @Schema(description="Top bar text color")
    public String getColor2TopText() {
        return this.color2TopText;
    }

    public void setColor2TopText(String color2TopText) {
        this.color2TopText = color2TopText;
    }

    public SiteBody siteHeader(String siteHeader) {
        this.siteHeader = siteHeader;
        return this;
    }

    @Schema(description="Custom site header text")
    public String getSiteHeader() {
        return this.siteHeader;
    }

    public void setSiteHeader(String siteHeader) {
        this.siteHeader = siteHeader;
    }

    public SiteBody siteFooter(String siteFooter) {
        this.siteFooter = siteFooter;
        return this;
    }

    @Schema(description="Custom site footer text")
    public String getSiteFooter() {
        return this.siteFooter;
    }

    public void setSiteFooter(String siteFooter) {
        this.siteFooter = siteFooter;
    }

    public SiteBody loginHelpText(String loginHelpText) {
        this.loginHelpText = loginHelpText;
        return this;
    }

    @Schema(description="Login help text")
    public String getLoginHelpText() {
        return this.loginHelpText;
    }

    public void setLoginHelpText(String loginHelpText) {
        this.loginHelpText = loginHelpText;
    }

    public SiteBody smtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
        return this;
    }

    @Schema(description="SMTP server hostname or IP")
    public String getSmtpAddress() {
        return this.smtpAddress;
    }

    public void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }

    public SiteBody smtpAuthentication(String smtpAuthentication) {
        this.smtpAuthentication = smtpAuthentication;
        return this;
    }

    @Schema(description="SMTP server authentication type")
    public String getSmtpAuthentication() {
        return this.smtpAuthentication;
    }

    public void setSmtpAuthentication(String smtpAuthentication) {
        this.smtpAuthentication = smtpAuthentication;
    }

    public SiteBody smtpFrom(String smtpFrom) {
        this.smtpFrom = smtpFrom;
        return this;
    }

    @Schema(description="From address to use when mailing through custom SMTP")
    public String getSmtpFrom() {
        return this.smtpFrom;
    }

    public void setSmtpFrom(String smtpFrom) {
        this.smtpFrom = smtpFrom;
    }

    public SiteBody smtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
        return this;
    }

    @Schema(description="SMTP server username")
    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
    }

    public SiteBody smtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
        return this;
    }

    @Schema(description="SMTP server port")
    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    public SiteBody ldapEnabled(Boolean ldapEnabled) {
        this.ldapEnabled = ldapEnabled;
        return this;
    }

    @Schema(description="Main LDAP setting: is LDAP enabled?")
    public Boolean isLdapEnabled() {
        return this.ldapEnabled;
    }

    public void setLdapEnabled(Boolean ldapEnabled) {
        this.ldapEnabled = ldapEnabled;
    }

    public SiteBody ldapType(String ldapType) {
        this.ldapType = ldapType;
        return this;
    }

    @Schema(description="LDAP type")
    public String getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(String ldapType) {
        this.ldapType = ldapType;
    }

    public SiteBody ldapHost(String ldapHost) {
        this.ldapHost = ldapHost;
        return this;
    }

    @Schema(description="LDAP host")
    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public SiteBody ldapHost2(String ldapHost2) {
        this.ldapHost2 = ldapHost2;
        return this;
    }

    @Schema(description="LDAP backup host")
    public String getLdapHost2() {
        return this.ldapHost2;
    }

    public void setLdapHost2(String ldapHost2) {
        this.ldapHost2 = ldapHost2;
    }

    public SiteBody ldapHost3(String ldapHost3) {
        this.ldapHost3 = ldapHost3;
        return this;
    }

    @Schema(description="LDAP backup host")
    public String getLdapHost3() {
        return this.ldapHost3;
    }

    public void setLdapHost3(String ldapHost3) {
        this.ldapHost3 = ldapHost3;
    }

    public SiteBody ldapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
        return this;
    }

    @Schema(description="LDAP port")
    public Integer getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
    }

    public SiteBody ldapSecure(Boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
        return this;
    }

    @Schema(description="Use secure LDAP?")
    public Boolean isLdapSecure() {
        return this.ldapSecure;
    }

    public void setLdapSecure(Boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
    }

    public SiteBody ldapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
        return this;
    }

    @Schema(description="Username for signing in to LDAP server.")
    public String getLdapUsername() {
        return this.ldapUsername;
    }

    public void setLdapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
    }

    public SiteBody ldapUsernameField(String ldapUsernameField) {
        this.ldapUsernameField = ldapUsernameField;
        return this;
    }

    @Schema(description="LDAP username field")
    public String getLdapUsernameField() {
        return this.ldapUsernameField;
    }

    public void setLdapUsernameField(String ldapUsernameField) {
        this.ldapUsernameField = ldapUsernameField;
    }

    public SiteBody ldapDomain(String ldapDomain) {
        this.ldapDomain = ldapDomain;
        return this;
    }

    @Schema(description="Domain name that will be appended to usernames")
    public String getLdapDomain() {
        return this.ldapDomain;
    }

    public void setLdapDomain(String ldapDomain) {
        this.ldapDomain = ldapDomain;
    }

    public SiteBody ldapUserAction(String ldapUserAction) {
        this.ldapUserAction = ldapUserAction;
        return this;
    }

    @Schema(description="Should we sync users from LDAP server?")
    public String getLdapUserAction() {
        return this.ldapUserAction;
    }

    public void setLdapUserAction(String ldapUserAction) {
        this.ldapUserAction = ldapUserAction;
    }

    public SiteBody ldapGroupAction(String ldapGroupAction) {
        this.ldapGroupAction = ldapGroupAction;
        return this;
    }

    @Schema(description="Should we sync groups from LDAP server?")
    public String getLdapGroupAction() {
        return this.ldapGroupAction;
    }

    public void setLdapGroupAction(String ldapGroupAction) {
        this.ldapGroupAction = ldapGroupAction;
    }

    public SiteBody ldapUserIncludeGroups(String ldapUserIncludeGroups) {
        this.ldapUserIncludeGroups = ldapUserIncludeGroups;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) - if provided, only users in these groups will be added or synced.")
    public String getLdapUserIncludeGroups() {
        return this.ldapUserIncludeGroups;
    }

    public void setLdapUserIncludeGroups(String ldapUserIncludeGroups) {
        this.ldapUserIncludeGroups = ldapUserIncludeGroups;
    }

    public SiteBody ldapGroupExclusion(String ldapGroupExclusion) {
        this.ldapGroupExclusion = ldapGroupExclusion;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) to exclude when syncing.")
    public String getLdapGroupExclusion() {
        return this.ldapGroupExclusion;
    }

    public void setLdapGroupExclusion(String ldapGroupExclusion) {
        this.ldapGroupExclusion = ldapGroupExclusion;
    }

    public SiteBody ldapGroupInclusion(String ldapGroupInclusion) {
        this.ldapGroupInclusion = ldapGroupInclusion;
        return this;
    }

    @Schema(description="Comma or newline separated list of group names (with optional wildcards) to include when syncing.")
    public String getLdapGroupInclusion() {
        return this.ldapGroupInclusion;
    }

    public void setLdapGroupInclusion(String ldapGroupInclusion) {
        this.ldapGroupInclusion = ldapGroupInclusion;
    }

    public SiteBody ldapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
        return this;
    }

    @Schema(description="Base DN for looking up users in LDAP server")
    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    public void setLdapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
    }

    public SiteBody icon16File(File icon16File) {
        this.icon16File = icon16File;
        return this;
    }

    @Schema(description="")
    public File getIcon16File() {
        return this.icon16File;
    }

    public void setIcon16File(File icon16File) {
        this.icon16File = icon16File;
    }

    public SiteBody icon16Delete(Boolean icon16Delete) {
        this.icon16Delete = icon16Delete;
        return this;
    }

    @Schema(description="If true, will delete the file stored in icon16")
    public Boolean isIcon16Delete() {
        return this.icon16Delete;
    }

    public void setIcon16Delete(Boolean icon16Delete) {
        this.icon16Delete = icon16Delete;
    }

    public SiteBody icon32File(File icon32File) {
        this.icon32File = icon32File;
        return this;
    }

    @Schema(description="")
    public File getIcon32File() {
        return this.icon32File;
    }

    public void setIcon32File(File icon32File) {
        this.icon32File = icon32File;
    }

    public SiteBody icon32Delete(Boolean icon32Delete) {
        this.icon32Delete = icon32Delete;
        return this;
    }

    @Schema(description="If true, will delete the file stored in icon32")
    public Boolean isIcon32Delete() {
        return this.icon32Delete;
    }

    public void setIcon32Delete(Boolean icon32Delete) {
        this.icon32Delete = icon32Delete;
    }

    public SiteBody icon48File(File icon48File) {
        this.icon48File = icon48File;
        return this;
    }

    @Schema(description="")
    public File getIcon48File() {
        return this.icon48File;
    }

    public void setIcon48File(File icon48File) {
        this.icon48File = icon48File;
    }

    public SiteBody icon48Delete(Boolean icon48Delete) {
        this.icon48Delete = icon48Delete;
        return this;
    }

    @Schema(description="If true, will delete the file stored in icon48")
    public Boolean isIcon48Delete() {
        return this.icon48Delete;
    }

    public void setIcon48Delete(Boolean icon48Delete) {
        this.icon48Delete = icon48Delete;
    }

    public SiteBody icon128File(File icon128File) {
        this.icon128File = icon128File;
        return this;
    }

    @Schema(description="")
    public File getIcon128File() {
        return this.icon128File;
    }

    public void setIcon128File(File icon128File) {
        this.icon128File = icon128File;
    }

    public SiteBody icon128Delete(Boolean icon128Delete) {
        this.icon128Delete = icon128Delete;
        return this;
    }

    @Schema(description="If true, will delete the file stored in icon128")
    public Boolean isIcon128Delete() {
        return this.icon128Delete;
    }

    public void setIcon128Delete(Boolean icon128Delete) {
        this.icon128Delete = icon128Delete;
    }

    public SiteBody logoFile(File logoFile) {
        this.logoFile = logoFile;
        return this;
    }

    @Schema(description="")
    public File getLogoFile() {
        return this.logoFile;
    }

    public void setLogoFile(File logoFile) {
        this.logoFile = logoFile;
    }

    public SiteBody logoDelete(Boolean logoDelete) {
        this.logoDelete = logoDelete;
        return this;
    }

    @Schema(description="If true, will delete the file stored in logo")
    public Boolean isLogoDelete() {
        return this.logoDelete;
    }

    public void setLogoDelete(Boolean logoDelete) {
        this.logoDelete = logoDelete;
    }

    public SiteBody disable2faWithDelay(Boolean disable2faWithDelay) {
        this.disable2faWithDelay = disable2faWithDelay;
        return this;
    }

    @Schema(description="If set to true, we will begin the process of disabling 2FA on this site.")
    public Boolean isDisable2faWithDelay() {
        return this.disable2faWithDelay;
    }

    public void setDisable2faWithDelay(Boolean disable2faWithDelay) {
        this.disable2faWithDelay = disable2faWithDelay;
    }

    public SiteBody ldapPasswordChange(String ldapPasswordChange) {
        this.ldapPasswordChange = ldapPasswordChange;
        return this;
    }

    @Schema(description="New LDAP password.")
    public String getLdapPasswordChange() {
        return this.ldapPasswordChange;
    }

    public void setLdapPasswordChange(String ldapPasswordChange) {
        this.ldapPasswordChange = ldapPasswordChange;
    }

    public SiteBody ldapPasswordChangeConfirmation(String ldapPasswordChangeConfirmation) {
        this.ldapPasswordChangeConfirmation = ldapPasswordChangeConfirmation;
        return this;
    }

    @Schema(description="Confirm new LDAP password.")
    public String getLdapPasswordChangeConfirmation() {
        return this.ldapPasswordChangeConfirmation;
    }

    public void setLdapPasswordChangeConfirmation(String ldapPasswordChangeConfirmation) {
        this.ldapPasswordChangeConfirmation = ldapPasswordChangeConfirmation;
    }

    public SiteBody smtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
        return this;
    }

    @Schema(description="Password for SMTP server.")
    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteBody siteBody = (SiteBody)o;
        return Objects.equals(this.name, siteBody.name) && Objects.equals(this.subdomain, siteBody.subdomain) && Objects.equals(this.domain, siteBody.domain) && Objects.equals(this.email, siteBody.email) && Objects.equals(this.replyToEmail, siteBody.replyToEmail) && Objects.equals(this.allowBundleNames, siteBody.allowBundleNames) && Objects.equals(this.bundleExpiration, siteBody.bundleExpiration) && Objects.equals(this.overageNotify, siteBody.overageNotify) && Objects.equals(this.welcomeEmailEnabled, siteBody.welcomeEmailEnabled) && Objects.equals(this.askAboutOverwrites, siteBody.askAboutOverwrites) && Objects.equals(this.showRequestAccessLink, siteBody.showRequestAccessLink) && Objects.equals(this.welcomeEmailCc, siteBody.welcomeEmailCc) && Objects.equals(this.welcomeCustomText, siteBody.welcomeCustomText) && Objects.equals(this.language, siteBody.language) && Objects.equals(this.windowsModeFtp, siteBody.windowsModeFtp) && Objects.equals(this.defaultTimeZone, siteBody.defaultTimeZone) && Objects.equals(this.desktopApp, siteBody.desktopApp) && Objects.equals(this.desktopAppSessionIpPinning, siteBody.desktopAppSessionIpPinning) && Objects.equals(this.desktopAppSessionLifetime, siteBody.desktopAppSessionLifetime) && Objects.equals(this.folderPermissionsGroupsOnly, siteBody.folderPermissionsGroupsOnly) && Objects.equals(this.welcomeScreen, siteBody.welcomeScreen) && Objects.equals(this.officeIntegrationAvailable, siteBody.officeIntegrationAvailable) && Objects.equals(this.sessionExpiry, siteBody.sessionExpiry) && Objects.equals(this.sslRequired, siteBody.sslRequired) && Objects.equals(this.tlsDisabled, siteBody.tlsDisabled) && Objects.equals(this.userLockout, siteBody.userLockout) && Objects.equals(this.userLockoutTries, siteBody.userLockoutTries) && Objects.equals(this.userLockoutWithin, siteBody.userLockoutWithin) && Objects.equals(this.userLockoutLockPeriod, siteBody.userLockoutLockPeriod) && Objects.equals(this.includePasswordInWelcomeEmail, siteBody.includePasswordInWelcomeEmail) && Objects.equals(this.allowedCountries, siteBody.allowedCountries) && Objects.equals(this.allowedIps, siteBody.allowedIps) && Objects.equals(this.disallowedCountries, siteBody.disallowedCountries) && Objects.equals(this.daysToRetainBackups, siteBody.daysToRetainBackups) && Objects.equals(this.maxPriorPasswords, siteBody.maxPriorPasswords) && Objects.equals(this.passwordValidityDays, siteBody.passwordValidityDays) && Objects.equals(this.passwordMinLength, siteBody.passwordMinLength) && Objects.equals(this.passwordRequireLetter, siteBody.passwordRequireLetter) && Objects.equals(this.passwordRequireMixed, siteBody.passwordRequireMixed) && Objects.equals(this.passwordRequireSpecial, siteBody.passwordRequireSpecial) && Objects.equals(this.passwordRequireNumber, siteBody.passwordRequireNumber) && Objects.equals(this.passwordRequireUnbreached, siteBody.passwordRequireUnbreached) && Objects.equals(this.sftpUserRootEnabled, siteBody.sftpUserRootEnabled) && Objects.equals(this.disablePasswordReset, siteBody.disablePasswordReset) && Objects.equals(this.immutableFiles, siteBody.immutableFiles) && Objects.equals(this.sessionPinnedByIp, siteBody.sessionPinnedByIp) && Objects.equals(this.bundlePasswordRequired, siteBody.bundlePasswordRequired) && Objects.equals(this.bundleRequireShareRecipient, siteBody.bundleRequireShareRecipient) && Objects.equals(this.passwordRequirementsApplyToBundles, siteBody.passwordRequirementsApplyToBundles) && Objects.equals(this.optOutGlobal, siteBody.optOutGlobal) && Objects.equals(this.useProvidedModifiedAt, siteBody.useProvidedModifiedAt) && Objects.equals(this.customNamespace, siteBody.customNamespace) && Objects.equals(this.disableUsersFromInactivityPeriodDays, siteBody.disableUsersFromInactivityPeriodDays) && Objects.equals(this.nonSsoGroupsAllowed, siteBody.nonSsoGroupsAllowed) && Objects.equals(this.nonSsoUsersAllowed, siteBody.nonSsoUsersAllowed) && Objects.equals(this.sharingEnabled, siteBody.sharingEnabled) && Objects.equals(this.userRequestsEnabled, siteBody.userRequestsEnabled) && Objects.equals(this.allowed2faMethodSms, siteBody.allowed2faMethodSms) && Objects.equals(this.allowed2faMethodU2f, siteBody.allowed2faMethodU2f) && Objects.equals(this.allowed2faMethodTotp, siteBody.allowed2faMethodTotp) && Objects.equals(this.allowed2faMethodYubi, siteBody.allowed2faMethodYubi) && Objects.equals(this.require2fa, siteBody.require2fa) && Objects.equals(this.require2faUserType, siteBody.require2faUserType) && Objects.equals(this.color2Top, siteBody.color2Top) && Objects.equals(this.color2Left, siteBody.color2Left) && Objects.equals(this.color2Link, siteBody.color2Link) && Objects.equals(this.color2Text, siteBody.color2Text) && Objects.equals(this.color2TopText, siteBody.color2TopText) && Objects.equals(this.siteHeader, siteBody.siteHeader) && Objects.equals(this.siteFooter, siteBody.siteFooter) && Objects.equals(this.loginHelpText, siteBody.loginHelpText) && Objects.equals(this.smtpAddress, siteBody.smtpAddress) && Objects.equals(this.smtpAuthentication, siteBody.smtpAuthentication) && Objects.equals(this.smtpFrom, siteBody.smtpFrom) && Objects.equals(this.smtpUsername, siteBody.smtpUsername) && Objects.equals(this.smtpPort, siteBody.smtpPort) && Objects.equals(this.ldapEnabled, siteBody.ldapEnabled) && Objects.equals(this.ldapType, siteBody.ldapType) && Objects.equals(this.ldapHost, siteBody.ldapHost) && Objects.equals(this.ldapHost2, siteBody.ldapHost2) && Objects.equals(this.ldapHost3, siteBody.ldapHost3) && Objects.equals(this.ldapPort, siteBody.ldapPort) && Objects.equals(this.ldapSecure, siteBody.ldapSecure) && Objects.equals(this.ldapUsername, siteBody.ldapUsername) && Objects.equals(this.ldapUsernameField, siteBody.ldapUsernameField) && Objects.equals(this.ldapDomain, siteBody.ldapDomain) && Objects.equals(this.ldapUserAction, siteBody.ldapUserAction) && Objects.equals(this.ldapGroupAction, siteBody.ldapGroupAction) && Objects.equals(this.ldapUserIncludeGroups, siteBody.ldapUserIncludeGroups) && Objects.equals(this.ldapGroupExclusion, siteBody.ldapGroupExclusion) && Objects.equals(this.ldapGroupInclusion, siteBody.ldapGroupInclusion) && Objects.equals(this.ldapBaseDn, siteBody.ldapBaseDn) && Objects.equals(this.icon16File, siteBody.icon16File) && Objects.equals(this.icon16Delete, siteBody.icon16Delete) && Objects.equals(this.icon32File, siteBody.icon32File) && Objects.equals(this.icon32Delete, siteBody.icon32Delete) && Objects.equals(this.icon48File, siteBody.icon48File) && Objects.equals(this.icon48Delete, siteBody.icon48Delete) && Objects.equals(this.icon128File, siteBody.icon128File) && Objects.equals(this.icon128Delete, siteBody.icon128Delete) && Objects.equals(this.logoFile, siteBody.logoFile) && Objects.equals(this.logoDelete, siteBody.logoDelete) && Objects.equals(this.disable2faWithDelay, siteBody.disable2faWithDelay) && Objects.equals(this.ldapPasswordChange, siteBody.ldapPasswordChange) && Objects.equals(this.ldapPasswordChangeConfirmation, siteBody.ldapPasswordChangeConfirmation) && Objects.equals(this.smtpPassword, siteBody.smtpPassword);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.subdomain, this.domain, this.email, this.replyToEmail, this.allowBundleNames, this.bundleExpiration, this.overageNotify, this.welcomeEmailEnabled, this.askAboutOverwrites, this.showRequestAccessLink, this.welcomeEmailCc, this.welcomeCustomText, this.language, this.windowsModeFtp, this.defaultTimeZone, this.desktopApp, this.desktopAppSessionIpPinning, this.desktopAppSessionLifetime, this.folderPermissionsGroupsOnly, this.welcomeScreen, this.officeIntegrationAvailable, this.sessionExpiry, this.sslRequired, this.tlsDisabled, this.userLockout, this.userLockoutTries, this.userLockoutWithin, this.userLockoutLockPeriod, this.includePasswordInWelcomeEmail, this.allowedCountries, this.allowedIps, this.disallowedCountries, this.daysToRetainBackups, this.maxPriorPasswords, this.passwordValidityDays, this.passwordMinLength, this.passwordRequireLetter, this.passwordRequireMixed, this.passwordRequireSpecial, this.passwordRequireNumber, this.passwordRequireUnbreached, this.sftpUserRootEnabled, this.disablePasswordReset, this.immutableFiles, this.sessionPinnedByIp, this.bundlePasswordRequired, this.bundleRequireShareRecipient, this.passwordRequirementsApplyToBundles, this.optOutGlobal, this.useProvidedModifiedAt, this.customNamespace, this.disableUsersFromInactivityPeriodDays, this.nonSsoGroupsAllowed, this.nonSsoUsersAllowed, this.sharingEnabled, this.userRequestsEnabled, this.allowed2faMethodSms, this.allowed2faMethodU2f, this.allowed2faMethodTotp, this.allowed2faMethodYubi, this.require2fa, this.require2faUserType, this.color2Top, this.color2Left, this.color2Link, this.color2Text, this.color2TopText, this.siteHeader, this.siteFooter, this.loginHelpText, this.smtpAddress, this.smtpAuthentication, this.smtpFrom, this.smtpUsername, this.smtpPort, this.ldapEnabled, this.ldapType, this.ldapHost, this.ldapHost2, this.ldapHost3, this.ldapPort, this.ldapSecure, this.ldapUsername, this.ldapUsernameField, this.ldapDomain, this.ldapUserAction, this.ldapGroupAction, this.ldapUserIncludeGroups, this.ldapGroupExclusion, this.ldapGroupInclusion, this.ldapBaseDn, Objects.hashCode(this.icon16File), this.icon16Delete, Objects.hashCode(this.icon32File), this.icon32Delete, Objects.hashCode(this.icon48File), this.icon48Delete, Objects.hashCode(this.icon128File), this.icon128Delete, Objects.hashCode(this.logoFile), this.logoDelete, this.disable2faWithDelay, this.ldapPasswordChange, this.ldapPasswordChangeConfirmation, this.smtpPassword);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SiteBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subdomain: ").append(this.toIndentedString(this.subdomain)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    replyToEmail: ").append(this.toIndentedString(this.replyToEmail)).append("\n");
        sb.append("    allowBundleNames: ").append(this.toIndentedString(this.allowBundleNames)).append("\n");
        sb.append("    bundleExpiration: ").append(this.toIndentedString(this.bundleExpiration)).append("\n");
        sb.append("    overageNotify: ").append(this.toIndentedString(this.overageNotify)).append("\n");
        sb.append("    welcomeEmailEnabled: ").append(this.toIndentedString(this.welcomeEmailEnabled)).append("\n");
        sb.append("    askAboutOverwrites: ").append(this.toIndentedString(this.askAboutOverwrites)).append("\n");
        sb.append("    showRequestAccessLink: ").append(this.toIndentedString(this.showRequestAccessLink)).append("\n");
        sb.append("    welcomeEmailCc: ").append(this.toIndentedString(this.welcomeEmailCc)).append("\n");
        sb.append("    welcomeCustomText: ").append(this.toIndentedString(this.welcomeCustomText)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    windowsModeFtp: ").append(this.toIndentedString(this.windowsModeFtp)).append("\n");
        sb.append("    defaultTimeZone: ").append(this.toIndentedString(this.defaultTimeZone)).append("\n");
        sb.append("    desktopApp: ").append(this.toIndentedString(this.desktopApp)).append("\n");
        sb.append("    desktopAppSessionIpPinning: ").append(this.toIndentedString(this.desktopAppSessionIpPinning)).append("\n");
        sb.append("    desktopAppSessionLifetime: ").append(this.toIndentedString(this.desktopAppSessionLifetime)).append("\n");
        sb.append("    folderPermissionsGroupsOnly: ").append(this.toIndentedString(this.folderPermissionsGroupsOnly)).append("\n");
        sb.append("    welcomeScreen: ").append(this.toIndentedString(this.welcomeScreen)).append("\n");
        sb.append("    officeIntegrationAvailable: ").append(this.toIndentedString(this.officeIntegrationAvailable)).append("\n");
        sb.append("    sessionExpiry: ").append(this.toIndentedString(this.sessionExpiry)).append("\n");
        sb.append("    sslRequired: ").append(this.toIndentedString(this.sslRequired)).append("\n");
        sb.append("    tlsDisabled: ").append(this.toIndentedString(this.tlsDisabled)).append("\n");
        sb.append("    userLockout: ").append(this.toIndentedString(this.userLockout)).append("\n");
        sb.append("    userLockoutTries: ").append(this.toIndentedString(this.userLockoutTries)).append("\n");
        sb.append("    userLockoutWithin: ").append(this.toIndentedString(this.userLockoutWithin)).append("\n");
        sb.append("    userLockoutLockPeriod: ").append(this.toIndentedString(this.userLockoutLockPeriod)).append("\n");
        sb.append("    includePasswordInWelcomeEmail: ").append(this.toIndentedString(this.includePasswordInWelcomeEmail)).append("\n");
        sb.append("    allowedCountries: ").append(this.toIndentedString(this.allowedCountries)).append("\n");
        sb.append("    allowedIps: ").append(this.toIndentedString(this.allowedIps)).append("\n");
        sb.append("    disallowedCountries: ").append(this.toIndentedString(this.disallowedCountries)).append("\n");
        sb.append("    daysToRetainBackups: ").append(this.toIndentedString(this.daysToRetainBackups)).append("\n");
        sb.append("    maxPriorPasswords: ").append(this.toIndentedString(this.maxPriorPasswords)).append("\n");
        sb.append("    passwordValidityDays: ").append(this.toIndentedString(this.passwordValidityDays)).append("\n");
        sb.append("    passwordMinLength: ").append(this.toIndentedString(this.passwordMinLength)).append("\n");
        sb.append("    passwordRequireLetter: ").append(this.toIndentedString(this.passwordRequireLetter)).append("\n");
        sb.append("    passwordRequireMixed: ").append(this.toIndentedString(this.passwordRequireMixed)).append("\n");
        sb.append("    passwordRequireSpecial: ").append(this.toIndentedString(this.passwordRequireSpecial)).append("\n");
        sb.append("    passwordRequireNumber: ").append(this.toIndentedString(this.passwordRequireNumber)).append("\n");
        sb.append("    passwordRequireUnbreached: ").append(this.toIndentedString(this.passwordRequireUnbreached)).append("\n");
        sb.append("    sftpUserRootEnabled: ").append(this.toIndentedString(this.sftpUserRootEnabled)).append("\n");
        sb.append("    disablePasswordReset: ").append(this.toIndentedString(this.disablePasswordReset)).append("\n");
        sb.append("    immutableFiles: ").append(this.toIndentedString(this.immutableFiles)).append("\n");
        sb.append("    sessionPinnedByIp: ").append(this.toIndentedString(this.sessionPinnedByIp)).append("\n");
        sb.append("    bundlePasswordRequired: ").append(this.toIndentedString(this.bundlePasswordRequired)).append("\n");
        sb.append("    bundleRequireShareRecipient: ").append(this.toIndentedString(this.bundleRequireShareRecipient)).append("\n");
        sb.append("    passwordRequirementsApplyToBundles: ").append(this.toIndentedString(this.passwordRequirementsApplyToBundles)).append("\n");
        sb.append("    optOutGlobal: ").append(this.toIndentedString(this.optOutGlobal)).append("\n");
        sb.append("    useProvidedModifiedAt: ").append(this.toIndentedString(this.useProvidedModifiedAt)).append("\n");
        sb.append("    customNamespace: ").append(this.toIndentedString(this.customNamespace)).append("\n");
        sb.append("    disableUsersFromInactivityPeriodDays: ").append(this.toIndentedString(this.disableUsersFromInactivityPeriodDays)).append("\n");
        sb.append("    nonSsoGroupsAllowed: ").append(this.toIndentedString(this.nonSsoGroupsAllowed)).append("\n");
        sb.append("    nonSsoUsersAllowed: ").append(this.toIndentedString(this.nonSsoUsersAllowed)).append("\n");
        sb.append("    sharingEnabled: ").append(this.toIndentedString(this.sharingEnabled)).append("\n");
        sb.append("    userRequestsEnabled: ").append(this.toIndentedString(this.userRequestsEnabled)).append("\n");
        sb.append("    allowed2faMethodSms: ").append(this.toIndentedString(this.allowed2faMethodSms)).append("\n");
        sb.append("    allowed2faMethodU2f: ").append(this.toIndentedString(this.allowed2faMethodU2f)).append("\n");
        sb.append("    allowed2faMethodTotp: ").append(this.toIndentedString(this.allowed2faMethodTotp)).append("\n");
        sb.append("    allowed2faMethodYubi: ").append(this.toIndentedString(this.allowed2faMethodYubi)).append("\n");
        sb.append("    require2fa: ").append(this.toIndentedString(this.require2fa)).append("\n");
        sb.append("    require2faUserType: ").append(this.toIndentedString(this.require2faUserType)).append("\n");
        sb.append("    color2Top: ").append(this.toIndentedString(this.color2Top)).append("\n");
        sb.append("    color2Left: ").append(this.toIndentedString(this.color2Left)).append("\n");
        sb.append("    color2Link: ").append(this.toIndentedString(this.color2Link)).append("\n");
        sb.append("    color2Text: ").append(this.toIndentedString(this.color2Text)).append("\n");
        sb.append("    color2TopText: ").append(this.toIndentedString(this.color2TopText)).append("\n");
        sb.append("    siteHeader: ").append(this.toIndentedString(this.siteHeader)).append("\n");
        sb.append("    siteFooter: ").append(this.toIndentedString(this.siteFooter)).append("\n");
        sb.append("    loginHelpText: ").append(this.toIndentedString(this.loginHelpText)).append("\n");
        sb.append("    smtpAddress: ").append(this.toIndentedString(this.smtpAddress)).append("\n");
        sb.append("    smtpAuthentication: ").append(this.toIndentedString(this.smtpAuthentication)).append("\n");
        sb.append("    smtpFrom: ").append(this.toIndentedString(this.smtpFrom)).append("\n");
        sb.append("    smtpUsername: ").append(this.toIndentedString(this.smtpUsername)).append("\n");
        sb.append("    smtpPort: ").append(this.toIndentedString(this.smtpPort)).append("\n");
        sb.append("    ldapEnabled: ").append(this.toIndentedString(this.ldapEnabled)).append("\n");
        sb.append("    ldapType: ").append(this.toIndentedString(this.ldapType)).append("\n");
        sb.append("    ldapHost: ").append(this.toIndentedString(this.ldapHost)).append("\n");
        sb.append("    ldapHost2: ").append(this.toIndentedString(this.ldapHost2)).append("\n");
        sb.append("    ldapHost3: ").append(this.toIndentedString(this.ldapHost3)).append("\n");
        sb.append("    ldapPort: ").append(this.toIndentedString(this.ldapPort)).append("\n");
        sb.append("    ldapSecure: ").append(this.toIndentedString(this.ldapSecure)).append("\n");
        sb.append("    ldapUsername: ").append(this.toIndentedString(this.ldapUsername)).append("\n");
        sb.append("    ldapUsernameField: ").append(this.toIndentedString(this.ldapUsernameField)).append("\n");
        sb.append("    ldapDomain: ").append(this.toIndentedString(this.ldapDomain)).append("\n");
        sb.append("    ldapUserAction: ").append(this.toIndentedString(this.ldapUserAction)).append("\n");
        sb.append("    ldapGroupAction: ").append(this.toIndentedString(this.ldapGroupAction)).append("\n");
        sb.append("    ldapUserIncludeGroups: ").append(this.toIndentedString(this.ldapUserIncludeGroups)).append("\n");
        sb.append("    ldapGroupExclusion: ").append(this.toIndentedString(this.ldapGroupExclusion)).append("\n");
        sb.append("    ldapGroupInclusion: ").append(this.toIndentedString(this.ldapGroupInclusion)).append("\n");
        sb.append("    ldapBaseDn: ").append(this.toIndentedString(this.ldapBaseDn)).append("\n");
        sb.append("    icon16File: ").append(this.toIndentedString(this.icon16File)).append("\n");
        sb.append("    icon16Delete: ").append(this.toIndentedString(this.icon16Delete)).append("\n");
        sb.append("    icon32File: ").append(this.toIndentedString(this.icon32File)).append("\n");
        sb.append("    icon32Delete: ").append(this.toIndentedString(this.icon32Delete)).append("\n");
        sb.append("    icon48File: ").append(this.toIndentedString(this.icon48File)).append("\n");
        sb.append("    icon48Delete: ").append(this.toIndentedString(this.icon48Delete)).append("\n");
        sb.append("    icon128File: ").append(this.toIndentedString(this.icon128File)).append("\n");
        sb.append("    icon128Delete: ").append(this.toIndentedString(this.icon128Delete)).append("\n");
        sb.append("    logoFile: ").append(this.toIndentedString(this.logoFile)).append("\n");
        sb.append("    logoDelete: ").append(this.toIndentedString(this.logoDelete)).append("\n");
        sb.append("    disable2faWithDelay: ").append(this.toIndentedString(this.disable2faWithDelay)).append("\n");
        sb.append("    ldapPasswordChange: ").append(this.toIndentedString(this.ldapPasswordChange)).append("\n");
        sb.append("    ldapPasswordChangeConfirmation: ").append(this.toIndentedString(this.ldapPasswordChangeConfirmation)).append("\n");
        sb.append("    smtpPassword: ").append(this.toIndentedString(this.smtpPassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

