/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Create user session (log in)")
public class SessionEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="login_token")
    private String loginToken = null;
    @JsonProperty(value="login_token_domain")
    private String loginTokenDomain = null;
    @JsonProperty(value="max_dir_listing_size")
    private Integer maxDirListingSize = null;
    @JsonProperty(value="multiple_regions")
    private Boolean multipleRegions = null;
    @JsonProperty(value="read_only")
    private Boolean readOnly = null;
    @JsonProperty(value="root_path")
    private String rootPath = null;
    @JsonProperty(value="site_id")
    private Integer siteId = null;
    @JsonProperty(value="ssl_required")
    private Boolean sslRequired = null;
    @JsonProperty(value="tls_disabled")
    private Boolean tlsDisabled = null;
    @JsonProperty(value="two_factor_setup_needed")
    private Boolean twoFactorSetupNeeded = null;
    @JsonProperty(value="allowed_2fa_method_sms")
    private Boolean allowed2faMethodSms = null;
    @JsonProperty(value="allowed_2fa_method_totp")
    private Boolean allowed2faMethodTotp = null;
    @JsonProperty(value="allowed_2fa_method_u2f")
    private Boolean allowed2faMethodU2f = null;
    @JsonProperty(value="allowed_2fa_method_yubi")
    private Boolean allowed2faMethodYubi = null;
    @JsonProperty(value="use_provided_modified_at")
    private Boolean useProvidedModifiedAt = null;
    @JsonProperty(value="windows_mode_ftp")
    private Boolean windowsModeFtp = null;

    public SessionEntity id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="60525f92e859c4c3d74cb02fd176b1525901b525", description="Session ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SessionEntity language(String language) {
        this.language = language;
        return this;
    }

    @Schema(example="en", description="Session language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public SessionEntity loginToken(String loginToken) {
        this.loginToken = loginToken;
        return this;
    }

    @Schema(example="@tok-randomcode", description="Login token. If set, this token will allow your user to log in via browser at the domain in `login_token_domain`.")
    public String getLoginToken() {
        return this.loginToken;
    }

    public void setLoginToken(String loginToken) {
        this.loginToken = loginToken;
    }

    public SessionEntity loginTokenDomain(String loginTokenDomain) {
        this.loginTokenDomain = loginTokenDomain;
        return this;
    }

    @Schema(example="https://mysite.files.com", description="Domain to use with `login_token`.")
    public String getLoginTokenDomain() {
        return this.loginTokenDomain;
    }

    public void setLoginTokenDomain(String loginTokenDomain) {
        this.loginTokenDomain = loginTokenDomain;
    }

    public SessionEntity maxDirListingSize(Integer maxDirListingSize) {
        this.maxDirListingSize = maxDirListingSize;
        return this;
    }

    @Schema(description="Maximum number of files to retrieve per folder for a directory listing.  This is based on the user's plan.")
    public Integer getMaxDirListingSize() {
        return this.maxDirListingSize;
    }

    public void setMaxDirListingSize(Integer maxDirListingSize) {
        this.maxDirListingSize = maxDirListingSize;
    }

    public SessionEntity multipleRegions(Boolean multipleRegions) {
        this.multipleRegions = multipleRegions;
        return this;
    }

    @Schema(example="true", description="Can access multiple regions?")
    public Boolean isMultipleRegions() {
        return this.multipleRegions;
    }

    public void setMultipleRegions(Boolean multipleRegions) {
        this.multipleRegions = multipleRegions;
    }

    public SessionEntity readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Schema(example="true", description="Is this session read only?")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SessionEntity rootPath(String rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    @Schema(description="Initial root path to start the user's session in.")
    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public SessionEntity siteId(Integer siteId) {
        this.siteId = siteId;
        return this;
    }

    @Schema(example="1", description="Site ID")
    public Integer getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public SessionEntity sslRequired(Boolean sslRequired) {
        this.sslRequired = sslRequired;
        return this;
    }

    @Schema(example="true", description="Is SSL required for this user?  (If so, ensure all your communications with this user use SSL.)")
    public Boolean isSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(Boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    public SessionEntity tlsDisabled(Boolean tlsDisabled) {
        this.tlsDisabled = tlsDisabled;
        return this;
    }

    @Schema(description="Is strong TLS disabled for this user? (If this is set to true, the site administrator has signaled that it is ok to use less secure TLS versions for this user.)")
    public Boolean isTlsDisabled() {
        return this.tlsDisabled;
    }

    public void setTlsDisabled(Boolean tlsDisabled) {
        this.tlsDisabled = tlsDisabled;
    }

    public SessionEntity twoFactorSetupNeeded(Boolean twoFactorSetupNeeded) {
        this.twoFactorSetupNeeded = twoFactorSetupNeeded;
        return this;
    }

    @Schema(description="If true, this user needs to add a Two Factor Authentication method before performing any further actions.")
    public Boolean isTwoFactorSetupNeeded() {
        return this.twoFactorSetupNeeded;
    }

    public void setTwoFactorSetupNeeded(Boolean twoFactorSetupNeeded) {
        this.twoFactorSetupNeeded = twoFactorSetupNeeded;
    }

    public SessionEntity allowed2faMethodSms(Boolean allowed2faMethodSms) {
        this.allowed2faMethodSms = allowed2faMethodSms;
        return this;
    }

    @Schema(example="true", description="Sent only if 2FA setup is needed. Is SMS two factor authentication allowed?")
    public Boolean isAllowed2faMethodSms() {
        return this.allowed2faMethodSms;
    }

    public void setAllowed2faMethodSms(Boolean allowed2faMethodSms) {
        this.allowed2faMethodSms = allowed2faMethodSms;
    }

    public SessionEntity allowed2faMethodTotp(Boolean allowed2faMethodTotp) {
        this.allowed2faMethodTotp = allowed2faMethodTotp;
        return this;
    }

    @Schema(example="true", description="Sent only if 2FA setup is needed. Is TOTP two factor authentication allowed?")
    public Boolean isAllowed2faMethodTotp() {
        return this.allowed2faMethodTotp;
    }

    public void setAllowed2faMethodTotp(Boolean allowed2faMethodTotp) {
        this.allowed2faMethodTotp = allowed2faMethodTotp;
    }

    public SessionEntity allowed2faMethodU2f(Boolean allowed2faMethodU2f) {
        this.allowed2faMethodU2f = allowed2faMethodU2f;
        return this;
    }

    @Schema(example="true", description="Sent only if 2FA setup is needed. Is U2F two factor authentication allowed?")
    public Boolean isAllowed2faMethodU2f() {
        return this.allowed2faMethodU2f;
    }

    public void setAllowed2faMethodU2f(Boolean allowed2faMethodU2f) {
        this.allowed2faMethodU2f = allowed2faMethodU2f;
    }

    public SessionEntity allowed2faMethodYubi(Boolean allowed2faMethodYubi) {
        this.allowed2faMethodYubi = allowed2faMethodYubi;
        return this;
    }

    @Schema(example="true", description="Sent only if 2FA setup is needed. Is Yubikey two factor authentication allowed?")
    public Boolean isAllowed2faMethodYubi() {
        return this.allowed2faMethodYubi;
    }

    public void setAllowed2faMethodYubi(Boolean allowed2faMethodYubi) {
        this.allowed2faMethodYubi = allowed2faMethodYubi;
    }

    public SessionEntity useProvidedModifiedAt(Boolean useProvidedModifiedAt) {
        this.useProvidedModifiedAt = useProvidedModifiedAt;
        return this;
    }

    @Schema(example="true", description="Allow the user to provide file/folder modified at dates?  If false, the server will always use the current date/time.")
    public Boolean isUseProvidedModifiedAt() {
        return this.useProvidedModifiedAt;
    }

    public void setUseProvidedModifiedAt(Boolean useProvidedModifiedAt) {
        this.useProvidedModifiedAt = useProvidedModifiedAt;
    }

    public SessionEntity windowsModeFtp(Boolean windowsModeFtp) {
        this.windowsModeFtp = windowsModeFtp;
        return this;
    }

    @Schema(description="Does this user want to use Windows line-ending emulation?  (CR vs CRLF)")
    public Boolean isWindowsModeFtp() {
        return this.windowsModeFtp;
    }

    public void setWindowsModeFtp(Boolean windowsModeFtp) {
        this.windowsModeFtp = windowsModeFtp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionEntity sessionEntity = (SessionEntity)o;
        return Objects.equals(this.id, sessionEntity.id) && Objects.equals(this.language, sessionEntity.language) && Objects.equals(this.loginToken, sessionEntity.loginToken) && Objects.equals(this.loginTokenDomain, sessionEntity.loginTokenDomain) && Objects.equals(this.maxDirListingSize, sessionEntity.maxDirListingSize) && Objects.equals(this.multipleRegions, sessionEntity.multipleRegions) && Objects.equals(this.readOnly, sessionEntity.readOnly) && Objects.equals(this.rootPath, sessionEntity.rootPath) && Objects.equals(this.siteId, sessionEntity.siteId) && Objects.equals(this.sslRequired, sessionEntity.sslRequired) && Objects.equals(this.tlsDisabled, sessionEntity.tlsDisabled) && Objects.equals(this.twoFactorSetupNeeded, sessionEntity.twoFactorSetupNeeded) && Objects.equals(this.allowed2faMethodSms, sessionEntity.allowed2faMethodSms) && Objects.equals(this.allowed2faMethodTotp, sessionEntity.allowed2faMethodTotp) && Objects.equals(this.allowed2faMethodU2f, sessionEntity.allowed2faMethodU2f) && Objects.equals(this.allowed2faMethodYubi, sessionEntity.allowed2faMethodYubi) && Objects.equals(this.useProvidedModifiedAt, sessionEntity.useProvidedModifiedAt) && Objects.equals(this.windowsModeFtp, sessionEntity.windowsModeFtp);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.language, this.loginToken, this.loginTokenDomain, this.maxDirListingSize, this.multipleRegions, this.readOnly, this.rootPath, this.siteId, this.sslRequired, this.tlsDisabled, this.twoFactorSetupNeeded, this.allowed2faMethodSms, this.allowed2faMethodTotp, this.allowed2faMethodU2f, this.allowed2faMethodYubi, this.useProvidedModifiedAt, this.windowsModeFtp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    loginToken: ").append(this.toIndentedString(this.loginToken)).append("\n");
        sb.append("    loginTokenDomain: ").append(this.toIndentedString(this.loginTokenDomain)).append("\n");
        sb.append("    maxDirListingSize: ").append(this.toIndentedString(this.maxDirListingSize)).append("\n");
        sb.append("    multipleRegions: ").append(this.toIndentedString(this.multipleRegions)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    rootPath: ").append(this.toIndentedString(this.rootPath)).append("\n");
        sb.append("    siteId: ").append(this.toIndentedString(this.siteId)).append("\n");
        sb.append("    sslRequired: ").append(this.toIndentedString(this.sslRequired)).append("\n");
        sb.append("    tlsDisabled: ").append(this.toIndentedString(this.tlsDisabled)).append("\n");
        sb.append("    twoFactorSetupNeeded: ").append(this.toIndentedString(this.twoFactorSetupNeeded)).append("\n");
        sb.append("    allowed2faMethodSms: ").append(this.toIndentedString(this.allowed2faMethodSms)).append("\n");
        sb.append("    allowed2faMethodTotp: ").append(this.toIndentedString(this.allowed2faMethodTotp)).append("\n");
        sb.append("    allowed2faMethodU2f: ").append(this.toIndentedString(this.allowed2faMethodU2f)).append("\n");
        sb.append("    allowed2faMethodYubi: ").append(this.toIndentedString(this.allowed2faMethodYubi)).append("\n");
        sb.append("    useProvidedModifiedAt: ").append(this.toIndentedString(this.useProvidedModifiedAt)).append("\n");
        sb.append("    windowsModeFtp: ").append(this.toIndentedString(this.windowsModeFtp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

