/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class RequestsBody {
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="destination")
    private String destination = null;
    @JsonProperty(value="user_ids")
    private String userIds = null;
    @JsonProperty(value="group_ids")
    private String groupIds = null;

    public RequestsBody path(String path) {
        this.path = path;
        return this;
    }

    @Schema(required=true, description="Folder path on which to request the file.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RequestsBody destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Schema(required=true, description="Destination filename (without extension) to request.")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public RequestsBody userIds(String userIds) {
        this.userIds = userIds;
        return this;
    }

    @Schema(description="A list of user IDs to request the file from. If sent as a string, it should be comma-delimited.")
    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public RequestsBody groupIds(String groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    @Schema(description="A list of group IDs to request the file from. If sent as a string, it should be comma-delimited.")
    public String getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestsBody requestsBody = (RequestsBody)o;
        return Objects.equals(this.path, requestsBody.path) && Objects.equals(this.destination, requestsBody.destination) && Objects.equals(this.userIds, requestsBody.userIds) && Objects.equals(this.groupIds, requestsBody.groupIds);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.destination, this.userIds, this.groupIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestsBody {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    groupIds: ").append(this.toIndentedString(this.groupIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

