/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Requests")
public class RequestEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="destination")
    private String destination = null;
    @JsonProperty(value="automation_id")
    private String automationId = null;
    @JsonProperty(value="user_display_name")
    private String userDisplayName = null;

    public RequestEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Request ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public RequestEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Folder path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RequestEntity source(String source) {
        this.source = source;
        return this;
    }

    @Schema(description="Source filename, if applicable")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public RequestEntity destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Schema(description="Destination filename")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public RequestEntity automationId(String automationId) {
        this.automationId = automationId;
        return this;
    }

    @Schema(description="ID of automation that created request")
    public String getAutomationId() {
        return this.automationId;
    }

    public void setAutomationId(String automationId) {
        this.automationId = automationId;
    }

    public RequestEntity userDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
        return this;
    }

    @Schema(description="User making the request (if applicable)")
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestEntity requestEntity = (RequestEntity)o;
        return Objects.equals(this.id, requestEntity.id) && Objects.equals(this.path, requestEntity.path) && Objects.equals(this.source, requestEntity.source) && Objects.equals(this.destination, requestEntity.destination) && Objects.equals(this.automationId, requestEntity.automationId) && Objects.equals(this.userDisplayName, requestEntity.userDisplayName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.source, this.destination, this.automationId, this.userDisplayName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    automationId: ").append(this.toIndentedString(this.automationId)).append("\n");
        sb.append("    userDisplayName: ").append(this.toIndentedString(this.userDisplayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

