/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Create Remote Server")
public class RemoteServerEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="authentication_method")
    private String authenticationMethod = null;
    @JsonProperty(value="hostname")
    private String hostname = null;
    @JsonProperty(value="remote_home_path")
    private String remoteHomePath = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="port")
    private Integer port = null;
    @JsonProperty(value="max_connections")
    private Integer maxConnections = null;
    @JsonProperty(value="s3_bucket")
    private String s3Bucket = null;
    @JsonProperty(value="s3_region")
    private String s3Region = null;
    @JsonProperty(value="server_certificate")
    private ServerCertificateEnum serverCertificate = null;
    @JsonProperty(value="server_host_key")
    private String serverHostKey = null;
    @JsonProperty(value="server_type")
    private ServerTypeEnum serverType = null;
    @JsonProperty(value="ssl")
    private SslEnum ssl = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="google_cloud_storage_bucket")
    private String googleCloudStorageBucket = null;
    @JsonProperty(value="google_cloud_storage_project_id")
    private String googleCloudStorageProjectId = null;
    @JsonProperty(value="backblaze_b2_s3_endpoint")
    private String backblazeB2S3Endpoint = null;
    @JsonProperty(value="backblaze_b2_bucket")
    private String backblazeB2Bucket = null;
    @JsonProperty(value="wasabi_bucket")
    private String wasabiBucket = null;
    @JsonProperty(value="wasabi_region")
    private String wasabiRegion = null;
    @JsonProperty(value="rackspace_username")
    private String rackspaceUsername = null;
    @JsonProperty(value="rackspace_region")
    private String rackspaceRegion = null;
    @JsonProperty(value="rackspace_container")
    private String rackspaceContainer = null;
    @JsonProperty(value="auth_setup_link")
    private String authSetupLink = null;
    @JsonProperty(value="auth_status")
    private AuthStatusEnum authStatus = null;
    @JsonProperty(value="auth_account_name")
    private String authAccountName = null;
    @JsonProperty(value="one_drive_account_type")
    private OneDriveAccountTypeEnum oneDriveAccountType = null;
    @JsonProperty(value="azure_blob_storage_account")
    private String azureBlobStorageAccount = null;
    @JsonProperty(value="azure_blob_storage_container")
    private String azureBlobStorageContainer = null;
    @JsonProperty(value="s3_compatible_bucket")
    private String s3CompatibleBucket = null;
    @JsonProperty(value="s3_compatible_region")
    private String s3CompatibleRegion = null;
    @JsonProperty(value="s3_compatible_endpoint")
    private String s3CompatibleEndpoint = null;

    public RemoteServerEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Remote server ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public RemoteServerEntity authenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @Schema(example="password", description="Type of authentication method")
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public RemoteServerEntity hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Schema(example="remote-server.com", description="Hostname or IP address")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public RemoteServerEntity remoteHomePath(String remoteHomePath) {
        this.remoteHomePath = remoteHomePath;
        return this;
    }

    @Schema(example="/home/user1", description="Initial home folder on remote server")
    public String getRemoteHomePath() {
        return this.remoteHomePath;
    }

    public void setRemoteHomePath(String remoteHomePath) {
        this.remoteHomePath = remoteHomePath;
    }

    public RemoteServerEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="My Remote server", description="Internal name for your reference")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RemoteServerEntity port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(example="1", description="Port for remote server.  Not needed for S3.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RemoteServerEntity maxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @Schema(example="1", description="Max number of parallel connections.  Ignored for S3 connections (we will parallelize these as much as possible).")
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public RemoteServerEntity s3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
        return this;
    }

    @Schema(example="my-bucket", description="S3 bucket name")
    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public RemoteServerEntity s3Region(String s3Region) {
        this.s3Region = s3Region;
        return this;
    }

    @Schema(example="us-east-1", description="S3 region")
    public String getS3Region() {
        return this.s3Region;
    }

    public void setS3Region(String s3Region) {
        this.s3Region = s3Region;
    }

    public RemoteServerEntity serverCertificate(ServerCertificateEnum serverCertificate) {
        this.serverCertificate = serverCertificate;
        return this;
    }

    @Schema(example="require_match", description="Remote server certificate")
    public ServerCertificateEnum getServerCertificate() {
        return this.serverCertificate;
    }

    public void setServerCertificate(ServerCertificateEnum serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public RemoteServerEntity serverHostKey(String serverHostKey) {
        this.serverHostKey = serverHostKey;
        return this;
    }

    @Schema(example="[public key]", description="Remote server SSH Host Key. If provided, we will require that the server host key matches the provided key. Uses OpenSSH format similar to what would go into ~/.ssh/known_hosts")
    public String getServerHostKey() {
        return this.serverHostKey;
    }

    public void setServerHostKey(String serverHostKey) {
        this.serverHostKey = serverHostKey;
    }

    public RemoteServerEntity serverType(ServerTypeEnum serverType) {
        this.serverType = serverType;
        return this;
    }

    @Schema(example="s3", description="Remote server type.")
    public ServerTypeEnum getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerTypeEnum serverType) {
        this.serverType = serverType;
    }

    public RemoteServerEntity ssl(SslEnum ssl) {
        this.ssl = ssl;
        return this;
    }

    @Schema(example="if_available", description="Should we require SSL?")
    public SslEnum getSsl() {
        return this.ssl;
    }

    public void setSsl(SslEnum ssl) {
        this.ssl = ssl;
    }

    public RemoteServerEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="user", description="Remote server username.  Not needed for S3 buckets.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public RemoteServerEntity googleCloudStorageBucket(String googleCloudStorageBucket) {
        this.googleCloudStorageBucket = googleCloudStorageBucket;
        return this;
    }

    @Schema(example="my-bucket", description="Google Cloud Storage bucket name")
    public String getGoogleCloudStorageBucket() {
        return this.googleCloudStorageBucket;
    }

    public void setGoogleCloudStorageBucket(String googleCloudStorageBucket) {
        this.googleCloudStorageBucket = googleCloudStorageBucket;
    }

    public RemoteServerEntity googleCloudStorageProjectId(String googleCloudStorageProjectId) {
        this.googleCloudStorageProjectId = googleCloudStorageProjectId;
        return this;
    }

    @Schema(example="my-project", description="Google Cloud Project ID")
    public String getGoogleCloudStorageProjectId() {
        return this.googleCloudStorageProjectId;
    }

    public void setGoogleCloudStorageProjectId(String googleCloudStorageProjectId) {
        this.googleCloudStorageProjectId = googleCloudStorageProjectId;
    }

    public RemoteServerEntity backblazeB2S3Endpoint(String backblazeB2S3Endpoint) {
        this.backblazeB2S3Endpoint = backblazeB2S3Endpoint;
        return this;
    }

    @Schema(example="s3.us-west-001.backblazeb2.com", description="Backblaze B2 Cloud Storage S3 Endpoint")
    public String getBackblazeB2S3Endpoint() {
        return this.backblazeB2S3Endpoint;
    }

    public void setBackblazeB2S3Endpoint(String backblazeB2S3Endpoint) {
        this.backblazeB2S3Endpoint = backblazeB2S3Endpoint;
    }

    public RemoteServerEntity backblazeB2Bucket(String backblazeB2Bucket) {
        this.backblazeB2Bucket = backblazeB2Bucket;
        return this;
    }

    @Schema(example="my-bucket", description="Backblaze B2 Cloud Storage Bucket name")
    public String getBackblazeB2Bucket() {
        return this.backblazeB2Bucket;
    }

    public void setBackblazeB2Bucket(String backblazeB2Bucket) {
        this.backblazeB2Bucket = backblazeB2Bucket;
    }

    public RemoteServerEntity wasabiBucket(String wasabiBucket) {
        this.wasabiBucket = wasabiBucket;
        return this;
    }

    @Schema(example="my-bucket", description="Wasabi Bucket name")
    public String getWasabiBucket() {
        return this.wasabiBucket;
    }

    public void setWasabiBucket(String wasabiBucket) {
        this.wasabiBucket = wasabiBucket;
    }

    public RemoteServerEntity wasabiRegion(String wasabiRegion) {
        this.wasabiRegion = wasabiRegion;
        return this;
    }

    @Schema(example="us-west-1", description="Wasabi region")
    public String getWasabiRegion() {
        return this.wasabiRegion;
    }

    public void setWasabiRegion(String wasabiRegion) {
        this.wasabiRegion = wasabiRegion;
    }

    public RemoteServerEntity rackspaceUsername(String rackspaceUsername) {
        this.rackspaceUsername = rackspaceUsername;
        return this;
    }

    @Schema(example="rackspaceuser", description="Rackspace username used to login to the Rackspace Cloud Control Panel.")
    public String getRackspaceUsername() {
        return this.rackspaceUsername;
    }

    public void setRackspaceUsername(String rackspaceUsername) {
        this.rackspaceUsername = rackspaceUsername;
    }

    public RemoteServerEntity rackspaceRegion(String rackspaceRegion) {
        this.rackspaceRegion = rackspaceRegion;
        return this;
    }

    @Schema(example="dfw", description="Three letter airport code for Rackspace region. See https://support.rackspace.com/how-to/about-regions/")
    public String getRackspaceRegion() {
        return this.rackspaceRegion;
    }

    public void setRackspaceRegion(String rackspaceRegion) {
        this.rackspaceRegion = rackspaceRegion;
    }

    public RemoteServerEntity rackspaceContainer(String rackspaceContainer) {
        this.rackspaceContainer = rackspaceContainer;
        return this;
    }

    @Schema(example="my-container", description="The name of the container (top level directory) where files will sync.")
    public String getRackspaceContainer() {
        return this.rackspaceContainer;
    }

    public void setRackspaceContainer(String rackspaceContainer) {
        this.rackspaceContainer = rackspaceContainer;
    }

    public RemoteServerEntity authSetupLink(String authSetupLink) {
        this.authSetupLink = authSetupLink;
        return this;
    }

    @Schema(example="auth/:provider", description="Returns link to login with an Oauth provider")
    public String getAuthSetupLink() {
        return this.authSetupLink;
    }

    public void setAuthSetupLink(String authSetupLink) {
        this.authSetupLink = authSetupLink;
    }

    public RemoteServerEntity authStatus(AuthStatusEnum authStatus) {
        this.authStatus = authStatus;
        return this;
    }

    @Schema(example="in_setup", description="Either `in_setup` or `complete`")
    public AuthStatusEnum getAuthStatus() {
        return this.authStatus;
    }

    public void setAuthStatus(AuthStatusEnum authStatus) {
        this.authStatus = authStatus;
    }

    public RemoteServerEntity authAccountName(String authAccountName) {
        this.authAccountName = authAccountName;
        return this;
    }

    @Schema(example="me@example.com", description="Describes the authorized account")
    public String getAuthAccountName() {
        return this.authAccountName;
    }

    public void setAuthAccountName(String authAccountName) {
        this.authAccountName = authAccountName;
    }

    public RemoteServerEntity oneDriveAccountType(OneDriveAccountTypeEnum oneDriveAccountType) {
        this.oneDriveAccountType = oneDriveAccountType;
        return this;
    }

    @Schema(example="personal", description="Either personal or business_other account types")
    public OneDriveAccountTypeEnum getOneDriveAccountType() {
        return this.oneDriveAccountType;
    }

    public void setOneDriveAccountType(OneDriveAccountTypeEnum oneDriveAccountType) {
        this.oneDriveAccountType = oneDriveAccountType;
    }

    public RemoteServerEntity azureBlobStorageAccount(String azureBlobStorageAccount) {
        this.azureBlobStorageAccount = azureBlobStorageAccount;
        return this;
    }

    @Schema(example="storage-account-name", description="Azure Blob Storage Account name")
    public String getAzureBlobStorageAccount() {
        return this.azureBlobStorageAccount;
    }

    public void setAzureBlobStorageAccount(String azureBlobStorageAccount) {
        this.azureBlobStorageAccount = azureBlobStorageAccount;
    }

    public RemoteServerEntity azureBlobStorageContainer(String azureBlobStorageContainer) {
        this.azureBlobStorageContainer = azureBlobStorageContainer;
        return this;
    }

    @Schema(example="container-name", description="Azure Blob Storage Container name")
    public String getAzureBlobStorageContainer() {
        return this.azureBlobStorageContainer;
    }

    public void setAzureBlobStorageContainer(String azureBlobStorageContainer) {
        this.azureBlobStorageContainer = azureBlobStorageContainer;
    }

    public RemoteServerEntity s3CompatibleBucket(String s3CompatibleBucket) {
        this.s3CompatibleBucket = s3CompatibleBucket;
        return this;
    }

    @Schema(example="my-bucket", description="S3-compatible Bucket name")
    public String getS3CompatibleBucket() {
        return this.s3CompatibleBucket;
    }

    public void setS3CompatibleBucket(String s3CompatibleBucket) {
        this.s3CompatibleBucket = s3CompatibleBucket;
    }

    public RemoteServerEntity s3CompatibleRegion(String s3CompatibleRegion) {
        this.s3CompatibleRegion = s3CompatibleRegion;
        return this;
    }

    @Schema(example="us-east-1", description="S3-compatible Bucket name")
    public String getS3CompatibleRegion() {
        return this.s3CompatibleRegion;
    }

    public void setS3CompatibleRegion(String s3CompatibleRegion) {
        this.s3CompatibleRegion = s3CompatibleRegion;
    }

    public RemoteServerEntity s3CompatibleEndpoint(String s3CompatibleEndpoint) {
        this.s3CompatibleEndpoint = s3CompatibleEndpoint;
        return this;
    }

    @Schema(example="mys3platform.com", description="S3-compatible endpoint")
    public String getS3CompatibleEndpoint() {
        return this.s3CompatibleEndpoint;
    }

    public void setS3CompatibleEndpoint(String s3CompatibleEndpoint) {
        this.s3CompatibleEndpoint = s3CompatibleEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteServerEntity remoteServerEntity = (RemoteServerEntity)o;
        return Objects.equals(this.id, remoteServerEntity.id) && Objects.equals(this.authenticationMethod, remoteServerEntity.authenticationMethod) && Objects.equals(this.hostname, remoteServerEntity.hostname) && Objects.equals(this.remoteHomePath, remoteServerEntity.remoteHomePath) && Objects.equals(this.name, remoteServerEntity.name) && Objects.equals(this.port, remoteServerEntity.port) && Objects.equals(this.maxConnections, remoteServerEntity.maxConnections) && Objects.equals(this.s3Bucket, remoteServerEntity.s3Bucket) && Objects.equals(this.s3Region, remoteServerEntity.s3Region) && Objects.equals((Object)this.serverCertificate, (Object)remoteServerEntity.serverCertificate) && Objects.equals(this.serverHostKey, remoteServerEntity.serverHostKey) && Objects.equals((Object)this.serverType, (Object)remoteServerEntity.serverType) && Objects.equals((Object)this.ssl, (Object)remoteServerEntity.ssl) && Objects.equals(this.username, remoteServerEntity.username) && Objects.equals(this.googleCloudStorageBucket, remoteServerEntity.googleCloudStorageBucket) && Objects.equals(this.googleCloudStorageProjectId, remoteServerEntity.googleCloudStorageProjectId) && Objects.equals(this.backblazeB2S3Endpoint, remoteServerEntity.backblazeB2S3Endpoint) && Objects.equals(this.backblazeB2Bucket, remoteServerEntity.backblazeB2Bucket) && Objects.equals(this.wasabiBucket, remoteServerEntity.wasabiBucket) && Objects.equals(this.wasabiRegion, remoteServerEntity.wasabiRegion) && Objects.equals(this.rackspaceUsername, remoteServerEntity.rackspaceUsername) && Objects.equals(this.rackspaceRegion, remoteServerEntity.rackspaceRegion) && Objects.equals(this.rackspaceContainer, remoteServerEntity.rackspaceContainer) && Objects.equals(this.authSetupLink, remoteServerEntity.authSetupLink) && Objects.equals((Object)this.authStatus, (Object)remoteServerEntity.authStatus) && Objects.equals(this.authAccountName, remoteServerEntity.authAccountName) && Objects.equals((Object)this.oneDriveAccountType, (Object)remoteServerEntity.oneDriveAccountType) && Objects.equals(this.azureBlobStorageAccount, remoteServerEntity.azureBlobStorageAccount) && Objects.equals(this.azureBlobStorageContainer, remoteServerEntity.azureBlobStorageContainer) && Objects.equals(this.s3CompatibleBucket, remoteServerEntity.s3CompatibleBucket) && Objects.equals(this.s3CompatibleRegion, remoteServerEntity.s3CompatibleRegion) && Objects.equals(this.s3CompatibleEndpoint, remoteServerEntity.s3CompatibleEndpoint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.authenticationMethod, this.hostname, this.remoteHomePath, this.name, this.port, this.maxConnections, this.s3Bucket, this.s3Region, this.serverCertificate, this.serverHostKey, this.serverType, this.ssl, this.username, this.googleCloudStorageBucket, this.googleCloudStorageProjectId, this.backblazeB2S3Endpoint, this.backblazeB2Bucket, this.wasabiBucket, this.wasabiRegion, this.rackspaceUsername, this.rackspaceRegion, this.rackspaceContainer, this.authSetupLink, this.authStatus, this.authAccountName, this.oneDriveAccountType, this.azureBlobStorageAccount, this.azureBlobStorageContainer, this.s3CompatibleBucket, this.s3CompatibleRegion, this.s3CompatibleEndpoint});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemoteServerEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString(this.authenticationMethod)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    remoteHomePath: ").append(this.toIndentedString(this.remoteHomePath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    maxConnections: ").append(this.toIndentedString(this.maxConnections)).append("\n");
        sb.append("    s3Bucket: ").append(this.toIndentedString(this.s3Bucket)).append("\n");
        sb.append("    s3Region: ").append(this.toIndentedString(this.s3Region)).append("\n");
        sb.append("    serverCertificate: ").append(this.toIndentedString((Object)this.serverCertificate)).append("\n");
        sb.append("    serverHostKey: ").append(this.toIndentedString(this.serverHostKey)).append("\n");
        sb.append("    serverType: ").append(this.toIndentedString((Object)this.serverType)).append("\n");
        sb.append("    ssl: ").append(this.toIndentedString((Object)this.ssl)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    googleCloudStorageBucket: ").append(this.toIndentedString(this.googleCloudStorageBucket)).append("\n");
        sb.append("    googleCloudStorageProjectId: ").append(this.toIndentedString(this.googleCloudStorageProjectId)).append("\n");
        sb.append("    backblazeB2S3Endpoint: ").append(this.toIndentedString(this.backblazeB2S3Endpoint)).append("\n");
        sb.append("    backblazeB2Bucket: ").append(this.toIndentedString(this.backblazeB2Bucket)).append("\n");
        sb.append("    wasabiBucket: ").append(this.toIndentedString(this.wasabiBucket)).append("\n");
        sb.append("    wasabiRegion: ").append(this.toIndentedString(this.wasabiRegion)).append("\n");
        sb.append("    rackspaceUsername: ").append(this.toIndentedString(this.rackspaceUsername)).append("\n");
        sb.append("    rackspaceRegion: ").append(this.toIndentedString(this.rackspaceRegion)).append("\n");
        sb.append("    rackspaceContainer: ").append(this.toIndentedString(this.rackspaceContainer)).append("\n");
        sb.append("    authSetupLink: ").append(this.toIndentedString(this.authSetupLink)).append("\n");
        sb.append("    authStatus: ").append(this.toIndentedString((Object)this.authStatus)).append("\n");
        sb.append("    authAccountName: ").append(this.toIndentedString(this.authAccountName)).append("\n");
        sb.append("    oneDriveAccountType: ").append(this.toIndentedString((Object)this.oneDriveAccountType)).append("\n");
        sb.append("    azureBlobStorageAccount: ").append(this.toIndentedString(this.azureBlobStorageAccount)).append("\n");
        sb.append("    azureBlobStorageContainer: ").append(this.toIndentedString(this.azureBlobStorageContainer)).append("\n");
        sb.append("    s3CompatibleBucket: ").append(this.toIndentedString(this.s3CompatibleBucket)).append("\n");
        sb.append("    s3CompatibleRegion: ").append(this.toIndentedString(this.s3CompatibleRegion)).append("\n");
        sb.append("    s3CompatibleEndpoint: ").append(this.toIndentedString(this.s3CompatibleEndpoint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ServerCertificateEnum {
        REQUIRE_MATCH("require_match"),
        ALLOW_ANY("allow_any");

        private String value;

        private ServerCertificateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServerCertificateEnum fromValue(String text) {
            for (ServerCertificateEnum b : ServerCertificateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ServerTypeEnum {
        FTP("ftp"),
        SFTP("sftp"),
        S3("s3"),
        GOOGLE_CLOUD_STORAGE("google_cloud_storage"),
        WEBDAV("webdav"),
        WASABI("wasabi"),
        BACKBLAZE_B2("backblaze_b2"),
        ONE_DRIVE("one_drive"),
        RACKSPACE("rackspace"),
        BOX("box"),
        DROPBOX("dropbox"),
        GOOGLE_DRIVE("google_drive"),
        AZURE("azure"),
        SHAREPOINT("sharepoint"),
        S3_COMPATIBLE("s3_compatible");

        private String value;

        private ServerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServerTypeEnum fromValue(String text) {
            for (ServerTypeEnum b : ServerTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum SslEnum {
        IF_AVAILABLE("if_available"),
        REQUIRE("require"),
        REQUIRE_IMPLICIT("require_implicit"),
        NEVER("never");

        private String value;

        private SslEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SslEnum fromValue(String text) {
            for (SslEnum b : SslEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AuthStatusEnum {
        NOT_APPLICABLE("not_applicable"),
        IN_SETUP("in_setup"),
        COMPLETE("complete"),
        REAUTHENTICATE("reauthenticate");

        private String value;

        private AuthStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthStatusEnum fromValue(String text) {
            for (AuthStatusEnum b : AuthStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum OneDriveAccountTypeEnum {
        PERSONAL("personal"),
        BUSINESS_OTHER("business_other");

        private String value;

        private OneDriveAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OneDriveAccountTypeEnum fromValue(String text) {
            for (OneDriveAccountTypeEnum b : OneDriveAccountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

