/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Public Keys")
public class PublicKeyEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="fingerprint")
    private String fingerprint = null;

    public PublicKeyEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Public key ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PublicKeyEntity title(String title) {
        this.title = title;
        return this;
    }

    @Schema(example="My public key", description="Public key title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PublicKeyEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Public key created at date/time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PublicKeyEntity fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @Schema(example="43:51:43:a1:b5:fc:8b:b7:0a:3a:a9:b1:0f:66:73:a8", description="Public key fingerprint")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyEntity publicKeyEntity = (PublicKeyEntity)o;
        return Objects.equals(this.id, publicKeyEntity.id) && Objects.equals(this.title, publicKeyEntity.title) && Objects.equals(this.createdAt, publicKeyEntity.createdAt) && Objects.equals(this.fingerprint, publicKeyEntity.fingerprint);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.createdAt, this.fingerprint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PublicKeyEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

