/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Projects")
public class ProjectEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="global_access")
    private GlobalAccessEnum globalAccess = null;

    public ProjectEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Project ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ProjectEntity globalAccess(GlobalAccessEnum globalAccess) {
        this.globalAccess = globalAccess;
        return this;
    }

    @Schema(example="none", description="Global access settings")
    public GlobalAccessEnum getGlobalAccess() {
        return this.globalAccess;
    }

    public void setGlobalAccess(GlobalAccessEnum globalAccess) {
        this.globalAccess = globalAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectEntity projectEntity = (ProjectEntity)o;
        return Objects.equals(this.id, projectEntity.id) && Objects.equals((Object)this.globalAccess, (Object)projectEntity.globalAccess);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.globalAccess});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    globalAccess: ").append(this.toIndentedString((Object)this.globalAccess)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GlobalAccessEnum {
        NONE("none"),
        ANYONE_WITH_READ("anyone_with_read"),
        ANYONE_WITH_FULL("anyone_with_full");

        private String value;

        private GlobalAccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GlobalAccessEnum fromValue(String text) {
            for (GlobalAccessEnum b : GlobalAccessEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

