/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Permissions")
public class PermissionEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="group_id")
    private Integer groupId = null;
    @JsonProperty(value="group_name")
    private String groupName = null;
    @JsonProperty(value="permission")
    private PermissionEnum permission = null;
    @JsonProperty(value="recursive")
    private Boolean recursive = null;

    public PermissionEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Permission ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PermissionEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Folder path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PermissionEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="User ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public PermissionEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="Sser", description="User's username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public PermissionEntity groupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    @Schema(example="0", description="Group ID")
    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public PermissionEntity groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Schema(description="Group name if applicable")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public PermissionEntity permission(PermissionEnum permission) {
        this.permission = permission;
        return this;
    }

    @Schema(example="full", description="Permission type")
    public PermissionEnum getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionEnum permission) {
        this.permission = permission;
    }

    public PermissionEntity recursive(Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Schema(example="true", description="Does this permission apply to subfolders?")
    public Boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionEntity permissionEntity = (PermissionEntity)o;
        return Objects.equals(this.id, permissionEntity.id) && Objects.equals(this.path, permissionEntity.path) && Objects.equals(this.userId, permissionEntity.userId) && Objects.equals(this.username, permissionEntity.username) && Objects.equals(this.groupId, permissionEntity.groupId) && Objects.equals(this.groupName, permissionEntity.groupName) && Objects.equals((Object)this.permission, (Object)permissionEntity.permission) && Objects.equals(this.recursive, permissionEntity.recursive);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.path, this.userId, this.username, this.groupId, this.groupName, this.permission, this.recursive});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString((Object)this.permission)).append("\n");
        sb.append("    recursive: ").append(this.toIndentedString(this.recursive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionEnum {
        FULL("full"),
        READONLY("readonly"),
        WRITEONLY("writeonly"),
        LIST("list"),
        HISTORY("history"),
        ADMIN("admin"),
        BUNDLE("bundle");

        private String value;

        private PermissionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionEnum fromValue(String text) {
            for (PermissionEnum b : PermissionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

