/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class NotificationsBody {
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="notify_on_copy")
    private Boolean notifyOnCopy = null;
    @JsonProperty(value="notify_user_actions")
    private Boolean notifyUserActions = null;
    @JsonProperty(value="recursive")
    private Boolean recursive = null;
    @JsonProperty(value="send_interval")
    private String sendInterval = null;
    @JsonProperty(value="group_id")
    private Integer groupId = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="username")
    private String username = null;

    public NotificationsBody userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="The id of the user to notify. Provide `user_id`, `username` or `group_id`.")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public NotificationsBody notifyOnCopy(Boolean notifyOnCopy) {
        this.notifyOnCopy = notifyOnCopy;
        return this;
    }

    @Schema(description="If `true`, copying or moving resources into this path will trigger a notification, in addition to just uploads.")
    public Boolean isNotifyOnCopy() {
        return this.notifyOnCopy;
    }

    public void setNotifyOnCopy(Boolean notifyOnCopy) {
        this.notifyOnCopy = notifyOnCopy;
    }

    public NotificationsBody notifyUserActions(Boolean notifyUserActions) {
        this.notifyUserActions = notifyUserActions;
        return this;
    }

    @Schema(description="If `true` actions initiated by the user will still result in a notification")
    public Boolean isNotifyUserActions() {
        return this.notifyUserActions;
    }

    public void setNotifyUserActions(Boolean notifyUserActions) {
        this.notifyUserActions = notifyUserActions;
    }

    public NotificationsBody recursive(Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Schema(description="If `true`, enable notifications for each subfolder in this path")
    public Boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public NotificationsBody sendInterval(String sendInterval) {
        this.sendInterval = sendInterval;
        return this;
    }

    @Schema(example="daily", description="The time interval that notifications are aggregated by.  Can be `five_minutes`, `fifteen_minutes`, `hourly`, or `daily`.")
    public String getSendInterval() {
        return this.sendInterval;
    }

    public void setSendInterval(String sendInterval) {
        this.sendInterval = sendInterval;
    }

    public NotificationsBody groupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    @Schema(description="The ID of the group to notify.  Provide `user_id`, `username` or `group_id`.")
    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public NotificationsBody path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public NotificationsBody username(String username) {
        this.username = username;
        return this;
    }

    @Schema(description="The username of the user to notify.  Provide `user_id`, `username` or `group_id`.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationsBody notificationsBody = (NotificationsBody)o;
        return Objects.equals(this.userId, notificationsBody.userId) && Objects.equals(this.notifyOnCopy, notificationsBody.notifyOnCopy) && Objects.equals(this.notifyUserActions, notificationsBody.notifyUserActions) && Objects.equals(this.recursive, notificationsBody.recursive) && Objects.equals(this.sendInterval, notificationsBody.sendInterval) && Objects.equals(this.groupId, notificationsBody.groupId) && Objects.equals(this.path, notificationsBody.path) && Objects.equals(this.username, notificationsBody.username);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.notifyOnCopy, this.notifyUserActions, this.recursive, this.sendInterval, this.groupId, this.path, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationsBody {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    notifyOnCopy: ").append(this.toIndentedString(this.notifyOnCopy)).append("\n");
        sb.append("    notifyUserActions: ").append(this.toIndentedString(this.notifyUserActions)).append("\n");
        sb.append("    recursive: ").append(this.toIndentedString(this.recursive)).append("\n");
        sb.append("    sendInterval: ").append(this.toIndentedString(this.sendInterval)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

