/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Notifications")
public class NotificationEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="group_id")
    private Integer groupId = null;
    @JsonProperty(value="group_name")
    private String groupName = null;
    @JsonProperty(value="notify_user_actions")
    private Boolean notifyUserActions = null;
    @JsonProperty(value="notify_on_copy")
    private Boolean notifyOnCopy = null;
    @JsonProperty(value="recursive")
    private Boolean recursive = null;
    @JsonProperty(value="send_interval")
    private SendIntervalEnum sendInterval = null;
    @JsonProperty(value="unsubscribed")
    private Boolean unsubscribed = null;
    @JsonProperty(value="unsubscribed_reason")
    private UnsubscribedReasonEnum unsubscribedReason = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="suppressed_email")
    private Boolean suppressedEmail = null;

    public NotificationEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Notification ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public NotificationEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="path", description="Folder path to notify on")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public NotificationEntity groupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    @Schema(example="0", description="Notification group id")
    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public NotificationEntity groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Schema(description="Group name if applicable")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public NotificationEntity notifyUserActions(Boolean notifyUserActions) {
        this.notifyUserActions = notifyUserActions;
        return this;
    }

    @Schema(example="true", description="Trigger notification on notification user actions?")
    public Boolean isNotifyUserActions() {
        return this.notifyUserActions;
    }

    public void setNotifyUserActions(Boolean notifyUserActions) {
        this.notifyUserActions = notifyUserActions;
    }

    public NotificationEntity notifyOnCopy(Boolean notifyOnCopy) {
        this.notifyOnCopy = notifyOnCopy;
        return this;
    }

    @Schema(example="true", description="Triggers notification when moving or copying files to this path")
    public Boolean isNotifyOnCopy() {
        return this.notifyOnCopy;
    }

    public void setNotifyOnCopy(Boolean notifyOnCopy) {
        this.notifyOnCopy = notifyOnCopy;
    }

    public NotificationEntity recursive(Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Schema(example="true", description="Enable notifications for each subfolder in this path")
    public Boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public NotificationEntity sendInterval(SendIntervalEnum sendInterval) {
        this.sendInterval = sendInterval;
        return this;
    }

    @Schema(example="fifteen_minutes", description="The time interval that notifications are aggregated to")
    public SendIntervalEnum getSendInterval() {
        return this.sendInterval;
    }

    public void setSendInterval(SendIntervalEnum sendInterval) {
        this.sendInterval = sendInterval;
    }

    public NotificationEntity unsubscribed(Boolean unsubscribed) {
        this.unsubscribed = unsubscribed;
        return this;
    }

    @Schema(example="true", description="Is the user unsubscribed from this notification?")
    public Boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    public void setUnsubscribed(Boolean unsubscribed) {
        this.unsubscribed = unsubscribed;
    }

    public NotificationEntity unsubscribedReason(UnsubscribedReasonEnum unsubscribedReason) {
        this.unsubscribedReason = unsubscribedReason;
        return this;
    }

    @Schema(description="The reason that the user unsubscribed")
    public UnsubscribedReasonEnum getUnsubscribedReason() {
        return this.unsubscribedReason;
    }

    public void setUnsubscribedReason(UnsubscribedReasonEnum unsubscribedReason) {
        this.unsubscribedReason = unsubscribedReason;
    }

    public NotificationEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="Notification user ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public NotificationEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="User", description="Notification username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public NotificationEntity suppressedEmail(Boolean suppressedEmail) {
        this.suppressedEmail = suppressedEmail;
        return this;
    }

    @Schema(example="false", description="If true, it means that the recipient at this user's email address has manually unsubscribed from all emails, or had their email \"hard bounce\", which means that we are unable to send mail to this user's current email address. Notifications will resume if the user changes their email address.")
    public Boolean isSuppressedEmail() {
        return this.suppressedEmail;
    }

    public void setSuppressedEmail(Boolean suppressedEmail) {
        this.suppressedEmail = suppressedEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationEntity notificationEntity = (NotificationEntity)o;
        return Objects.equals(this.id, notificationEntity.id) && Objects.equals(this.path, notificationEntity.path) && Objects.equals(this.groupId, notificationEntity.groupId) && Objects.equals(this.groupName, notificationEntity.groupName) && Objects.equals(this.notifyUserActions, notificationEntity.notifyUserActions) && Objects.equals(this.notifyOnCopy, notificationEntity.notifyOnCopy) && Objects.equals(this.recursive, notificationEntity.recursive) && Objects.equals((Object)this.sendInterval, (Object)notificationEntity.sendInterval) && Objects.equals(this.unsubscribed, notificationEntity.unsubscribed) && Objects.equals((Object)this.unsubscribedReason, (Object)notificationEntity.unsubscribedReason) && Objects.equals(this.userId, notificationEntity.userId) && Objects.equals(this.username, notificationEntity.username) && Objects.equals(this.suppressedEmail, notificationEntity.suppressedEmail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.path, this.groupId, this.groupName, this.notifyUserActions, this.notifyOnCopy, this.recursive, this.sendInterval, this.unsubscribed, this.unsubscribedReason, this.userId, this.username, this.suppressedEmail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    notifyUserActions: ").append(this.toIndentedString(this.notifyUserActions)).append("\n");
        sb.append("    notifyOnCopy: ").append(this.toIndentedString(this.notifyOnCopy)).append("\n");
        sb.append("    recursive: ").append(this.toIndentedString(this.recursive)).append("\n");
        sb.append("    sendInterval: ").append(this.toIndentedString((Object)this.sendInterval)).append("\n");
        sb.append("    unsubscribed: ").append(this.toIndentedString(this.unsubscribed)).append("\n");
        sb.append("    unsubscribedReason: ").append(this.toIndentedString((Object)this.unsubscribedReason)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    suppressedEmail: ").append(this.toIndentedString(this.suppressedEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SendIntervalEnum {
        FIVE_MINUTES("five_minutes"),
        FIFTEEN_MINUTES("fifteen_minutes"),
        HOURLY("hourly"),
        DAILY("daily");

        private String value;

        private SendIntervalEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SendIntervalEnum fromValue(String text) {
            for (SendIntervalEnum b : SendIntervalEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum UnsubscribedReasonEnum {
        NONE("none"),
        UNSUBSCRIBE_LINK_CLICKED("unsubscribe_link_clicked"),
        MAIL_BOUNCED("mail_bounced"),
        MAIL_MARKED_AS_SPAM("mail_marked_as_spam");

        private String value;

        private UnsubscribedReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UnsubscribedReasonEnum fromValue(String text) {
            for (UnsubscribedReasonEnum b : UnsubscribedReasonEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

